/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.timer.mdb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.timer.common.TimerImpl;
import com.sun.ts.tests.ejb.ee.timer.common.TimerInfo;
import com.sun.ts.tests.ejb.ee.timer.helper.FlagStore;
import com.sun.ts.tests.ejb.ee.timer.helper.FlagStoreHome;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.ejb.TimedObject;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerHandle;
import jakarta.ejb.TimerService;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class MsgBean
implements MessageDrivenBean,
MessageListener,
TimedObject {
    private static final String queueName = "java:comp/env/jms/ReplyQueue";
    private static final String queueFactoryName = "java:comp/env/jms/MyQueueConnectionFactory";
    private Queue replyQueue;
    private QueueConnectionFactory qcFactory;
    public TSNamingContext nctx;
    protected MessageDrivenContext mctx;
    private FlagStoreHome flagStoreHome;
    private FlagStore flagStoreRef;

    public void ejbCreate() {
        try {
            TestUtil.logTrace((String)"timer/mdb - ejbCreate()");
            this.nctx = new TSNamingContext();
            TestUtil.logTrace((String)"Looking up java:comp/env/jms/MyQueueConnectionFactory");
            this.qcFactory = (QueueConnectionFactory)this.nctx.lookup(queueFactoryName);
            TestUtil.logTrace((String)"Looking up java:comp/env/jms/ReplyQueue");
            this.replyQueue = (Queue)this.nctx.lookup(queueName);
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception in ejbCreate()", e);
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mctx) {
        TestUtil.logTrace((String)"timer/mdb - setMessageDrivenContext()");
        this.mctx = mctx;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"timer/mdb - ejbRemove()");
    }

    public void onMessage(Message msg) {
        String methodToRun = "Undefined";
        Properties props = null;
        String propsList = "";
        try {
            props = this.getProperties(msg);
            TestUtil.init((Properties)props);
        }
        catch (JMSException je) {
            System.out.println("JMSException caught getting Properties");
        }
        catch (RemoteLoggingInitException e) {
            System.out.println("RemoteLoggingInitException caught initializing Props");
        }
        try {
            methodToRun = ((TextMessage)msg).getText();
            TestUtil.logTrace((String)("Will run method: " + methodToRun + " at time " + System.currentTimeMillis()));
            this.runMethod(methodToRun);
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception in onMessage()", e);
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, "Exception in onMessage():" + e.toString());
        }
    }

    private void runMethod(String methodToRunName) throws Exception {
        Class[] params = null;
        Class[] params1 = new Class[]{Integer.class};
        Object[] args = null;
        int timerType = Integer.parseInt(TestUtil.getProperty((String)"timer_type"));
        if (timerType != 0) {
            args = new Object[]{new Integer(timerType)};
            params = params1;
        }
        TestUtil.logTrace((String)("run method '" + methodToRunName + "'"));
        Class<?> testDriverClass = this.getClass();
        Method methodToRun = testDriverClass.getMethod(methodToRunName, params);
        methodToRun.invoke((Object)this, args);
    }

    public void ejbTimeout(Timer timer) {
        String message;
        int timeoutAction;
        TestUtil.logTrace((String)("EJB_TIMEOUT: ejbTimeout called at " + System.currentTimeMillis()));
        try {
            Serializable sz = timer.getInfo();
            if (!(sz instanceof Integer)) {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No action required");
                return;
            }
            timeoutAction = (Integer)sz;
            TestUtil.logTrace((String)("EJB_TIMEOUT: timeoutAction is " + timeoutAction + " at " + System.currentTimeMillis()));
        }
        catch (Exception e) {
            TimerImpl.handleException("ejbTimeout initialization", e);
            return;
        }
        switch (timeoutAction) {
            case -1: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: No message sent - return");
                return;
            }
            case 1: {
                message = "hello from ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Access OK, sending JMS message");
                break;
            }
            case 2: {
                message = TimerImpl.accessCheckedMethod(this.nctx) ? "checked method successfully accessed in ejbTimeout" : "checked method access failed in ejbTimeout";
                TestUtil.logTrace((String)"EJB_TIMEOUT: Sending results of attempt to access checked method...");
                break;
            }
            case 3: {
                try {
                    TestUtil.logTrace((String)"EJB_TIMEOUT: finding flag store bean");
                    this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
                    this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
                    TestUtil.logTrace((String)"EJB_TIMEOUT: checking flag in flag store bean");
                    if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                        TestUtil.logTrace((String)"EJB_TIMEOUT: flag is false - set it and rollback");
                        this.flagStoreRef.setRequiresNewAccessFlag(true);
                        this.mctx.setRollbackOnly();
                        return;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: flag is true - send a message");
                    TestUtil.logTrace((String)"removing flag store bean");
                    this.flagStoreRef.remove();
                    message = "ejbTimeout has been successfully retried";
                }
                catch (Exception e) {
                    TimerImpl.handleException("ejbTimeout retry", e);
                    TestUtil.logTrace((String)"removing flag store bean");
                    if (this.flagStoreRef != null) {
                        try {
                            this.flagStoreRef.remove();
                        }
                        catch (Exception re) {
                            TimerImpl.handleException("exception removing FlagStore bean", e);
                        }
                    }
                    message = "Retry of ejbTimeout resulted in an exception";
                }
                break;
            }
            case 4: {
                try {
                    TestUtil.logTrace((String)"EJB_TIMEOUT: finding flag store bean");
                    this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
                    this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
                    TestUtil.logTrace((String)"EJB_TIMEOUT: checking flags in flag store bean");
                    if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                        if (this.flagStoreRef.getRequiredAccessFlag()) {
                            TestUtil.logErr((String)"EJB_TIMEOUT: Unexpected value of Required flag: true when RequiresNew flag is false");
                            message = "Transaction rollback failed in ejbTimeout";
                            break;
                        }
                        TestUtil.logTrace((String)"EJB_TIMEOUT: both flags unset, set them and rollback");
                        this.flagStoreRef.setRequiresNewAccessFlag(true);
                        this.flagStoreRef.setRequiredAccessFlag(true);
                        this.mctx.setRollbackOnly();
                        return;
                    }
                    TestUtil.logTrace((String)"EJB_TIMEOUT: RequiresNew flag is true - checking the Required flag");
                    if (this.flagStoreRef.getRequiredAccessFlag()) {
                        TestUtil.logErr((String)"EJB_TIMEOUT: Unexpected value of Required flag: true when RequiresNew flag is true");
                        message = "Transaction rollback failed in ejbTimeout";
                        break;
                    }
                    TestUtil.logTrace((String)"removing flag store bean");
                    this.flagStoreRef.remove();
                    message = "Transaction has been successfully rolled back in ejbTimeout";
                }
                catch (Exception e) {
                    TimerImpl.handleException("ejbTimeout rollback", e);
                    TestUtil.logTrace((String)"removing flag store bean");
                    if (this.flagStoreRef != null) {
                        try {
                            this.flagStoreRef.remove();
                        }
                        catch (Exception re) {
                            TimerImpl.handleException("exception removing FlagStore bean", e);
                        }
                    }
                    message = "Transaction rollback failed in ejbTimeout";
                }
                break;
            }
            case 5: {
                TestUtil.logTrace((String)"EJB_TIMEOUT: Getting timer handle...");
                TimerHandle handle = TimerImpl.getTimerHandleFromEjbTimeout(this.mctx.getTimerService(), 5);
                if (handle == null) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Null handle received from getTimerHandleFromEjbTimeout()");
                    message = "Timer handle serialization failed in ejbTimeout";
                    break;
                }
                TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying handle is serializable...");
                if (!TimerImpl.isSerializable(handle)) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Timer handle is not serializable");
                    message = "Timer handle serialization failed in ejbTimeout";
                    break;
                }
                TestUtil.logTrace((String)"EJB_TIMEOUT: Getting deserialized handle...");
                TimerHandle deserializedHandle = TimerImpl.getDeserializedHandle(handle);
                TestUtil.logTrace((String)"EJB_TIMEOUT: Verifying timers are identical...");
                if (!TimerImpl.timersAreIdentical(handle, deserializedHandle)) {
                    TestUtil.logErr((String)"EJB_TIMEOUT: Timers are not identical");
                    message = "Timer handle serialization failed in ejbTimeout";
                    break;
                }
                message = "Timer handle successfully serialized in ejbTimeout";
                break;
            }
            default: {
                message = "Invalid action specified in ejbTimeout";
            }
        }
        TestUtil.logTrace((String)("EJB_TIMEOUT: Sending message at " + System.currentTimeMillis()));
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void getInfoStrAndCancel(Integer timerType) {
        String infoStr = "info";
        String message = null;
        boolean pass = false;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerHandle handle = TimerImpl.createTimerHandle(timer_type, (Serializable)((Object)infoStr), ts);
            String returnStr = (String)((Object)TimerImpl.getInfo(handle));
            if (returnStr.equals(infoStr)) {
                pass = true;
            } else {
                message = "getInfo failed: input = " + infoStr + ", return value = " + returnStr;
                TestUtil.logErr((String)message);
            }
            if (pass) {
                TimerImpl.cancelTimer(handle);
                TestUtil.logTrace((String)"Timer cancelled.");
                message = TestUtil.getProperty((String)"testName");
            }
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoStrAndCancel", e);
            message = e.toString();
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void getInfoClassAndCancel(Integer timerType) {
        String message = null;
        boolean pass = false;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerInfo infoClass = new TimerInfo("string", 1, true, 3.1415926);
            TimerHandle handle = TimerImpl.createTimerHandle(timer_type, infoClass, ts);
            TimerInfo returnClass = (TimerInfo)TimerImpl.getInfo(handle);
            if (returnClass.equals(infoClass)) {
                pass = true;
            } else {
                message = "getInfo failed: input = " + infoClass + ", return value = " + returnClass;
                TestUtil.logErr((String)message);
            }
            if (pass) {
                TimerImpl.cancelTimer(handle);
                TestUtil.logTrace((String)"Timer cancelled.");
                message = TestUtil.getProperty((String)"testName");
            }
        }
        catch (Exception e) {
            TimerImpl.handleException("getInfoClassAndCancel", e);
            message = e.toString();
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void checkedMethodAccess(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.initializeTimer(timer_type, 2);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("checkedMethodAccess", e);
        }
        if (!initialized) {
            message = "timer initialization failure";
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
    }

    public void verifyTimeoutCall(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.initializeTimer(timer_type, 1);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("verifyTimeoutCall", e);
        }
        if (!initialized) {
            message = "timer initialization failure";
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
    }

    public void createAndRollback(Integer timerType) {
        String message = null;
        try {
            TestUtil.logTrace((String)"finding flag store bean");
            this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
            this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
            TestUtil.logTrace((String)"checking flag in flag store bean");
            if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                TestUtil.logTrace((String)"flag is false - initialize timer, set flag and rollback");
                int timer_type = timerType;
                TimerService ts = this.mctx.getTimerService();
                TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
                Timer timer = TimerImpl.createTimer(timer_type, new Integer(1), ts);
                this.flagStoreRef.setRequiresNewAccessFlag(true);
                TestUtil.logTrace((String)"calling setRollbackOnly()");
                this.mctx.setRollbackOnly();
                return;
            }
            TestUtil.logTrace((String)"flag is true - send a message");
            this.flagStoreRef.remove();
            message = "Rollback occurred as expected";
        }
        catch (Exception e) {
            message = "exception in createAndRollback " + e.toString();
            if (this.flagStoreRef != null) {
                try {
                    this.flagStoreRef.remove();
                }
                catch (Exception re) {
                    TimerImpl.handleException("exception removing FlagStore bean", e);
                }
            }
            TimerImpl.handleException("createAndRollback", e);
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void ejbTimeoutRetry(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.createFlagStoreAndTimer(timer_type, 3);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("ejbTimeoutRetry", e);
        }
        if (!initialized) {
            message = "FlagStore bean or timer initialization failure";
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
    }

    public void rollbackTxInEjbTimeout(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.createFlagStoreAndTimer(timer_type, 4);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("rollbackTxInEjbTimeout", e);
        }
        if (!initialized) {
            message = "FlagStore bean or timer initialization failure";
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
    }

    public void checkSerialization(Integer timerType) {
        String message = null;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerHandle handle = TimerImpl.createTimerHandle(timer_type, new Integer(-1), ts);
            message = TimerImpl.isSerializable(handle) ? TestUtil.getProperty((String)"testName") : "checkSerialization failed";
        }
        catch (Exception e) {
            message = "exception in checkSerialization " + e.toString();
            TimerImpl.handleException("checkSerialization", e);
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void checkSerializationInEjbTimeout(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.initializeTimer(timer_type, 5);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("checkSerializationInEjbTimeout", e);
        }
        if (!initialized) {
            message = "timer initialization failure";
            TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
        }
    }

    public void initializeTimerAndNotify(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.initializeTimer(timer_type, 1);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("initializeTimerAndNotify", e);
        }
        message = initialized ? TestUtil.getProperty((String)"testName") : "timer initialization failure";
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void initializeTimerAndFlagStoreBean(Integer timerType) {
        String message = null;
        boolean initialized = true;
        try {
            int timer_type = timerType;
            TimerService ts = this.mctx.getTimerService();
            initialized = this.createFlagStoreAndTimer(timer_type, 1);
        }
        catch (Exception e) {
            initialized = false;
            TimerImpl.handleException("initializeTimerAndFlagStoreBean", e);
        }
        message = initialized ? TestUtil.getProperty((String)"testName") : "timer or FlagStore bean initialization failure";
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cancelAndRollback() {
        String message;
        block7: {
            message = null;
            try {
                TestUtil.logTrace((String)"finding flag store bean");
                this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
                this.flagStoreRef = this.flagStoreHome.findByPrimaryKey(new Integer(2));
                TestUtil.logTrace((String)"checking flag in flag store bean");
                if (!this.flagStoreRef.getRequiresNewAccessFlag()) {
                    TestUtil.logTrace((String)"flag is false - cancel timer, set flag and rollback");
                    Timer timer = this.findTimer(1);
                    if (timer != null) {
                        TestUtil.logTrace((String)("Cancelling timer at " + System.currentTimeMillis()));
                        timer.cancel();
                        this.flagStoreRef.setRequiresNewAccessFlag(true);
                        TestUtil.logTrace((String)"Rolling back transaction in which timer was cancelled...");
                        this.mctx.setRollbackOnly();
                        return;
                    }
                    message = "No timer found to cancel";
                    break block7;
                }
                TestUtil.logTrace((String)"flag is true - remove bean and return");
                if (this.flagStoreRef != null) {
                    try {
                        this.flagStoreRef.remove();
                        return;
                    }
                    catch (Exception re) {
                        TimerImpl.handleException("exception removing FlagStore bean", re);
                        message = "Exception removing FlagStore bean";
                    }
                }
            }
            catch (Exception e) {
                TimerImpl.handleException("cancelAndRollback", e);
                message = "cancelAndRollback failure";
            }
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void verifyTimerIsGone() {
        String message;
        try {
            TimerService ts = this.mctx.getTimerService();
            boolean noTimers = TimerImpl.verifyNoTimers(ts);
            message = noTimers ? "no timer found" : "at least one timer found";
        }
        catch (Exception e) {
            TimerImpl.handleException("verifyTimerIsGone", e);
            message = "failure in verifyTimerIsGone";
        }
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void initializeFlagStoreBean() {
        String message = "FlagStore bean not yet created";
        message = this.createFlagStoreBean() ? "FlagStore bean successfully created" : "Failed to create FlagStore bean";
        TimerImpl.sendMessage(this.replyQueue, this.qcFactory, message);
    }

    public void cancelAllTimers() {
        try {
            TimerService ts = this.mctx.getTimerService();
            TestUtil.logTrace((String)"Cancelling all timers...");
            TimerImpl.cancelAllTimers(ts);
        }
        catch (Exception e) {
            TimerImpl.handleException("cancelAllTimers", e);
        }
    }

    protected boolean initializeTimer(int timerType, int timerAction) {
        try {
            TimerService ts = this.mctx.getTimerService();
            TestUtil.logTrace((String)("Initializing timer at " + System.currentTimeMillis()));
            TimerHandle handle = TimerImpl.createTimerHandle(timerType, new Integer(timerAction), ts);
            return handle != null;
        }
        catch (Exception e) {
            TimerImpl.handleException("initializeTimer", e);
            return false;
        }
    }

    protected boolean createFlagStoreAndTimer(int timerType, int timerAction) {
        try {
            if (this.createFlagStoreBean()) {
                return this.initializeTimer(timerType, timerAction);
            }
        }
        catch (Exception e) {
            TimerImpl.handleException("createFlagStoreAndTimer", e);
        }
        return false;
    }

    protected boolean createFlagStoreBean() {
        try {
            TestUtil.logTrace((String)"creating flag store bean");
            this.flagStoreHome = (FlagStoreHome)this.nctx.lookup("java:comp/env/ejb/FlagStore", FlagStoreHome.class);
            this.flagStoreRef = this.flagStoreHome.create(TestUtil.getProperties(), 2, "expresso", 10.5f, false, false);
            return true;
        }
        catch (Exception e) {
            TimerImpl.handleException("createFlagStoreBean", e);
            try {
                TestUtil.logTrace((String)"removing flag store bean");
                if (this.flagStoreRef != null) {
                    this.flagStoreRef.remove();
                }
            }
            catch (Exception e1) {
                TimerImpl.handleException("removal of FlagStore bean failed", e);
            }
            return false;
        }
    }

    protected Timer findTimer(int id) {
        try {
            TimerService ts = this.mctx.getTimerService();
            ArrayList al = new ArrayList(ts.getTimers());
            if (!al.isEmpty()) {
                int numTimers = al.size();
                TestUtil.logTrace((String)("Number of timers is " + numTimers));
                for (int i = 0; i < numTimers; ++i) {
                    Timer timer = (Timer)al.get(i);
                    Serializable sz = timer.getInfo();
                    if (!(sz instanceof Integer)) continue;
                    int info = (Integer)sz;
                    TestUtil.logTrace((String)("Timer info is " + info));
                    if (id != info) continue;
                    TestUtil.logTrace((String)"match found!");
                    return timer;
                }
            }
        }
        catch (Exception e) {
            TimerImpl.handleException("Exception in findTimer", e);
        }
        return null;
    }

    protected Properties getProperties(Message msg) throws JMSException {
        String hostname = null;
        String traceflag = null;
        String logport = null;
        Properties props = new Properties();
        hostname = msg.getStringProperty("harnesshost");
        props.put("harness.host", hostname);
        traceflag = msg.getStringProperty("harnesslogtraceflag");
        props.put("harness.log.traceflag", traceflag);
        logport = msg.getStringProperty("harnesslogport");
        props.put("harness.log.port", logport);
        Enumeration propNames = msg.getPropertyNames();
        String name = null;
        while (propNames.hasMoreElements()) {
            name = (String)propNames.nextElement();
            props.put(name, msg.getStringProperty(name));
        }
        return props;
    }
}

