/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.ManagedTaskListener;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.ManagedTaskListener.RunnableTaskWithException;
import com.sun.ts.tests.concurrency.api.ManagedTaskListener.RunnableTaskWithStatus;
import com.sun.ts.tests.concurrency.api.common.Util;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ListenerEvent;
import com.sun.ts.tests.concurrency.api.common.managedTaskListener.ManagedTaskListenerImpl;
import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedExecutors;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.io.Serializable;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Future;

public class Client
extends ServiceEETest
implements Serializable {
    private static final long LISTENER_MAX_WAIT_MILLIS = 3000L;
    private static final int LISTENER_POOL_INTERVAL_MILLIS = 100;
    private ManagedExecutorService managedExecutorSvc;
    private ManagedTaskListenerImpl managedTaskListener;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.managedExecutorSvc = Util.getManagedExecutorService();
        this.managedTaskListener = new ManagedTaskListenerImpl();
    }

    public void cleanup() throws EETest.Fault {
        this.managedTaskListener.clearEvents();
        TestUtil.logMsg((String)"cleanup");
    }

    public void TaskAborted() throws EETest.Fault {
        int blockTime = 3000;
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener, blockTime);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.managedExecutorSvc.submit(taskWithListener);
        TestUtil.sleepMsec((int)1000);
        futureResult.cancel(true);
        Util.waitForListenerComplete(this.managedTaskListener, (long)blockTime + 3000L, 100);
        List<ListenerEvent> events = this.managedTaskListener.events();
        if (!events.contains((Object)ListenerEvent.ABORTED) || !futureResult.isCancelled()) {
            throw new EETest.Fault("Listener taskAborted failed");
        }
    }

    public void TaskDone() throws EETest.Fault {
        int blockTime = 3000;
        RunnableTaskWithStatus taskToCancelled = new RunnableTaskWithStatus(this.managedTaskListener, 3000);
        Runnable taskToCancelledWithListener = ManagedExecutors.managedTask((Runnable)taskToCancelled, (ManagedTaskListener)this.managedTaskListener);
        Future futureResult = this.managedExecutorSvc.submit(taskToCancelledWithListener);
        TestUtil.sleepMsec((int)1000);
        futureResult.cancel(true);
        Util.waitForListenerComplete(this.managedTaskListener, 6000L, 100);
        List<ListenerEvent> events = this.managedTaskListener.events();
        if (!events.contains((Object)ListenerEvent.DONE)) {
            throw new EETest.Fault("Listener taskDone failed in cancel case.");
        }
        this.managedTaskListener.clearEvents();
        RunnableTaskWithStatus runTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable runtaskWithListener = ManagedExecutors.managedTask((Runnable)runTask, (ManagedTaskListener)this.managedTaskListener);
        this.managedExecutorSvc.submit(runtaskWithListener);
        Util.waitForListenerComplete(this.managedTaskListener, 3000L, 100);
        List<ListenerEvent> runevents = this.managedTaskListener.events();
        if (!runevents.contains((Object)ListenerEvent.DONE)) {
            throw new EETest.Fault("Listener TaskDone failed");
        }
        this.managedTaskListener.clearEvents();
        RunnableTaskWithException taskWithException = new RunnableTaskWithException(this.managedTaskListener);
        Runnable taskWithExceptionListener = ManagedExecutors.managedTask((Runnable)taskWithException, (ManagedTaskListener)this.managedTaskListener);
        this.managedExecutorSvc.submit(taskWithExceptionListener);
        Util.waitForListenerComplete(this.managedTaskListener, 3000L, 100);
        List<ListenerEvent> runeventsWithException = this.managedTaskListener.events();
        TestUtil.logMsg((String)("++ runeventsWithException : " + runeventsWithException));
        if (!runeventsWithException.contains((Object)ListenerEvent.DONE)) {
            throw new EETest.Fault("Listener TaskDone failed with exception task.");
        }
    }

    public void TaskStarting() throws EETest.Fault {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        this.managedExecutorSvc.submit(taskWithListener);
        Util.waitForListenerComplete(this.managedTaskListener, 3000L, 100);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        int startAt = events.indexOf((Object)ListenerEvent.STARTING);
        int runAt = events.indexOf((Object)ListenerEvent.TASK_RUN);
        if ((submitAt != 0 || startAt != 1) && runAt == 2) {
            throw new EETest.Fault("Listener TaskStarting failed to run in expected order");
        }
    }

    public void TaskSubmitted() throws EETest.Fault {
        RunnableTaskWithStatus runnableTask = new RunnableTaskWithStatus(this.managedTaskListener);
        Runnable taskWithListener = ManagedExecutors.managedTask((Runnable)runnableTask, (ManagedTaskListener)this.managedTaskListener);
        this.managedExecutorSvc.submit(taskWithListener);
        Util.waitForListenerComplete(this.managedTaskListener, 3000L, 100);
        List<ListenerEvent> events = this.managedTaskListener.events();
        int submitAt = events.indexOf((Object)ListenerEvent.SUBMITTED);
        if (submitAt != 0) {
            throw new EETest.Fault("Listener TaskSubmitted failed to run in expected order");
        }
    }
}

