/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.jaxrs21.ee.patch.server;

import ee.jakarta.tck.ws.rs.lib.porting.TSURL;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;

public class AdaptiveMethodFactory {
    private static final String GET_METHOD = "GET";
    private static final String POST_METHOD = "POST";
    private static final String HEAD_METHOD = "HEAD";
    private static final String PUT_METHOD = "PUT";
    private static final String DELETE_METHOD = "DELETE";
    private static final String OPTIONS_METHOD = "OPTIONS";
    private static final Map<String, Class<? extends HttpMethodBase>> METHOD_MAP = new HashMap<String, Class<? extends HttpMethodBase>>();
    private static final TSURL TS_URL;

    private AdaptiveMethodFactory() {
    }

    public static final Map<String, Class<? extends HttpMethodBase>> getMethodMap() {
        return METHOD_MAP;
    }

    public static HttpMethod getInstance(String request) {
        HttpMethodBase req;
        Class<? extends HttpMethodBase> methodClass;
        String version;
        String uri;
        String method;
        StringTokenizer st = new StringTokenizer(request);
        String query = null;
        try {
            method = st.nextToken();
            uri = TS_URL.getRequest(st.nextToken());
            version = st.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new IllegalArgumentException("Request provided: " + request + " is malformed.");
        }
        int queryStart = uri.indexOf(63);
        if (queryStart != -1) {
            query = uri.substring(queryStart + 1);
            uri = uri.substring(0, queryStart);
        }
        if ((methodClass = METHOD_MAP.get(method)) == null) {
            throw new IllegalArgumentException("Invalid method: " + method);
        }
        try {
            Constructor<? extends HttpMethodBase> constructor = methodClass.getDeclaredConstructor(String.class);
            req = constructor.newInstance(uri);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        AdaptiveMethodFactory.setHttpVersion(version, req);
        if (query != null) {
            req.setQueryString(query);
        }
        return req;
    }

    private static void setHttpVersion(String version, HttpMethodBase method) {
        String oneOne = "HTTP/1.1";
        method.getParams().setVersion(version.equals("HTTP/1.1") ? HttpVersion.HTTP_1_1 : HttpVersion.HTTP_1_0);
    }

    static {
        METHOD_MAP.put(GET_METHOD, GetMethod.class);
        METHOD_MAP.put(POST_METHOD, PostMethod.class);
        METHOD_MAP.put(PUT_METHOD, PutMethod.class);
        METHOD_MAP.put(DELETE_METHOD, DeleteMethod.class);
        METHOD_MAP.put(HEAD_METHOD, HeadMethod.class);
        METHOD_MAP.put(OPTIONS_METHOD, OptionsMethod.class);
        TS_URL = new TSURL();
    }
}

