/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.uribuilder;

import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriBuilderException;
import java.net.URI;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@Timeout(value=1L, unit=TimeUnit.HOURS)
public final class UriBuilderIT {
    @Test
    public final void shouldBuildValidInstanceFromScratch() throws InterruptedException, ExecutionException {
        UriBuilder uriBuilder = UriBuilder.newInstance();
        URI uri = uriBuilder.scheme("scheme").host("host").port(1).build(new Object[0]);
        MatcherAssert.assertThat((Object)uri.toString(), (Matcher)Matchers.is((Object)"scheme://host:1"));
    }

    @Test
    public final void emptyUriBuilderBuildsEmptyUri() throws InterruptedException, ExecutionException {
        URI uri = UriBuilder.newInstance().build(new Object[0]);
        Assertions.assertEquals((Object)URI.create(""), (Object)uri);
    }

    @Test
    public final void shouldThrowUriBuilderExceptionOnSchemeOnlyUri() throws InterruptedException, ExecutionException {
        UriBuilder uriBuilder = UriBuilder.newInstance().scheme("http");
        Assertions.assertThrows(UriBuilderException.class, () -> uriBuilder.build(new Object[0]));
    }

    @Test
    public final void shouldThrowIllegalArgumentExceptionForUnresolvedTemplates() throws InterruptedException, ExecutionException {
        UriBuilder uriBuilder = UriBuilder.newInstance().scheme("http").host("localhost").path("contextroot").path("{var}");
        Assertions.assertThrows(IllegalArgumentException.class, () -> uriBuilder.build(new Object[0]));
    }
}

