/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.resource.webappexception.nomapper;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;

@Path(value="resource")
public class Resource {
    static String html_content = "<html><head><title>CTS-get text/html</title></head><body>CTS-get text/html</body></html>";
    public static final String TESTID = "CTS-WebApplicationExceptionTest";

    @GET
    @Path(value="/EmptyConstructor")
    public Response emptyConstructor() {
        throw new WebApplicationException();
    }

    @GET
    @Path(value="/StatusCode404")
    public Response statusCode404() {
        throw new WebApplicationException(404);
    }

    @GET
    @Path(value="/StatusCode401")
    public Response statusCode401() {
        throw new WebApplicationException(401);
    }

    @GET
    @Path(value="/Status503")
    public Response status503() {
        throw new WebApplicationException(Response.Status.SERVICE_UNAVAILABLE);
    }

    @GET
    @Path(value="/Status415")
    public Response status415() {
        throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
    }

    @GET
    @Path(value="/ResponseTest")
    public Response responseTest() {
        throw new WebApplicationException(Response.ok((Object)TESTID).header("CTS-HEAD", (Object)TESTID).build());
    }

    @GET
    @Path(value="/NullResponseTest")
    public Response nullResponseTest() {
        Response rsp = null;
        throw new WebApplicationException(rsp);
    }

    @GET
    @Path(value="/getResponseTest")
    public Response getResponseTest() {
        Response r = Response.ok((Object)TESTID).header("CTS-HEAD", (Object)TESTID).build();
        WebApplicationException wae = new WebApplicationException(r);
        return wae.getResponse();
    }

    @GET
    @Path(value="/ThrowableTest")
    public Response throwableTest() {
        throw new WebApplicationException(new Throwable("CTS-WebApplicationExceptionTest-throwableTest"));
    }

    @GET
    @Path(value="/ThrowableResponseTest")
    public Response throwableResponseTest() {
        throw new WebApplicationException(new Throwable(Resource.id("-throwableResponseTest-FAIL")), Response.ok((Object)Resource.id("-throwableResponseTest")).status(202).header("CTS-HEAD", (Object)TESTID).build());
    }

    @GET
    @Path(value="/ThrowableResponseTest1")
    public Response throwableResponseTest1() {
        Response rsp = null;
        throw new WebApplicationException(new Throwable(Resource.id("-throwableResponseTest1-FAIL")), rsp);
    }

    @GET
    @Path(value="/ThrowableStatusTest")
    public Response throwableStatusTest() {
        throw new WebApplicationException(new Throwable(Resource.id("-throwableStatusTest")), Response.Status.SEE_OTHER);
    }

    @GET
    @Path(value="/ThrowableNullStatusTest")
    public Response throwableNullStatusTest() {
        try {
            throw new WebApplicationException(new Throwable(Resource.id("-throwableNullStatusTest")), (Response.Status)null);
        }
        catch (IllegalArgumentException iae) {
            throw new WebApplicationException(new Throwable(Resource.id("-throwableNullStatusTest")), Response.ok((Object)Resource.id("-throwableNullStatusTest-PASS")).build());
        }
        catch (Exception e) {
            throw new WebApplicationException(new Throwable(Resource.id("-throwableNullStatusTest")), Response.Status.INTERNAL_SERVER_ERROR);
        }
    }

    @GET
    @Path(value="/ThrowableStatusCodeTest")
    public Response throwableStatusCodeTest() {
        throw new WebApplicationException(new Throwable(Resource.id("-throwableStatusCodeTest")), 204);
    }

    public static String id(String suffix) {
        return TESTID + suffix;
    }
}

