/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.provider.standardwithjaxrsclient;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.client.JaxrsCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.provider.standardwithjaxrsclient.Resource;
import ee.jakarta.tck.ws.rs.spec.provider.standardwithjaxrsclient.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_provider_standardwithjaxrsclient_web/resource");
    }

    private void setPropertyAndInvoke(String resourceMethod, MediaType md) throws JAXRSCommonClient.Fault {
        String ct = JAXRSClientIT.buildContentType(md);
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.POST, resourceMethod));
        if (!MediaType.WILDCARD_TYPE.equals((Object)md)) {
            this.setProperty(JAXRSCommonClient.Property.EXPECTED_HEADERS, ct);
        }
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, ct);
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(md));
        this.invoke();
    }

    private <T> void assertEntity(Class<T> entityClass, T value) throws JAXRSCommonClient.Fault {
        T entity = this.getResponseBody(entityClass);
        JAXRSClientIT.assertNotNull(entity, "response body is null");
        JAXRSClientIT.assertEquals(entity, value, "Expected", value, "differs from gotten", entity);
        JAXRSClientIT.logMsg("Found expected entity", entity);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/provider/standardwithjaxrsclient/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_provider_standardwithjaxrsclient_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void mapElementProviderTest() throws JAXRSCommonClient.Fault {
        String element = "map";
        MultivaluedHashMap map = new MultivaluedHashMap();
        map.add((Object)element, (Object)element);
        this.setRequestContentEntity(map);
        this.setPropertyAndInvoke("map", MediaType.APPLICATION_FORM_URLENCODED_TYPE);
        map = this.getResponseBody(MultivaluedMap.class);
        JAXRSClientIT.assertNotNull(map, "returned MultivaluedMap is null");
        String returned = (String)map.getFirst((Object)element);
        JAXRSClientIT.assertNotNull(returned, "Returned map does not contain expected element", element);
        JAXRSClientIT.assertEquals(returned, element, "returned element", returned, "differs from expected", element);
        JAXRSClientIT.logMsg("found expected MultivaluedMap", map);
    }

    @Test
    public void readWriteProviderBoolTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "false");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "false");
        this.setPropertyAndInvoke("bool", MediaType.TEXT_PLAIN_TYPE);
    }

    @Test
    public void readWriteProviderBooleanTest() throws JAXRSCommonClient.Fault {
        Boolean bool = true;
        this.setRequestContentEntity(bool);
        this.setPropertyAndInvoke("boolean", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(Boolean.class, bool);
    }

    @Test
    public void readWriteProviderCharTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "x");
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "x");
        this.setPropertyAndInvoke("char", MediaType.TEXT_PLAIN_TYPE);
    }

    @Test
    public void readWriteProviderCharacterTest() throws JAXRSCommonClient.Fault {
        Character c = Character.valueOf('x');
        this.setRequestContentEntity(c);
        this.setPropertyAndInvoke("character", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(Character.class, c);
    }

    @Test
    public void readWriteProviderIntTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, String.valueOf(Integer.MAX_VALUE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(Integer.MAX_VALUE));
        this.setPropertyAndInvoke("int", MediaType.TEXT_PLAIN_TYPE);
    }

    @Test
    public void readWriteProviderLongTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, String.valueOf(Long.MAX_VALUE));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.valueOf(Long.MAX_VALUE));
        this.setPropertyAndInvoke("long", MediaType.TEXT_PLAIN_TYPE);
    }

    @Test
    public void readWriteProviderIntegerTest() throws JAXRSCommonClient.Fault {
        Integer i = new Integer(Integer.MAX_VALUE);
        this.setRequestContentEntity(i);
        this.setPropertyAndInvoke("integer", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(Integer.class, i);
    }

    @Test
    public void readWriteProviderBigLongTest() throws JAXRSCommonClient.Fault {
        Long l = new Long(Long.MAX_VALUE);
        this.setRequestContentEntity(l);
        this.setPropertyAndInvoke("biglong", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(Long.class, l);
    }

    @Test
    public void readWriteProviderDoubleTest() throws JAXRSCommonClient.Fault {
        Double pi = Math.PI;
        this.setRequestContentEntity(pi);
        this.setPropertyAndInvoke("bigdouble", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(Double.class, pi);
    }

    @Test
    public void readWriteProviderBigDecimalTest() throws JAXRSCommonClient.Fault {
        BigDecimal bd = new BigDecimal(Integer.MAX_VALUE);
        this.setRequestContentEntity(bd);
        this.setPropertyAndInvoke("bigdecimal", MediaType.TEXT_PLAIN_TYPE);
        this.assertEntity(BigDecimal.class, bd);
    }
}

