/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.writerinterceptorcontext;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.impl.ReplacingOutputStream;
import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanEntityProvider;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.WriterClient;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.writerinterceptorcontext.Resource;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.containerwriter.writerinterceptorcontext.TSAppConfig;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.TemplateWriterInterceptor;
import ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext.ContextOperation;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends WriterClient<ContextOperation> {
    private static final long serialVersionUID = -8158424518609416304L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_ext_interceptor_containerwriter_writerinterceptorcontext_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/ext/interceptor/containerwriter/writerinterceptorcontext/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_ext_interceptor_containerwriter_writerinterceptorcontext_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, JaxrsUtil.class, StringBean.class, StringBeanEntityProvider.class, ReplacingOutputStream.class, TemplateWriterInterceptor.class, Resource.class});
        archive.addPackages(false, new String[]{"ee.jakarta.tck.ws.rs.api.rs.ext.interceptor", "ee.jakarta.tck.ws.rs.ee.rs.ext.interceptor.writer.writerinterceptorcontext"});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void getEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Entity");
        this.invoke(ContextOperation.GETENTITY);
    }

    @Test
    public void getHeadersOperationOnlyTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OPERATION");
        this.invoke(ContextOperation.GETHEADERS);
    }

    @Test
    public void getHeadersTest() throws JAXRSCommonClient.Fault {
        JAXRSCommonClient.Property p = JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING;
        this.setProperty(p, "OPERATION");
        for (int i = 0; i != 5; ++i) {
            this.setProperty(p, "Property" + i);
        }
        this.invoke(ContextOperation.GETHEADERS);
    }

    @Test
    public void getHeadersIsMutableTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Property");
        this.invoke(ContextOperation.GETHEADERSISMUTABLE);
    }

    @Test
    public void getOutputStreamTest() throws JAXRSCommonClient.Fault {
        JAXRSCommonClient.Property p = JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING;
        this.setProperty(p, "Entity");
        this.setProperty(p, "None");
        this.invoke(ContextOperation.GETOUTPUTSTREAM);
    }

    @Test
    public void proceedThrowsIOExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "IOException has been thrown as expected");
        this.invoke(ContextOperation.PROCEEDTHROWSIOEXCEPTION);
    }

    @Test
    public void proceedThrowsWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "WebApplicationException has been thrown as expected");
        this.invoke(ContextOperation.PROCEEDTHROWSWEBAPPEXCEPTION);
    }

    @Test
    public void setEntityTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "OPERATION");
        this.invoke(ContextOperation.SETENTITY);
    }

    @Test
    public void setOutputStreamTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Entity".replace('t', 'x'));
        this.invoke(ContextOperation.SETOUTPUTSTREAM);
    }
}

