/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.extensions;

import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.unboundidds.extensions.ExtOpMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.util.StringTokenizer;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class PasswordPolicyStateAccountUsabilityWarning
implements Serializable {
    public static final int WARNING_TYPE_ACCOUNT_EXPIRING = 1;
    public static final String WARNING_NAME_ACCOUNT_EXPIRING = "account-expiring";
    public static final int WARNING_TYPE_PASSWORD_EXPIRING = 2;
    public static final String WARNING_NAME_PASSWORD_EXPIRING = "password-expiring";
    public static final int WARNING_TYPE_OUTSTANDING_BIND_FAILURES = 3;
    public static final String WARNING_NAME_OUTSTANDING_BIND_FAILURES = "outstanding-bind-failures";
    public static final int WARNING_TYPE_ACCOUNT_IDLE = 4;
    public static final String WARNING_NAME_ACCOUNT_IDLE = "account-idle";
    public static final int WARNING_TYPE_REQUIRE_PASSWORD_CHANGE_BY_TIME = 5;
    public static final String WARNING_NAME_REQUIRE_PASSWORD_CHANGE_BY_TIME = "require-password-change-by-time";
    private static final long serialVersionUID = 4256291819633130578L;
    private final int intValue;
    private final String message;
    private final String name;
    private final String stringRepresentation;

    public PasswordPolicyStateAccountUsabilityWarning(int intValue, String name, String message) {
        Validator.ensureNotNull(name);
        this.intValue = intValue;
        this.name = name;
        this.message = message;
        StringBuilder buffer = new StringBuilder();
        buffer.append("code=");
        buffer.append(intValue);
        buffer.append("\tname=");
        buffer.append(name);
        if (message != null) {
            buffer.append("\tmessage=");
            buffer.append(message);
        }
        this.stringRepresentation = buffer.toString();
    }

    public PasswordPolicyStateAccountUsabilityWarning(String stringRepresentation) throws LDAPException {
        this.stringRepresentation = stringRepresentation;
        try {
            Integer i = null;
            String n = null;
            String m = null;
            StringTokenizer tokenizer = new StringTokenizer(stringRepresentation, "\t");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int equalPos = token.indexOf(61);
                String fieldName = token.substring(0, equalPos);
                String fieldValue = token.substring(equalPos + 1);
                if (fieldName.equals("code")) {
                    i = Integer.valueOf(fieldValue);
                    continue;
                }
                if (fieldName.equals("name")) {
                    n = fieldValue;
                    continue;
                }
                if (!fieldName.equals("message")) continue;
                m = fieldValue;
            }
            if (i == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_ACCOUNT_USABILITY_WARNING_CANNOT_DECODE.get(stringRepresentation, ExtOpMessages.ERR_PWP_STATE_ACCOUNT_USABILITY_WARNING_NO_CODE.get()));
            }
            if (n == null) {
                throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_ACCOUNT_USABILITY_WARNING_CANNOT_DECODE.get(stringRepresentation, ExtOpMessages.ERR_PWP_STATE_ACCOUNT_USABILITY_WARNING_NO_NAME.get()));
            }
            this.intValue = i;
            this.name = n;
            this.message = m;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.DECODING_ERROR, ExtOpMessages.ERR_PWP_STATE_ACCOUNT_USABILITY_WARNING_CANNOT_DECODE.get(stringRepresentation, StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public int getIntValue() {
        return this.intValue;
    }

    public String getName() {
        return this.name;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

