/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.exec.BasicSession;
import com.sun.javatest.exec.CustomTestResultViewer;
import com.sun.javatest.exec.ET_ControlFactory;
import com.sun.javatest.exec.ET_DefaultControlFactory;
import com.sun.javatest.exec.ExecTool;
import com.sun.javatest.exec.FeatureManager;
import com.sun.javatest.exec.JavaTestContextMenu;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.SessionExt;
import com.sun.javatest.exec.ToolBarManager;
import com.sun.javatest.exec.template.ET_TemplateControlFactory;
import com.sun.javatest.exec.template.TemplateSession;
import com.sun.javatest.report.CustomReport;
import com.sun.javatest.report.Report;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ContextManager
implements InterviewParameters.TemplateManager,
Report.CustomReportManager,
BasicSession.OrderedObserver {
    static final String TEMPLATE_ON_PROPERTY = "com.sun.javatest.exec.templateMode";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(ContextManager.class);
    protected File configLoadPath;
    protected File configSavePath;
    protected boolean configLoadOutside = true;
    protected boolean configSaveOutside = true;
    protected File templateLoadPath;
    protected File templateSavePath;
    protected boolean templateLoadOutside = true;
    protected boolean templateSaveOutside = true;
    protected File wdPath;
    protected FeatureManager featureManager = new FeatureManager();
    protected InterviewParameters currentConfig = null;
    protected InterviewParameters currentTemplate = null;
    private WorkDirectory workdir;
    private TestSuite testSuite;
    private InterviewParameters interview;
    private ExecTool parentTool;
    private Map<Class<? extends Question>, QuestionRenderer> customRenderers;
    private volatile boolean pendingRefresh = false;

    public JavaTestMenuManager getMenuManager() {
        return null;
    }

    public ToolBarManager getToolBarManager() {
        return new ToolBarManager();
    }

    public void dispose() {
    }

    public JavaTestContextMenu[] getContextMenus() {
        return null;
    }

    @Override
    public CustomReport[] getCustomReports() {
        return null;
    }

    public CustomTestResultViewer[] getCustomResultViewers() {
        return null;
    }

    public TestSuite getTestSuite() {
        return this.testSuite;
    }

    protected void setTestSuite(TestSuite ts) {
        this.testSuite = ts;
    }

    public WorkDirectory getWorkDirectory() {
        return this.workdir;
    }

    protected void setWorkDirectory(WorkDirectory w) {
        this.workdir = w;
    }

    public InterviewParameters getInterview() {
        return this.getCurrentInterview();
    }

    void setInterview(InterviewParameters i) {
        this.interview = i;
    }

    public InterviewParameters getTemplate() throws IOException, Interview.Fault {
        if (this.interview == null) {
            return null;
        }
        if (this.interview.isTemplate()) {
            return this.interview;
        }
        InterviewParameters template = null;
        if (this.interview.getTemplatePath() != null && this.workdir != null) {
            File f = new File(this.interview.getTemplatePath());
            template = InterviewParameters.open(f, this.workdir);
        }
        return template;
    }

    public InterviewParameters getCurrentInterview() {
        return this.currentConfig;
    }

    public InterviewParameters getCurrentTemplate() {
        return this.currentTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshTests() {
        ContextManager contextManager = this;
        synchronized (contextManager) {
            if (this.pendingRefresh) {
                return;
            }
            this.pendingRefresh = true;
        }
        if (EventQueue.isDispatchThread()) {
            Runnable cmd = this::refreshTestsImpl;
            Thread t = new Thread(cmd, "ContextMgr Refresh Defer");
            t.start();
            return;
        }
        this.refreshTestsImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshTestsImpl() {
        ContextManager contextManager = this;
        synchronized (contextManager) {
            this.pendingRefresh = false;
        }
        if (this.parentTool != null) {
            TestResultTable trt = this.parentTool.getActiveTestResultTable();
            HashMap<String, String> pathMap = new HashMap<String, String>();
            this.parentTool.saveTreeState(pathMap);
            if (trt != null) {
                try {
                    this.parentTool.pauseTreeCacheWork();
                    trt.getLock().lock();
                    trt.waitUntilReady();
                    trt.refreshIfNeeded(trt.getRoot());
                }
                finally {
                    trt.getLock().unlock();
                    this.parentTool.unpauseTreeCacheWork();
                }
            }
            this.parentTool.restoreTreeState(pathMap);
        }
    }

    public void syncInterview() {
        this.parentTool.syncInterview();
    }

    public FeatureManager getFeatureManager() {
        return this.featureManager;
    }

    public void setFeatureManager(FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    @Override
    public boolean canSaveTemplate(File file) {
        return true;
    }

    public File getDefaultWorkDirPath() {
        return this.wdPath;
    }

    public void setDefaultWorkDirPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.wdPath = dir;
    }

    public File getDefaultTemplateLoadPath() {
        return this.templateLoadPath;
    }

    public void setDefaultTemplateLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateLoadPath = dir;
    }

    public File getDefaultTemplateSavePath() {
        return this.templateSavePath;
    }

    public void setDefaultTemplateSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.templateSavePath = dir;
    }

    public boolean getAllowTemplateLoadOutsideDefault() {
        return this.templateLoadOutside;
    }

    public void setAllowTemplateLoadOutsideDefault(boolean state) {
        this.templateLoadOutside = state;
    }

    public boolean getAllowTemplateSaveOutsideDefault() {
        return this.templateSaveOutside;
    }

    public void setAllowTemplateSaveOutsideDefault(boolean state) {
        this.templateSaveOutside = state;
    }

    public File getDefaultConfigLoadPath() {
        return this.configLoadPath;
    }

    public void setDefaultConfigLoadPath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configLoadPath = dir;
    }

    public File getDefaultConfigSavePath() {
        return this.configSavePath;
    }

    public void setDefaultConfigSavePath(File dir) {
        if (dir == null) {
            throw new NullPointerException();
        }
        this.configSavePath = dir;
    }

    public boolean getAllowConfigLoadOutsideDefault() {
        return this.configLoadOutside;
    }

    public void setAllowConfigLoadOutsideDefault(boolean state) {
        this.configLoadOutside = state;
    }

    public boolean getAllowConfigSaveOutsideDefault() {
        return this.configSaveOutside;
    }

    public void setAllowConfigSaveOutsideDefault(boolean state) {
        this.configSaveOutside = state;
    }

    public void loadConfiguration(File file) {
        this.parentTool.loadInterview(file);
    }

    @Deprecated
    protected void setWorkDir(WorkDirectory w) {
        this.setWorkDirectory(w);
    }

    protected void openTree(WorkDirectory wd) {
    }

    public Map<Class<? extends Question>, QuestionRenderer> getCustomRenderersMap() {
        return this.customRenderers;
    }

    protected void registerCustomQuestionRenderer(Class<? extends Question> question, QuestionRenderer renderer) {
        if (this.customRenderers == null) {
            this.customRenderers = new HashMap<Class<? extends Question>, QuestionRenderer>();
        }
        this.customRenderers.put(question, renderer);
    }

    public ET_ControlFactory getExecToolControlFactory(ExecTool et, UIFactory uif) {
        if (Boolean.parseBoolean(System.getProperty(TEMPLATE_ON_PROPERTY))) {
            return new ET_TemplateControlFactory(et, uif, this.testSuite, this, et, et);
        }
        return new ET_DefaultControlFactory(et, uif, this.testSuite, this, et, et);
    }

    @Override
    public void updated(Session.Event ev) {
        if (ev instanceof BasicSession.E_NewWD) {
            this.updatedWorkDirectory(((BasicSession.E_NewWD)ev).wd);
        } else if (ev instanceof BasicSession.E_NewConfig) {
            this.updatedCurrentConfig(((BasicSession.E_NewConfig)ev).ip);
        } else if (ev instanceof TemplateSession.E_NewTemplate) {
            this.updatedCurrentTemplate(((TemplateSession.E_NewTemplate)ev).templ);
        }
    }

    @Override
    public int order() {
        return 2147483547;
    }

    protected void updatedWorkDirectory(WorkDirectory wd) {
        this.setWorkDirectory(wd);
    }

    protected void updatedCurrentConfig(InterviewParameters ip) {
    }

    protected void updatedCurrentTemplate(InterviewParameters ip) {
    }

    void setCurrentConfig(SessionExt conf) {
        this.setWorkDirectory(conf.getWorkDirectory());
        this.currentConfig = conf.getInterviewParameters();
        if (conf instanceof TemplateSession) {
            this.currentTemplate = ((TemplateSession)conf).getTemplate();
        }
    }

    void setTool(ExecTool t) {
        this.parentTool = t;
    }

    public static abstract class TestManagerDialog
    extends ToolDialog {
        public TestManagerDialog(ContextManager context, UIFactory uif, String key) {
            super(context.parentTool, uif, key);
        }
    }
}

