/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.common.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import servlet.tck.common.client.BaseTckTest;
import servlet.tck.util.WebUtil;

public class SecformClient
extends BaseTckTest {
    private String protocol = "http";
    private String hostname = null;
    private int portnum = 0;
    protected String pageBase = null;
    protected String pageSec = null;
    protected String pageGuest = null;
    protected String pageRoleReverse = null;
    protected String pageUnprotected = null;
    private String pageProgAuthen = null;
    private String pageProgLogin = null;
    private String pageProgLogout = null;
    private String pageOne = null;
    private String pageTwo = null;
    private String pageSample = null;
    private String pageallRoles = null;
    private String pageLogin = "/login.jsp";
    private String pageError = "/error.jsp";
    private String pageSecurityCheck = "/j_security_check";
    private String pageJspBase = "/jsp_sec_secform_web";
    private String pageJspSec = this.pageJspBase + "/jspSec.jsp";
    private String pageJspUnprotected = this.pageJspBase + "/unprotected.jsp";
    private String pageJspGuest = this.pageJspBase + "/guestPage.jsp";
    private String pageJspRoleReverse = this.pageJspBase + "/rolereverse.jsp";
    private String pageJspOne = this.pageJspBase + "/One.jsp";
    private String pageJspTwo = this.pageJspBase + "/Two.jsp";
    private String pageJspSample = this.pageJspBase + "/Sample.jsp";
    private String pageJspallRoles = this.pageJspBase + "/allRoles.jsp";
    private String pageServletBase = "/servlet_sec_secform_web";
    private String pageServletSec = this.pageServletBase + "/ServletSecTest";
    private String pageServletUnprotected = this.pageServletBase + "/UnProtectedTest";
    private String pageServletProgLogin = this.pageServletBase + "/ServletProgrammaticLogin";
    private String pageServletProgLogout = this.pageServletBase + "/ServletProgrammaticLogout";
    private String pageServletProgAuthen = this.pageServletBase + "/ServletProgrammaticAuthen";
    private String pageServletGuest = this.pageServletBase + "/GuestPageTest";
    private String pageServletRoleReverse = this.pageServletBase + "/RoleReverseTest";
    private String pageServletOne = this.pageServletBase + "/OneTest";
    private String pageServletTwo = this.pageServletBase + "/TwoTest";
    private String pageServletSample = this.pageServletBase + "/SampleTest";
    private String pageServletallRoles = this.pageServletBase + "/allRolesTest";
    private String searchFor = "The user principal is: ";
    private String searchForGetRemoteUser = "getRemoteUser(): ";
    private String username = "";
    private String password = "";
    private String unauthUsername = "";
    private String unauthPassword = "";
    private String tshome = "";
    private final String WebHostProp = "webServerHost";
    private final String WebPortProp = "webServerPort";
    private final String UserNameProp = "user";
    private final String PasswordProp = "password";
    private final String unauthUserNameProp = "authuser";
    private final String unauthPasswordProp = "authpassword";
    private final String tsHomeProp = "ts_home";
    private String testDir = System.getProperty("user.dir");
    private Properties props = null;
    private String request = null;
    private WebUtil.Response response = null;
    private WebUtil.Response loginPageRequestResponse = null;
    private WebUtil.Response errorPageRequestResponse = null;
    private Map<String, String> cookies = new HashMap<String, String>();

    @Override
    public void setup(String[] args, Properties p) throws Exception {
        super.setup(args, p);
        this.props = p;
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.unauthUsername = p.getProperty("authuser");
            this.unauthPassword = p.getProperty("authpassword");
            this.tshome = p.getProperty("ts_home");
            this.logger.debug("username: {}", (Object)this.username);
            this.logger.debug("password: {}", (Object)this.password);
            this.pageBase = this.pageServletBase;
            this.pageSec = this.pageServletSec;
            this.pageGuest = this.pageServletGuest;
            this.pageUnprotected = this.pageServletUnprotected;
            this.pageRoleReverse = this.pageServletRoleReverse;
            this.pageOne = this.pageServletOne;
            this.pageTwo = this.pageServletTwo;
            this.pageSample = this.pageServletSample;
            this.pageallRoles = this.pageServletallRoles;
            this.pageProgLogin = this.pageServletProgLogin;
            this.pageProgLogout = this.pageServletProgLogout;
            this.pageProgAuthen = this.pageServletProgAuthen;
            this.pageLogin = this.pageServletBase + this.pageLogin;
            this.pageError = this.pageServletBase + this.pageError;
            this.pageSecurityCheck = this.pageServletBase + this.pageSecurityCheck;
        }
        catch (Exception e) {
            this.logger.error("Error: got exception: " + e.getMessage(), (Throwable)e);
        }
    }

    public void test1() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 1);
            this.request = this.pageSecurityCheck;
            this.logger.debug("Sending request '{}' with login information.", (Object)this.request);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.debug("response.statusToken: {}", (Object)this.response.statusToken);
            this.logger.debug("response.content: {}", (Object)this.response.content);
            if (this.response.isError()) {
                this.logger.error("Could not find {}", (Object)this.request);
                throw new Exception("test1 failed.");
            }
            this.response = this.followRedirect(this.response, 1);
            this.logger.debug("received response content  1: {}", (Object)this.response.content);
            String searchString = this.searchFor + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logger.error("User Principal incorrect.  Page received:");
                this.logger.error(this.response.content);
                this.logger.error("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            this.logger.debug("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logger.error("getRemoteUser() did not return " + this.username + ":");
                this.logger.error(this.response.content);
                this.logger.error("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            this.logMsg("getRemoteUser() correct.");
            HashMap<String, Boolean> roleCheck = new HashMap<String, Boolean>();
            roleCheck.put("ADM", Boolean.TRUE);
            roleCheck.put("MGR", Boolean.FALSE);
            roleCheck.put("VP", Boolean.FALSE);
            roleCheck.put("EMP", Boolean.TRUE);
            if (!this.checkRoles(this.response.content, roleCheck)) {
                this.logger.error("isUserInRole() does not work correctly. Page Received:");
                this.logger.error(this.response.content);
                throw new Exception("test1 failed.");
            }
            this.logMsg("isUserInRole() correct.");
            this.request = this.pageSec;
            this.logger.debug("Cookies = {}", (Object)this.cookies.toString());
            this.logger.debug("Re-sending request {}", (Object)this.request);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, this.cookies);
            if (this.response.isError()) {
                this.logger.error("Could not find " + this.pageSec);
                throw new Exception("test1 failed.");
            }
            if (!this.response.content.contains(searchString)) {
                this.logger.error("User Principal incorrect.  Page received:");
                this.logger.error(this.response.content);
                this.logger.error("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            this.logger.debug("User Principal still correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logger.error("getRemoteUser() did not return " + this.username + " after lazy authentication:");
                this.logger.error(this.response.content);
                this.logger.error("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            this.logMsg("getRemoteUser() still correct.");
            if (!this.checkRoles(this.response.content, roleCheck)) {
                this.logger.error("isUserInRole() does not work correctly.");
                this.logger.error("Page Received:");
                this.logger.error(this.response.content);
                throw new Exception("test1 failed.");
            }
            this.logMsg("isUserInRole() still correct.");
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("test1 failed: " + e.getMessage(), e);
        }
    }

    public void test2() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 2);
            this.request = this.pageSecurityCheck;
            this.logger.debug("Sending request {} with incorrect login information.", (Object)this.request);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", "incorrect" + this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.debug("response.statusToken: {}", (Object)this.response.statusToken);
            this.response = this.followRedirect(this.response, 2);
            String searchString = this.searchFor + "null";
            if (!this.response.content.contains(searchString)) {
                this.logger.error("User principal is not null in error page: {}", (Object)this.response.content);
                throw new Exception("test2 failed.");
            }
            this.logger.debug("User Principal is null as expected.");
            this.request = this.pageError;
            this.logger.debug("Sending request {}", (Object)this.request);
            this.errorPageRequestResponse = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, this.cookies);
            if (this.errorPageRequestResponse.isError()) {
                this.logger.error("Could not find {}", (Object)this.request);
                throw new Exception("test2  failed.");
            }
            if (!this.response.content.equals(this.errorPageRequestResponse.content)) {
                this.logger.error("Received incorrect error page");
                throw new Exception("test2  failed.");
            }
            this.logger.debug("Received the expected error page");
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("test2 failed: " + e.getMessage(), e);
        }
    }

    public void test3() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageGuest, 3);
            this.request = this.pageSecurityCheck;
            this.logger.debug("Sending request {} with login information (as {}).", (Object)this.request, (Object)this.unauthUsername);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.unauthUsername);
            postData.put("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logger.error("Could not find {}", (Object)this.request);
                throw new Exception("test3 failed.");
            }
            this.response = this.followRedirect(this.response, 3);
            String searchString = this.searchFor + this.unauthUsername;
            if (!this.response.content.contains(searchString)) {
                this.logger.error("User Principal incorrect.  Page received: {}", (Object)this.response.content);
                this.logger.error("(Should say: {}", (Object)searchString);
                throw new Exception("test3 failed.");
            }
            this.logger.debug("User Principal correct.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test3 failed: " + e.getMessage(), e);
        }
    }

    public void test4() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSec, 4);
            this.request = this.pageSecurityCheck;
            this.logger.debug("Sending request {} with correct login information ({}), but incorrect authorization for this resource.", (Object)this.request, (Object)this.unauthUsername);
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.unauthUsername);
            postData.put("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.debug("response.content = {}", (Object)this.response.content);
            if (this.response.statusToken.equals("302")) {
                if (this.response.location == null) {
                    this.logger.error("No redirection to login page received.");
                    throw new Exception("test4 failed.");
                }
                this.request = WebUtil.getRequestFromURL((String)this.response.location);
                this.logger.debug("Redirect to: {}", (Object)this.response.location);
                this.addNewCookies(this.cookies, this.response.cookies);
                this.logger.debug("Sending request {}", (Object)this.request);
                this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, this.cookies);
            }
            if (!this.response.statusToken.equals("403") && !this.response.statusToken.equals("404")) {
                this.logger.error("Did not receive error for unauthorized access: {}", (Object)this.request);
                this.logger.error("Status Token {}", (Object)this.response.statusToken);
                this.logger.error("Page content: {}", (Object)this.response.content);
                throw new Exception("test4 failed.");
            }
            this.logger.debug("Status Token {}, Received expected unauthorized access error", (Object)this.response.statusToken);
            this.request = this.pageUnprotected;
            this.logger.debug("Sending request {}", (Object)this.request);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            if (this.response.isError()) {
                this.logger.error("Error retrieving {}", (Object)this.request);
                throw new Exception("test4 failed.");
            }
            String searchString = this.searchFor;
            if (!this.response.content.contains(searchString)) {
                this.logger.error("Incorrect page received: {}", (Object)this.response.content);
                this.logger.error("(Should contain: {}", (Object)searchString);
                throw new Exception("test4 failed.");
            }
            this.logger.debug("Access to unprotected page granted.");
        }
        catch (Exception e) {
            this.logger.error("Caught exception: " + e.getMessage(), (Throwable)e);
            throw new Exception("test4 failed: " + e.getMessage(), e);
        }
    }

    public void test5() throws Exception {
        try {
            String request = this.pageUnprotected;
            this.logMsg("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)request, null, null);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.pageUnprotected);
                throw new Exception("test5 failed.");
            }
            if (this.response.isError()) {
                this.logErr("Error retrieving " + request);
                throw new Exception("test5 failed.");
            }
            String searchString = this.searchFor;
            if (!this.response.content.contains(searchString)) {
                this.logErr("Incorrect page received:");
                this.logErr(this.response.content);
                this.logErr("(Should contain: \"" + searchString + "\")");
                throw new Exception("test5 failed.");
            }
            this.logMsg("Access to unprotected page granted.");
            this.logMsg("Checking isUserInRole...");
            searchString = "!true!";
            if (this.response.content.contains(searchString)) {
                this.logErr("At least one call to isUserInRole returned true.");
                this.logErr("Page received:");
                this.logErr(this.response.content);
                throw new Exception("test5 failed.");
            }
            this.logMsg("isUserInRole test passed.");
            this.logMsg("Checking getRemoteUser()...");
            searchString = this.searchForGetRemoteUser + "null";
            if (!this.response.content.contains(searchString)) {
                this.logErr("A call to getRemoteUser() did not return null.");
                this.logErr("Page received:");
                this.logErr(this.response.content);
                throw new Exception("test5 failed.");
            }
            this.logMsg("getRemoteUser() test passed.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test5 failed: ", e);
        }
    }

    public void test6() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageRoleReverse, 6);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information (as " + this.username + ").");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test6 failed.");
            }
            this.response = this.followRedirect(this.response, 6);
            String searchString = this.searchFor + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logErr("User Principal incorrect.  Page received:");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test6 failed.");
            }
            this.logMsg("User Principal correct.");
            HashMap<String, Boolean> roleCheck = new HashMap<String, Boolean>();
            roleCheck.put("ADM", Boolean.FALSE);
            roleCheck.put("MGR", Boolean.TRUE);
            roleCheck.put("VP", Boolean.FALSE);
            roleCheck.put("EMP", Boolean.TRUE);
            if (!this.checkRoles(this.response.content, roleCheck)) {
                this.logErr("isUserInRole() does not work correctly.");
                this.logErr("Page Received:");
                this.logErr(this.response.content);
                throw new Exception("test6 failed.");
            }
            this.logMsg("isUserInRole() correct.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test6 failed: ", e);
        }
    }

    public void test7() throws Exception {
        try {
            this.request = this.pageBase + "/WEB-INF/";
            ArrayList<String> statusCodes = new ArrayList<String>();
            statusCodes.add("404");
            statusCodes.add("403");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/web-inf/";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            statusCodes.add("403");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/WEB-INF/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/web-inf/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
            this.request = this.pageBase + "/WEB-INF/web.xml";
            statusCodes = new ArrayList();
            statusCodes.add("404");
            this.testStatusCodes(this.request, statusCodes, "test7");
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void test8() throws Exception {
        try {
            this.request = this.pageBase + "/META-INF/";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                this.logErr("Did not receive expected error code" + this.request);
                this.logMsg("Status Token " + this.response.statusToken);
                this.logErr("Page content:");
                this.logErr(this.response.content);
                throw new Exception("test8 failed.");
            }
            this.logMsg("Status Token " + this.response.statusToken);
            this.logMsg("Received expected error code");
            this.request = this.pageBase + "/meta-inf/";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                this.logErr("Did not receive expected error code" + this.request);
                this.logMsg("Status Token " + this.response.statusToken);
                this.logErr("Page content:");
                this.logErr(this.response.content);
                throw new Exception("test8 failed.");
            }
            this.logMsg("Status Token " + this.response.statusToken);
            this.logMsg("Received expected error code");
            this.request = this.pageBase + "/META-INF/MANIFEST.MF";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                this.logErr("Did not receive expected error code" + this.request);
                this.logMsg("Status Token " + this.response.statusToken);
                this.logErr("Page content:");
                this.logErr(this.response.content);
                throw new Exception("test8 failed.");
            }
            this.logMsg("Status Token " + this.response.statusToken);
            this.logMsg("Received expected error code");
            this.request = this.pageBase + "/meta-inf/manifest.mf";
            this.logMsg("Sending request \"" + this.request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            this.response = this.followRedirect(this.response, 8);
            if (!this.response.statusToken.equals("404") && !this.response.statusToken.equals("403")) {
                this.logErr("Did not receive expected error code" + this.request);
                this.logMsg("Status Token " + this.response.statusToken);
                this.logErr("Page content:");
                this.logErr(this.response.content);
                throw new Exception("test8 failed.");
            }
            this.logMsg("Status Token " + this.response.statusToken);
            this.logMsg("Received expected error code");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test8 failed: ", e);
        }
    }

    public void test9() throws Exception {
        try {
            String testURL = null;
            String exactMatchURL = null;
            testURL = this.pageBase + "/One/index.html";
            exactMatchURL = this.pageOne;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/One/*";
            exactMatchURL = this.pageOne;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/*.jsp";
            exactMatchURL = this.pageTwo;
            this.compareURLContents(testURL, 9, exactMatchURL);
            testURL = this.pageBase + "/*.two";
            exactMatchURL = this.pageTwo;
            this.compareURLContents(testURL, 9, exactMatchURL);
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test9 failed: ", e);
        }
    }

    public void test10() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageSample, 10);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test10 failed.");
            }
            this.response = this.followRedirect(this.response, 10);
            String searchString = this.searchFor + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logErr("User Principal incorrect.  Page received:");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test10 failed.");
            }
            this.logMsg("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logErr("getRemoteUser() did not return " + this.username + ":");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test10 failed.");
            }
            this.logMsg("getRemoteUser() correct.");
            HashMap<String, Boolean> roleCheck = new HashMap<String, Boolean>();
            roleCheck.put("Administrator", Boolean.TRUE);
            if (!this.checkRoles(this.response.content, roleCheck)) {
                this.logErr("isUserInRole() does not work correctly.");
                this.logErr("Page Received:");
                this.logErr(this.response.content);
                throw new Exception("test10 failed.");
            }
            this.logMsg("isUserInRole() correct.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test10 failed: ", e);
        }
    }

    public void test11() throws Exception {
        try {
            this.logMsg("\nAccessing allRoles.jsp as user j2ee");
            this.requestAndGetLoginPage(this.pageallRoles, 11);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test11 failed.");
            }
            this.response = this.followRedirect(this.response, 11);
            this.logMsg("Successfully accessed allRoles.jsp as user j2ee");
            this.logMsg("\nAccessing allRoles.jsp as user javajoe");
            this.requestAndGetLoginPage(this.pageallRoles, 11);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            postData.clear();
            postData.put("j_username", this.unauthUsername);
            postData.put("j_password", this.unauthPassword);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test11 failed.");
            }
            this.response = this.followRedirect(this.response, 11);
            this.logMsg("Successfully accessed allRoles.jsp as user javajoe");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test11 failed: ", e);
        }
    }

    public void test12() throws Exception {
        try {
            this.logMsg("\nAccessing pageSample Using HTTP method POST");
            this.requestAndGetLoginPage(this.pageSample, 12);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            this.logMsg("response.content :" + this.response.content);
            this.logMsg("Successfully accessed " + this.pageSample + " with \"POST\"");
            this.request = this.pageSample;
            this.logMsg("\nAccessing pageSample Using HTTP method GET");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            this.logMsg("response.content :" + this.response.content);
            this.logMsg("Successfully accessed " + this.pageSample + " with \"GET\"");
            this.logMsg("\nAccessing pageSample Using HTTP method HEAD");
            this.response = WebUtil.sendRequest((String)"HEAD", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test12 failed.");
            }
            this.response = this.followRedirect(this.response, 12);
            this.logMsg("response.content :" + this.response.content);
            this.logMsg("Successfully accessed " + this.pageSample + " with \"HEAD\"");
            try (InputStream fstream = Thread.currentThread().getContextClassLoader().getResourceAsStream("sec/secform/Sample.jsp");){
                int fileContentLength = fstream.available();
                byte[] byteArray = new byte[1024];
                int bytesRead = fstream.read(byteArray, 0, fileContentLength);
                this.logMsg("\nDELETE " + this.pageSample + " Using HTTP method DELETE ....");
                this.response = WebUtil.sendRequest((String)"DELETE", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
                this.addNewCookies(this.cookies, this.response.cookies);
                if (this.response.isError()) {
                    this.logErr("Could not find " + this.request);
                    throw new Exception("test12 failed.");
                }
                this.logMsg("response.content :" + this.response.content);
                this.logMsg("Successfully accessed " + this.pageSample + " with \"DELETE\"");
                this.logMsg("\nPUT " + this.pageSample + " Using HTTP method PUT ....");
                this.response = SecformClient.uploadUsingHttpMethodPUT("PUT", InetAddress.getByName(this.hostname), this.portnum, this.request, byteArray, this.cookies, this.username, this.password);
                if (this.response.isError()) {
                    this.logErr("Could not find " + this.request);
                    throw new Exception("test12 failed.");
                }
                this.logMsg("response.content :" + this.response.content);
                this.logMsg("response.statusToken :" + this.response.statusToken);
                this.logMsg("uploaded " + this.pageSample + "using HTTP method PUT");
            }
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test12 failed: ", e);
        }
    }

    public void test13() throws Exception {
        try {
            this.request = this.pageServletBase + "/ControlServlet";
            this.logMsg("\nAccessing ControlServlet");
            this.logMsg("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, null);
            this.logMsg("response.content 1:" + this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test13 failed.");
            }
            this.response = this.followRedirect(this.response, 13);
            this.logMsg("response.content 2:" + this.response.content);
            this.logMsg("Successfully accessed ControlServlet, ForwardedServlet and IncludedServlet");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test13 failed: ", e);
        }
    }

    public void test14() throws Exception {
        try {
            this.logMsg("\nAccessing  pageSec: " + this.pageSec);
            this.requestAndGetLoginPage(this.pageSec, 14);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test14 failed.");
            }
            this.response = this.followRedirect(this.response, 14);
            String searchString = this.searchFor + this.username;
            if (this.response.content.indexOf(searchString) == -1) {
                this.logErr("User Principal incorrect.  Page received:");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            this.logMsg("User Principal correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logErr("getRemoteUser() did not return " + this.username + ":");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test1 failed.");
            }
            this.logMsg("getRemoteUser() correct.");
            HashMap<String, Boolean> roleCheck = new HashMap<String, Boolean>();
            roleCheck.put("ADM", Boolean.TRUE);
            roleCheck.put("MGR", Boolean.FALSE);
            roleCheck.put("VP", Boolean.FALSE);
            roleCheck.put("EMP", Boolean.TRUE);
            if (!this.checkRoles(this.response.content, roleCheck)) {
                this.logErr("isUserInRole() does not work correctly.");
                this.logErr("Page Received:");
                this.logErr(this.response.content);
                throw new Exception("test14 failed.");
            }
            this.logMsg("isUserInRole() correct.");
            this.request = this.pageSample;
            this.logMsg("\nAccessing pageSample :" + this.request);
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.pageSec);
                throw new Exception("test14 failed.");
            }
            if (!this.response.content.contains(searchString)) {
                this.logErr("User Principal incorrect.  Page received:");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            this.logMsg("User Principal still correct.");
            searchString = this.searchForGetRemoteUser + this.username;
            if (!this.response.content.contains(searchString)) {
                this.logErr("getRemoteUser() did not return " + this.username + " after lazy authentication:");
                this.logErr(this.response.content);
                this.logErr("(Should say: \"" + searchString + "\")");
                throw new Exception("test14 failed.");
            }
            this.logMsg("getRemoteUser() still correct.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test14 failed: ", e);
        }
    }

    public void test15() throws Exception {
        String modifiedPageSec = this.pageSec + this.pageSecurityCheck;
        try {
            this.logger.trace("Sending request {}", (Object)modifiedPageSec);
            try {
                this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)modifiedPageSec, null, null);
            }
            catch (Exception ex) {
                this.logErr("ERROR - got exception when trying to access restricted page w/out AuthN first.", ex);
                throw new Exception("test15 failed.");
            }
            if (this.response != null) {
                this.logger.trace("response.content= {}", (Object)this.response.content);
                String searchString = "getAuthType()";
                if (this.response.content.contains(searchString)) {
                    String err = "Error - we were not authenticated but were able to access the ";
                    err = err + "following page: " + modifiedPageSec + " with a return status = " + this.response.statusToken;
                    this.logErr(err);
                    this.logErr("response.content = " + this.response.content);
                    throw new Exception("test15 failed.");
                }
                this.logTrace("Good - we were not able to access restricted page without authenticating.");
            } else {
                this.logTrace("response=null");
            }
            this.logMsg("test15 passed.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test15 failed: ", e);
        }
    }

    public void test16() throws Exception {
        try {
            this.request = this.pageProgLogin;
            HashMap<String, String> postData = new HashMap<String, String>();
            this.logger.trace("setting request parameter my_username = {}", (Object)this.username);
            this.logger.trace("setting request parameter my_password = {}", (Object)this.password);
            postData.put("the_username", this.username);
            postData.put("the_password", this.password);
            this.logMsg("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.trace("response.content = {} {}", (Object)System.lineSeparator(), (Object)this.response.content);
            if (!this.response.statusToken.equals("200")) {
                this.logErr("ERROR:  not able to do Programmatic Login in: " + this.pageProgLogin);
                throw new Exception("test16 failed.");
            }
            if (this.response.isError()) {
                this.logErr("Error retrieving " + this.request);
                throw new Exception("test16 failed.");
            }
            this.logger.trace(this.response.content);
            String searchString = "ERROR - HttpServletRequest.login";
            if (this.response.content.contains(searchString)) {
                this.logErr(this.response.content);
                throw new Exception("test16 failed.");
            }
            searchString = "HttpServletRequest.login() passed";
            if (!this.response.content.contains(searchString)) {
                this.logErr(this.response.content);
                throw new Exception("test16 failed.");
            }
            this.logMsg("test16 passed.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test16 failed: ", e);
        }
    }

    public void test17() throws Exception {
        try {
            this.requestAndGetLoginPage(this.pageServletProgLogout, 1);
            this.request = this.pageSecurityCheck;
            this.logMsg("Sending request \"" + this.request + "\" with login information.");
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("j_username", this.username);
            postData.put("j_password", this.password);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.trace("response.content = {}", (Object)this.response.content);
            if (this.response.isError()) {
                this.logErr("Could not find " + this.request);
                throw new Exception("test17 failed.");
            }
            this.response = this.followRedirect(this.response, 17);
            this.logger.trace("response.content = {}", (Object)this.response.content);
            String searchString = "enterred ServletProgrammaticLogout.service()";
            if (!this.response.content.contains(searchString)) {
                String str = "Error - Did not get expected content from page: " + this.pageServletProgLogout;
                str = str + "  Content should have contained: " + searchString;
                this.logErr(str);
                throw new Exception("test17 failed.");
            }
            String errString = "ERROR - HttpServletRequest.logout()";
            if (this.response.content.contains(errString)) {
                String str = "Error - returned in content from page: " + this.pageServletProgLogout;
                this.logErr(str);
                throw new Exception("test17 failed.");
            }
            this.logMsg("test17 passed.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test17 failed: ", e);
        }
    }

    public void test18() throws Exception {
        try {
            this.request = this.pageProgAuthen;
            HashMap<String, String> postData = new HashMap<String, String>();
            postData.put("the_username", this.username);
            postData.put("the_password", this.password);
            this.logMsg("Sending request " + this.request);
            this.response = WebUtil.sendRequest((String)"POST", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, postData, this.cookies);
            this.logger.trace("YYYYY: response.content = {}{}", (Object)System.lineSeparator(), (Object)this.response.content);
            if (!this.response.statusToken.equals("200")) {
                this.logErr("ERROR:  not able to do Programmatic Login in: " + this.pageProgLogin);
                throw new Exception("test18 failed.");
            }
            if (this.response.isError()) {
                this.logErr("Error retrieving " + this.request);
                throw new Exception("test18 failed.");
            }
            String searchString = "ERROR - HttpServletRequest.authenticate";
            if (this.response.content.contains(searchString)) {
                this.logErr(this.response.content);
                throw new Exception("test18 failed.");
            }
            if (!this.response.content.contains("HttpServletRequest.authenticate passed")) {
                this.logErr(this.response.content);
                throw new Exception("test18 failed.");
            }
            this.logMsg("test18 passed.");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception("test18 failed: ", e);
        }
    }

    public static WebUtil.Response uploadUsingHttpMethodPUT(String method, InetAddress addr, int port, String req, byte[] postData, Map<String, String> cookieList, String username, String password) throws IOException {
        String protocol = "HTTP/1.0";
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        WebUtil.Response response = new WebUtil.Response();
        try {
            int c;
            URL requestURL = new URL("http", addr.getHostName(), port, req);
            req = method + " " + req + " " + protocol;
            socket = new Socket(addr, port);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
            out.println(req);
            if (cookieList != null && !cookieList.isEmpty()) {
                String cookieString = WebUtil.toCookieValue(cookieList);
                out.println(cookieString);
            }
            if (username != null) {
                String code = WebUtil.encodeBase64((String)(username + ":" + password));
                out.println("Authorization: Basic " + code.trim());
            }
            if (postData != null) {
                out.println("Content-type: text/data");
            }
            StringBuilder content = new StringBuilder(1024);
            ByteArrayInputStream bais = new ByteArrayInputStream(postData);
            while ((c = bais.read()) != -1) {
                content.append((char)c);
            }
            String fileContents = content.toString();
            if (postData != null && method.equalsIgnoreCase("PUT")) {
                String postString = WebUtil.encodeBase64((String)fileContents);
                out.println("Content-length: " + postString.length());
                out.println("");
                out.println(postString);
            } else {
                out.println("");
            }
            out.flush();
            String line = in.readLine();
            if (line != null) {
                StringTokenizer st = new StringTokenizer(line.trim());
                response.versionToken = st.nextToken();
                response.statusToken = st.nextToken();
            }
            while ((line = in.readLine()) != null && !line.trim().isEmpty()) {
                if (line.toLowerCase().startsWith("location:")) {
                    response.location = line.substring(10);
                    continue;
                }
                if (line.toLowerCase().startsWith("set-cookie:")) {
                    response.parseCookie(line);
                    continue;
                }
                if (!line.toLowerCase().startsWith("www-authenticate:")) continue;
                response.authenticationRequested = true;
            }
            while ((line = in.readLine()) != null) {
                response.content = response.content + line + "\n";
            }
            in.close();
            out.close();
        }
        catch (MalformedURLException e) {
            throw new IOException("MalformedURLException: " + e.getMessage());
        }
        catch (UnknownHostException e) {
            throw new IOException("UnknownHostException: " + e.getMessage());
        }
        catch (ConnectException e) {
            throw new IOException("ConnectException: " + e.getMessage());
        }
        return response;
    }

    private void requestAndGetLoginPage(String request, int testNum) throws Exception {
        this.logMsg("Sending request \"" + request + "\"");
        this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)request, null, null);
        if (this.response.isError()) {
            this.logErr("Could not find " + request);
            throw new Exception("test" + testNum + " failed.");
        }
        if (this.response.statusToken.equals("302")) {
            if (this.response.location == null) {
                this.logErr("No redirection to login page received.");
                throw new Exception("test" + testNum + " failed.");
            }
            request = WebUtil.getRequestFromURL((String)this.response.location);
            this.logMsg("Redirect to: " + this.response.location);
            this.cookies = this.response.cookies;
            this.logMsg("Before requesting redirected Page:response.content=" + this.response.content);
            this.logMsg("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)request, null, this.cookies);
            if (this.response.isError()) {
                this.logErr("Could not find " + request);
                throw new Exception("test" + testNum + " failed.");
            }
        } else {
            this.cookies = this.response.cookies;
        }
    }

    private void compareURLContents(String testURL, int testNum, String exactMatchURL) throws Exception {
        this.logMsg("Sending request \"" + testURL + "\"");
        this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)testURL, null, null);
        if (this.response.isError()) {
            this.logErr("Could not find " + testURL);
            throw new Exception("test" + testNum + " failed.");
        }
        WebUtil.Response response2 = null;
        this.logMsg("Sending request \"" + exactMatchURL + "\"");
        response2 = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)exactMatchURL, null, null);
        if (this.response.isError()) {
            this.logErr("Could not find " + exactMatchURL);
            throw new Exception("test" + testNum + " failed.");
        }
        this.logMsg("Comparing contents of " + testURL + " and " + exactMatchURL);
        if (!this.response.content.equals(response2.content)) {
            this.logErr("MISMATCH in contents of " + testURL + " and " + exactMatchURL);
            this.logErr("contents of " + testURL);
            this.logErr(this.response.content);
            this.logErr("contents of " + exactMatchURL);
            this.logErr(response2.content);
            throw new Exception("test" + testNum + " failed.");
        }
        this.logMsg("Contents MATCH : correct URL mapping\n");
    }

    private boolean checkRoles(String content, Map<String, Boolean> roleCheck) {
        boolean pass = true;
        for (Map.Entry<String, Boolean> entry : roleCheck.entrySet()) {
            String key = entry.getKey();
            boolean expected = entry.getValue();
            String search = "isUserInRole(\"" + key + "\"): !" + expected + "!";
            String logMsg = "Searching for \"" + search + "\": ";
            if (!content.contains(search)) {
                pass = false;
                logMsg = logMsg + "NOT FOUND!";
            } else {
                logMsg = logMsg + "found.";
            }
            this.logMsg(logMsg);
        }
        return pass;
    }

    @Override
    public void cleanup() throws Exception {
        this.logMsg("cleanup");
    }

    public WebUtil.Response followRedirect(WebUtil.Response response, int testNum) throws Exception {
        if (response.statusToken.equals("301") || response.statusToken.equals("302")) {
            if (response.location == null) {
                this.logErr("redirection URL : null");
                throw new Exception("test" + testNum + " failed.");
            }
            this.request = WebUtil.getRequestFromURL((String)response.location);
            this.logMsg("Redirect to: " + response.location);
            this.addNewCookies(this.cookies, response.cookies);
            this.logMsg("Sending request \"" + this.request + "\"");
            response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.request, null, this.cookies);
            this.addNewCookies(this.cookies, response.cookies);
            if (testNum != 7 && testNum != 8 && response.isError()) {
                this.logErr("Status Token " + response.statusToken);
                this.logErr("Could not find " + this.request);
                throw new Exception("test" + testNum + " failed.");
            }
        } else {
            this.addNewCookies(this.cookies, response.cookies);
        }
        return response;
    }

    public void addNewCookies(Map<String, String> oldCookies, Map<String, String> newCookies) {
        newCookies.forEach((key, value) -> oldCookies.put(key.trim(), value.trim()));
    }

    private void testStatusCodes(String request, List<String> expectedCodes, String testName) throws Exception {
        try {
            this.logMsg("Sending request \"" + request + "\"");
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)request, null, null);
            this.response = this.followRedirect(this.response, 7);
            if (!expectedCodes.contains(this.response.statusToken)) {
                this.logErr("Did not receive expected error code" + request);
                this.logMsg("Status Token " + this.response.statusToken);
                this.logErr("Page content: ");
                this.logErr(this.response.content);
                throw new Exception(testName + " failed.");
            }
            this.logMsg("Status Token " + this.response.statusToken);
            this.logMsg("Received expected error code");
        }
        catch (Exception e) {
            this.logErr("Caught exception: " + e.getMessage(), e);
            throw new Exception(testName + " failed: ", e);
        }
    }
}

