/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.DirectoryFileFilter;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SwingFileFilter;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

public class FileQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    static JFileChooser createChooser(String title, FileFilter ... filters) {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(title);
        if (filters == null || filters.length == 0) {
            chooser.setAcceptAllFileFilterUsed(true);
            chooser.setFileSelectionMode(0);
        } else {
            int mode = -1;
            for (FileFilter filter : filters) {
                chooser.addChoosableFileFilter(SwingFileFilter.wrap(filter));
                if (filter.acceptsDirectories()) {
                    if (mode == -1) {
                        mode = 2;
                        continue;
                    }
                    if (mode != 0) continue;
                    mode = 2;
                    continue;
                }
                if (mode == -1) {
                    mode = 0;
                    continue;
                }
                if (mode != 1) continue;
                mode = 2;
            }
            chooser.setFileSelectionMode(mode);
        }
        return chooser;
    }

    @Override
    public JComponent getQuestionRendererComponent(Question qq, ActionListener listener) {
        String[] strSuggs;
        FileQuestion q = (FileQuestion)qq;
        JFileChooser chooser = FileQuestionRenderer.createChooser(q.getSummary(), q.getFilters());
        File f = q.getValue();
        if (f == null) {
            File dir = q.getBaseDirectory();
            if (dir == null) {
                dir = new File(System.getProperty("user.dir"));
            }
            chooser.setCurrentDirectory(dir);
        } else {
            chooser.setSelectedFile(f);
        }
        JButton browseBtn = new JButton(i18n.getString("file.browse.btn"));
        browseBtn.setName("file.browse.btn");
        browseBtn.setMnemonic(i18n.getString("file.browse.mne").charAt(0));
        browseBtn.setToolTipText(i18n.getString("file.browse.tip"));
        File[] suggs = q.getSuggestions();
        if (suggs == null) {
            strSuggs = null;
        } else {
            strSuggs = new String[suggs.length];
            for (int i = 0; i < suggs.length; ++i) {
                strSuggs[i] = suggs[i].getPath();
            }
        }
        String fileType = "file";
        if (this.isSelectingDir(q.getFilters())) {
            fileType = "file.dir";
        }
        TypeInPanel p = new TypeInPanel(fileType, q, 0, strSuggs, browseBtn, listener);
        browseBtn.addActionListener(e -> {
            int opt;
            String s = p.getValue();
            if (s != null && !s.isEmpty()) {
                File f1 = new File(s);
                File baseDir = q.getBaseDirectory();
                if (!f1.isAbsolute() && baseDir != null) {
                    f1 = new File(baseDir, s);
                }
                chooser.setSelectedFile(f1);
            }
            if ((opt = chooser.showDialog(browseBtn, "Select")) == 0) {
                String bp;
                File baseDir;
                String path = chooser.getSelectedFile().getPath();
                FileFilter ff = SwingFileFilter.unwrap(chooser.getFileFilter());
                if (ff != null && ff instanceof ExtensionFileFilter) {
                    ExtensionFileFilter eff = (ExtensionFileFilter)ff;
                    path = eff.ensureExtension(path);
                }
                if ((baseDir = q.getBaseDirectory()) != null && path.startsWith((bp = baseDir.getPath()) + File.separatorChar)) {
                    path = path.substring(bp.length() + 1);
                }
                p.setValue(path);
            }
        });
        return p;
    }

    @Override
    public String getInvalidValueMessage(Question q) {
        return null;
    }

    private boolean isSelectingDir(FileFilter ... filters) {
        if (filters == null || filters.length == 0) {
            return false;
        }
        boolean allDirType = true;
        for (FileFilter f : filters) {
            allDirType = allDirType && f instanceof DirectoryFileFilter;
        }
        return allDirType;
    }
}

