/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MultiFormatPane;
import com.sun.javatest.exec.NavigationPane;
import com.sun.javatest.exec.TextPane;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

class FilesPane
extends JPanel
implements Printable {
    private JTextField noteField;
    private UIFactory uif;
    private MultiFormatPane mediaPane;
    private NavigationPane navPane;

    FilesPane(UIFactory uif) {
        this.uif = uif;
        this.initGUI();
    }

    public MultiFormatPane getMediaPane() {
        return this.mediaPane;
    }

    public NavigationPane getNavigationPane() {
        return this.navPane;
    }

    File getBaseDirectory() {
        return this.mediaPane.getBaseDirectory();
    }

    void setBaseDirectory(File base) {
        this.mediaPane.setBaseDirectory(base);
    }

    void setText(String text, String MIME) {
        this.mediaPane.showText(text, MIME);
    }

    String getText() {
        return ((JEditorPane)((Object)this.mediaPane.getMediaPane(0))).getText();
    }

    void setFile(URL file) {
        if (file != null) {
            this.setFiles(file);
        }
    }

    void setFiles(URL ... files) {
        this.mediaPane.clear();
        this.navPane.setURLs(files);
        this.mediaPane.loadPage(files[0]);
    }

    URL getPage() {
        return this.mediaPane.getPage();
    }

    private void initGUI() {
        this.setName("fp");
        this.setFocusable(false);
        this.setLayout(new BorderLayout());
        this.mediaPane = new MultiFormatPane(this.uif);
        this.navPane = new NavigationPane(this.uif, this.mediaPane);
        this.add((Component)this.navPane, "North");
        this.add((Component)this.mediaPane, "Center");
        this.noteField = this.uif.createOutputField("fp.note");
        this.mediaPane.setNoteField(this.noteField);
        this.add((Component)this.noteField, "South");
    }

    void clear() {
        this.mediaPane.clear();
    }

    String getMIMEType(URL url) {
        return TextPane.getMIMEType(url);
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        return this.mediaPane.print(g, pf, pageIndex);
    }

    static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18n, String s) {
            super(i18n.getString(s));
        }

        Fault(I18NResourceBundle i18n, String s, Object o) {
            super(i18n.getString(s, o));
        }
    }
}

