/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.TestEnvironment;
import com.sun.javatest.services.ParametrizeValue;
import com.sun.javatest.services.Term;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ServiceProperties {
    private ServiceProperties common;
    private Properties externalProps;
    private HashMap<String, String> lastResolution;
    private Map<String, Set<String>> varMap;
    private Map<String, ParametrizeValue> varProps;
    private Map<String, String> constProps;

    public ServiceProperties(ServiceProperties common) {
        this.common = common;
        this.externalProps = new Properties();
        this.varMap = new HashMap<String, Set<String>>();
        this.varProps = new HashMap<String, ParametrizeValue>();
        this.constProps = new HashMap<String, String>();
    }

    public boolean isEmpty() {
        return !(this.constProps != null && this.constProps.size() != 0 || this.varProps != null && this.varProps.size() != 0 || this.varMap != null && this.varMap.size() != 0);
    }

    public void addProperty(String key, String value) {
        if (value == null) {
            this.commitProperty(key, null);
            return;
        }
        ParametrizeValue val = new ParametrizeValue();
        while (value.length() > 0) {
            Term t = new Term();
            int len = this.nextTerm(value, t);
            value = value.substring(len);
            val.addTerm(t);
        }
        this.commitProperty(key, val);
    }

    public void setExternalProperties(Properties props) {
        this.externalProps = props;
        this.lastResolution = null;
        if (this.common != null) {
            this.common.setExternalProperties(props);
        }
    }

    public void setExternalProperties(TestEnvironment env) {
        Properties props = new Properties();
        for (Object o : env.keys()) {
            String key = (String)o;
            String value = new String();
            try {
                for (String s : env.lookup(key)) {
                    value = value + s;
                }
            }
            catch (TestEnvironment.Fault fault) {
                // empty catch block
            }
            props.setProperty(key, value);
        }
        props.putAll((Map<?, ?>)env.getExtraValues());
        this.setExternalProperties(props);
    }

    public Properties getExternalProperties() {
        return this.externalProps;
    }

    public Map<String, String> resolveProperties() {
        if (this.lastResolution != null) {
            return (Map)this.lastResolution.clone();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        result.putAll(this.constProps);
        Map<String, String> justResolved = new HashMap<String, String>();
        justResolved.putAll(this.constProps);
        if (this.common != null) {
            justResolved.putAll(this.common.resolveProperties());
        }
        for (Object key : this.externalProps.keySet()) {
            String skey = (String)key;
            justResolved.put(skey, this.externalProps.getProperty(skey));
        }
        Map<String, ParametrizeValue> copyVars = this.copyVarProps();
        while (justResolved.size() > 0) {
            justResolved = this.resolveVars(copyVars, justResolved);
            result.putAll(justResolved);
        }
        this.lastResolution = new HashMap(result);
        return result;
    }

    private Map<String, String> resolveVars(Map<String, ParametrizeValue> varProps, Map<String, String> resolved) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : resolved.keySet()) {
            if (!this.varMap.containsKey(key)) continue;
            for (String pkey : this.varMap.get(key)) {
                if (!varProps.containsKey(pkey)) continue;
                ParametrizeValue val = varProps.get(pkey);
                val.replace(key, resolved.get(key));
                if (!val.resolved()) continue;
                varProps.remove(pkey);
                result.put(pkey, val.stringValue());
            }
        }
        return result;
    }

    private Map<String, ParametrizeValue> copyVarProps() {
        HashMap<String, ParametrizeValue> copy = new HashMap<String, ParametrizeValue>();
        for (String key : this.varProps.keySet()) {
            copy.put(key, this.varProps.get(key).copy());
        }
        return copy;
    }

    private void commitProperty(String key, ParametrizeValue value) {
        if (value == null) {
            value = new ParametrizeValue();
            Term t = new Term();
            t.setValue(key, true);
            LinkedList<Term> l = new LinkedList<Term>();
            l.add(t);
            value.setValue(l);
        }
        if (value.resolved()) {
            this.constProps.put(key, value.stringValue());
        } else {
            this.constructMapping(key, value);
            this.varProps.put(key, value);
        }
        this.lastResolution = null;
    }

    private void constructMapping(String key, ParametrizeValue value) {
        if (value.resolved()) {
            return;
        }
        for (Term t : value.getTerms()) {
            if (!t.isVariable()) continue;
            String paramName = t.getValue();
            if (this.varMap.containsKey(paramName)) {
                this.varMap.get(paramName).add(key);
                continue;
            }
            HashSet<String> usages = new HashSet<String>();
            usages.add(key);
            this.varMap.put(paramName, usages);
        }
        if (this.varMap.containsKey(key)) {
            this.varMap.get(key).add(key);
        } else {
            HashSet<String> usages = new HashSet<String>();
            usages.add(key);
            this.varMap.put(key, usages);
        }
    }

    private int nextTerm(String s, Term dest) {
        int i;
        boolean var;
        boolean bl = var = s.charAt(0) == '$' && s.charAt(1) == '{';
        if (var) {
            for (i = 0; i < s.length() && s.charAt(i) != '}'; ++i) {
            }
            s = s.substring(2, ++i - 1);
        } else {
            while (i < s.length() && (s.charAt(i) != '$' || s.charAt(i - 1) == '\\')) {
                ++i;
            }
            s = s.substring(0, i);
        }
        dest.setValue(s, var);
        return i;
    }
}

