/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;

public class HTMLWriter {
    public static final String A = "a";
    public static final String ALIGN = "align";
    public static final String B = "b";
    public static final String BODY = "body";
    public static final String BORDER = "border";
    public static final String BR = "br";
    public static final String CLASSID = "classid";
    public static final String CODE = "code";
    public static final String COLOR = "color";
    public static final String COL = "col";
    public static final String FONT = "font";
    public static final String H1 = "h1";
    public static final String H2 = "h2";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String HEAD = "head";
    public static final String HREF = "href";
    public static final String HTML = "html";
    public static final String HR = "hr";
    public static final String I = "i";
    public static final String IMAGE = "image";
    public static final String LEFT = "left";
    public static final String LI = "li";
    public static final String LINK = "link";
    public static final String NAME = "name";
    public static final String OBJECT = "object";
    public static final String PARAM = "param";
    public static final String P = "p";
    public static final String REL = "rel";
    public static final String RIGHT = "right";
    public static final String ROW = "row";
    public static final String SMALL = "small";
    public static final String SRC = "src";
    public static final String SCOPE = "scope";
    public static final String STYLE = "style";
    public static final String TABLE = "table";
    public static final String TD = "td";
    public static final String TITLE = "title";
    public static final String TH = "th";
    public static final String TOP = "top";
    public static final String TR = "tr";
    public static final String TYPE = "type";
    public static final String UL = "ul";
    public static final String VALIGN = "valign";
    public static final String VALUE = "value";
    private BufferedWriter out;
    private int state;
    private I18NResourceBundle i18n;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;

    public HTMLWriter(Writer out) throws IOException {
        this(out, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
    }

    public HTMLWriter(Writer out, String docType) throws IOException {
        this.out = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        this.out.write(docType);
        this.out.newLine();
    }

    public HTMLWriter(Writer out, I18NResourceBundle i18n) throws IOException {
        this(out);
        this.i18n = i18n;
    }

    public HTMLWriter(Writer out, String docType, I18NResourceBundle i18n) throws IOException {
        this(out, docType);
        this.i18n = i18n;
    }

    public void setI18NResourceBundle(I18NResourceBundle i18n) {
        this.i18n = i18n;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void newLine() throws IOException {
        this.out.newLine();
    }

    public void startTag(String tag) throws IOException {
        this.closePrevTag();
        this.newLine();
        this.out.write("<");
        this.out.write(tag);
        this.state = 1;
    }

    public void endTag(String tag) throws IOException {
        if (this.closePrevTag()) {
            this.out.newLine();
        }
        this.out.write("</");
        this.out.write(tag);
        this.out.write(">");
        this.state = 2;
    }

    public void endEmptyTag(String tag) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(">");
        this.state = 2;
        this.out.newLine();
    }

    public void writeAttr(String name, String value) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(name);
        this.out.write("=");
        boolean alpha = true;
        for (int i = 0; i < value.length() && alpha; ++i) {
            alpha = Character.isLetter(value.charAt(i));
        }
        if (!alpha) {
            this.out.write("\"");
        }
        this.out.write(value);
        if (!alpha) {
            this.out.write("\"");
        }
    }

    public void writeAttr(String name, int value) throws IOException {
        this.writeAttr(name, Integer.toString(value));
    }

    public void writeLine(String text) throws IOException {
        this.write(text);
        this.out.newLine();
    }

    public void writeRaw(String text) throws IOException {
        this.closePrevTag();
        if (text != null) {
            this.out.write(text);
        }
    }

    public void write(String text) throws IOException {
        int i;
        this.closePrevTag();
        if (text == null) {
            return;
        }
        boolean specialChars = false;
        for (i = 0; i < text.length() && !specialChars; ++i) {
            switch (text.charAt(i)) {
                case '&': 
                case '<': 
                case '>': {
                    specialChars = true;
                }
            }
        }
        if (specialChars) {
            block9: for (i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        continue block9;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block9;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block9;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        } else {
            this.out.write(text);
        }
    }

    public void writeEntity(String entity) throws IOException {
        this.closePrevTag();
        this.out.write(entity);
    }

    public void writeImage(String imagePath) throws IOException {
        this.startTag(IMAGE);
        this.writeAttr(SRC, imagePath);
    }

    public void writeImage(URL imageURL) throws IOException {
        this.writeImage(imageURL.toString());
    }

    public void writeLink(String anchor, String body) throws IOException {
        this.startTag(A);
        this.writeAttr(HREF, anchor);
        this.write(body);
        this.endTag(A);
    }

    public void writeLink(File file, String body) throws IOException {
        this.startTag(A);
        StringBuffer sb = new StringBuffer();
        String path = file.getPath();
        if (file.isAbsolute() && !path.startsWith("/")) {
            sb.append('/');
        }
        for (int i = 0; i < path.length(); ++i) {
            String pathSymbol = path.charAt(i) == File.separatorChar ? "/" : URLEncoder.encode(String.valueOf(path.charAt(i)), "UTF-8");
            sb.append(pathSymbol);
        }
        this.writeAttr(HREF, sb.toString());
        this.write(body);
        this.endTag(A);
    }

    public void writeLink(File file) throws IOException {
        this.writeLink(file, file.getPath());
    }

    public void writeLink(URL url, String body) throws IOException {
        this.startTag(A);
        this.writeAttr(HREF, url.toString());
        this.write(body);
        this.endTag(A);
    }

    public void writeLinkDestination(String anchor, String body) throws IOException {
        this.startTag(A);
        this.writeAttr(NAME, anchor);
        this.write(body);
        this.endTag(A);
    }

    public void writeParam(String name, String value) throws IOException {
        this.startTag(PARAM);
        this.writeAttr(NAME, name);
        this.writeAttr(VALUE, value);
    }

    public void writeStyleAttr(String value) throws IOException {
        this.writeAttr(STYLE, value);
    }

    public void write(I18NResourceBundle i18n, String key) throws IOException {
        this.write(i18n.getString(key));
    }

    public void write(I18NResourceBundle i18n, String key, Object arg) throws IOException {
        this.write(i18n.getString(key, arg));
    }

    public void write(I18NResourceBundle i18n, String key, Object[] args) throws IOException {
        this.write(i18n.getString(key, args));
    }

    public void writeI18N(String key) throws IOException {
        this.write(this.i18n.getString(key));
    }

    public void writeI18N(String key, Object arg) throws IOException {
        this.write(this.i18n.getString(key, arg));
    }

    public void writeI18N(String key, Object[] args) throws IOException {
        this.write(this.i18n.getString(key, args));
    }

    protected boolean closePrevTag() throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
            return true;
        }
        return false;
    }
}

