/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox.multianno;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TSConnection;
import com.sun.ts.tests.common.connector.whitebox.TSConnectionImpl;
import com.sun.ts.tests.common.connector.whitebox.TSEISDataSource;
import com.sun.ts.tests.common.connector.whitebox.TSManagedConnection;
import com.sun.ts.tests.common.connector.whitebox.Util;
import jakarta.resource.Referenceable;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ConnectionManager;
import jakarta.resource.spi.ConnectionRequestInfo;
import jakarta.resource.spi.EISSystemException;
import jakarta.resource.spi.ManagedConnection;
import jakarta.resource.spi.ManagedConnectionFactory;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.ResourceAdapterAssociation;
import jakarta.resource.spi.security.PasswordCredential;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;
import javax.naming.Reference;
import javax.security.auth.Subject;

public class OtherMCF
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
Serializable,
Referenceable {
    private Reference reference;
    private ResourceAdapter resourceAdapter;
    private int count;
    private String password;
    private String user;
    private String userName;

    public String getUser() {
        return this.user;
    }

    public void setUser(String val) {
        this.user = val;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String val) {
        this.userName = val;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String val) {
        this.password = val;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("OtherMCF.createConnectionFactory", "cxManager", "TSEISDataSource");
        return new TSEISDataSource(this, cxManager);
    }

    public Object createConnectionFactory() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("OtherMCF.createConnectionFactory", "", "TSEISDataSource");
        return new TSEISDataSource(this, null);
    }

    public void setResourceAdapter(ResourceAdapter ra) throws ResourceException {
        ++this.count;
        String newStr1 = new String("OtherMCF setResourceAdapter " + this.count);
        Debug.trace(newStr1);
        this.resourceAdapter = ra;
    }

    public ResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo info) throws ResourceException {
        try {
            ConnectorStatus.getConnectorStatus().logAPI("OtherMCF.createManagedConnection", "subject|info", "TSManagedConnection");
            TSConnection con = null;
            PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
            if (pc == null) {
                Debug.trace("OtherMCF.createManagedConnection():  pc == null");
                Debug.trace("TSConnectionImpl.getConnection()");
                con = new TSConnectionImpl().getConnection();
            } else {
                Debug.trace("OtherMCF.createManagedConnection():  pc != null");
                this.setUser(pc.getUserName());
                this.setUserName(pc.getUserName());
                this.setPassword(new String(pc.getPassword()));
                Debug.trace("TSConnectionImpl.getConnection(u,p)");
                con = new TSConnectionImpl().getConnection(pc.getUserName(), pc.getPassword());
            }
            return new TSManagedConnection(this, pc, null, con, false, true);
        }
        catch (Exception ex) {
            EISSystemException re = new EISSystemException("Exception: " + ex.getMessage());
            re.initCause((Throwable)ex);
            throw re;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("OtherMCF.matchManagedConnection", "connectionSet|subject|info", "TSEISDataSource");
        PasswordCredential pc = Util.getPasswordCredential(this, subject, info);
        for (Object obj : connectionSet) {
            if (!(obj instanceof TSManagedConnection)) continue;
            TSManagedConnection mc = (TSManagedConnection)obj;
            ManagedConnectionFactory mcf = mc.getManagedConnectionFactory();
            if (!Util.isPasswordCredentialEqual(mc.getPasswordCredential(), pc) || !mcf.equals((Object)this)) continue;
            return mc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("setLogWriter", "out", "");
    }

    public PrintWriter getLogWriter() throws ResourceException {
        ConnectorStatus.getConnectorStatus().logAPI("getLogWriter", "", "");
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof OtherMCF)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        OtherMCF that = (OtherMCF)obj;
        if (this.reference != null && !this.reference.equals(that.getReference())) {
            return false;
        }
        if (this.reference == null && that.getReference() != null) {
            return false;
        }
        if (this.resourceAdapter != null && !this.resourceAdapter.equals(that.getResourceAdapter())) {
            return false;
        }
        if (this.resourceAdapter == null && that.getResourceAdapter() != null) {
            return false;
        }
        if (this.count != that.getCount()) {
            return false;
        }
        if (!Util.isEqual(this.password, that.getPassword())) {
            return false;
        }
        if (!Util.isEqual(this.user, that.getUser())) {
            return false;
        }
        return Util.isEqual(this.userName, that.getUserName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public Reference getReference() {
        Reference ref = this.reference;
        return ref;
    }

    public void setReference(Reference ref) {
        this.reference = ref;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int val) {
        this.count = val;
    }
}

