/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator;

import com.sun.ts.tests.websocket.common.impl.ExtensionImpl;
import com.sun.ts.tests.websocket.common.impl.ExtensionParameterImpl;
import com.sun.ts.tests.websocket.common.util.IOUtil;
import com.sun.ts.tests.websocket.common.util.StringUtil;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.ExtensionsConfigurator;
import com.sun.ts.tests.websocket.ee.jakarta.websocket.server.serverendpointconfig.configurator.ExtensionsServerEndpointConfig;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import jakarta.websocket.server.ServerEndpointConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class WSCExtensionsServer
extends Endpoint
implements MessageHandler.Whole<String> {
    Session session;
    ServerEndpointConfig config;

    public void onMessage(String msg) {
        boolean contains = false;
        List<ExtensionImpl> response = null;
        try {
            if (msg.equals("requested")) {
                contains = StringUtil.contains(ExtensionsConfigurator.getRequested(), WSCExtensionsServer.getRequestedExtension());
                response = contains ? WSCExtensionsServer.getRequestedExtension() : ExtensionsConfigurator.getRequested();
            } else if (msg.equals("resulted")) {
                contains = StringUtil.contains(ExtensionsConfigurator.getResulted(), WSCExtensionsServer.getRequestedExtension());
                response = contains ? WSCExtensionsServer.getRequestedExtension() : ExtensionsConfigurator.getResulted();
            } else if (msg.equals("installed")) {
                List<ExtensionImpl> configured = ExtensionImpl.transformToImpl(this.config.getExtensions());
                contains = StringUtil.contains(ExtensionsConfigurator.getInstalled(), configured);
                response = contains ? ExtensionsConfigurator.getInstalled() : configured;
            } else if (msg.equals("resultedinorder")) {
                contains = StringUtil.containsInOrder(ExtensionsConfigurator.getResulted(), WSCExtensionsServer.getOrderedExtensions());
                response = contains ? WSCExtensionsServer.getOrderedExtensions() : ExtensionsConfigurator.getResulted();
            }
            this.session.getBasicRemote().sendText(ExtensionImpl.toString(response));
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                this.session.getBasicRemote().sendText(IOUtil.printStackTrace(e));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.session = session;
        this.config = (ServerEndpointConfig)config;
        session.addMessageHandler((MessageHandler)this);
    }

    public void onError(Session session, Throwable thr) {
        thr.printStackTrace();
        String message = IOUtil.printStackTrace(thr);
        try {
            session.getBasicRemote().sendText(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<ExtensionImpl> getRequestedExtension() {
        ExtensionParameterImpl firstParam = ExtensionsServerEndpointConfig.PARAMETER[0];
        ExtensionParameterImpl secondParam = ExtensionsServerEndpointConfig.PARAMETER[1];
        ExtensionImpl extension = new ExtensionImpl(ExtensionsServerEndpointConfig.EXT_NAMES[0], firstParam, secondParam);
        ArrayList<ExtensionImpl> list = new ArrayList<ExtensionImpl>();
        list.add(extension);
        return list;
    }

    public static List<ExtensionImpl> getOrderedExtensions() {
        ExtensionParameterImpl firstParam = ExtensionsServerEndpointConfig.PARAMETER[0];
        ExtensionParameterImpl secondParam = ExtensionsServerEndpointConfig.PARAMETER[1];
        ExtensionImpl extension = new ExtensionImpl(ExtensionsServerEndpointConfig.EXT_NAMES[1], firstParam, secondParam);
        ArrayList<ExtensionImpl> list = new ArrayList<ExtensionImpl>();
        list.add(extension);
        list.add(WSCExtensionsServer.getRequestedExtension().iterator().next());
        return list;
    }

    public static List<ExtensionImpl> getNotNegotiableExtension() {
        ExtensionParameterImpl secondParam = new ExtensionParameterImpl("thirdName", "thirdValue");
        List<ExtensionImpl> list = WSCExtensionsServer.getRequestedExtension();
        list.iterator().next().addParameters(secondParam);
        return list;
    }
}

