/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.nonpositiveinteger.enumeration.enumeration_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import java.math.BigInteger;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class enumeration1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        enumeration1_ValidateCTTests test = new enumeration1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final BigInteger[] validValues = {new BigInteger("-17416230241"), new BigInteger("-8643589967190224987"), new BigInteger("-676843"),
                                      new BigInteger("-497359738618"), new BigInteger("-45554400334776878"), new BigInteger("-8782453402663260577"),
                                      new BigInteger("-1874884102"), new BigInteger("-941995830152"), new BigInteger("-72"),
                                      new BigInteger("-117573"), new BigInteger("-1437611345877"), new BigInteger("-51399307227677"),
                                      new BigInteger("-821329"), new BigInteger("-716997651572763294"), new BigInteger("-39713096218389"),
                                      new BigInteger("-8095"), new BigInteger("-905538"), new BigInteger("-69233349799300")};
    final BigInteger[] invalidValues = {new BigInteger("0"), new BigInteger("-1"), new BigInteger("-71"), 
                                        new BigInteger("-10000"), new BigInteger("51399307227677"), new BigInteger("-51399307227678")};
    
    JAXBElement<BigInteger> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "enumeration-1-1.xml";
        elemObj = (JAXBElement<BigInteger>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerEnumeration1(new BigInteger("-72"));
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<BigInteger>)(new ObjectFactory()).createNISTSchemaNonPositiveIntegerEnumeration1(new BigInteger("-72"));
        
        return testInvalid();
    }


}

