/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.maxexclusive.maxexclusive_4;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class maxExclusive4_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        maxExclusive4_ValidateCTTests test = new maxExclusive4_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final int[] validValues = {-1451959895, -2147483648};
    final int[] invalidValues = {-1451959894, -1000, 0, 1000, 2147483647};
    
    JAXBElement<Integer> elemObj;

    Status testInvalid() {
        for (int i = 0; i < invalidValues.length; ++i){
            
                elemObj.setValue(invalidValues[i]);
                Status status = validate(elemObj);
                if (status.isPassed()) {
                    return Status.failed("" + invalidValues[i] + " is unexpectedly valid");
                }
            
        }
        return Status.passed("OK");
    }

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "maxExclusive-4-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate002( ) {
        String xmlDocName = "maxExclusive-4-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testInvalid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntMaxExclusive4(-2147483647);
        
        return testValid();
    }

    public Status Validate004( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntMaxExclusive4(-2147483647);
        
        return testInvalid();
    }


}

