/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.MinimalEObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.INode;
import org.eclipse.january.geometry.Operator;
import org.eclipse.january.geometry.Triangle;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.swt.widgets.Display;

public class OperatorImpl
extends MinimalEObjectImpl.Container
implements Operator {
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final long ID_EDEFAULT = 0L;
    protected long id = 0L;
    protected EList<INode> nodes;
    protected static final String TYPE_EDEFAULT = null;
    protected String type = TYPE_EDEFAULT;
    protected EList<Triangle> triangles;
    protected Vertex center;
    protected INode parent;
    protected HashMap<String, Double> properties = new HashMap();

    protected OperatorImpl() {
        this.center = GeometryFactory.eINSTANCE.createVertex();
    }

    protected EClass eStaticClass() {
        return GeometryPackage.Literals.OPERATOR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldName, (Object)this.name));
        }
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long newId) {
        long oldId = this.id;
        this.id = newId;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, oldId, this.id));
        }
    }

    @Override
    public EList<INode> getNodes() {
        if (this.nodes == null) {
            this.nodes = new EObjectContainmentEList(INode.class, (InternalEObject)this, 2);
        }
        return this.nodes;
    }

    @Override
    public void addNodes(EList<INode> children) {
        for (INode node : children) {
            this.addNode(node);
        }
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String newType) {
        String oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldType, (Object)this.type));
        }
    }

    @Override
    public EList<Triangle> getTriangles() {
        if (this.triangles == null) {
            this.triangles = new EObjectContainmentEList(Triangle.class, (InternalEObject)this, 4);
        }
        return this.triangles;
    }

    @Override
    public Vertex getCenter() {
        if (this.center != null && this.center.eIsProxy()) {
            InternalEObject oldCenter = (InternalEObject)this.center;
            this.center = (Vertex)this.eResolveProxy(oldCenter);
            if (this.center != oldCenter && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 5, (Object)oldCenter, (Object)this.center));
            }
        }
        return this.center;
    }

    public Vertex basicGetCenter() {
        return this.center;
    }

    @Override
    public void setCenter(Vertex newCenter) {
        Vertex oldCenter = this.center;
        this.center = newCenter;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCenter, (Object)this.center));
        }
    }

    @Override
    public INode getParent() {
        if (this.parent != null && this.parent.eIsProxy()) {
            InternalEObject oldParent = (InternalEObject)this.parent;
            this.parent = (INode)this.eResolveProxy(oldParent);
            if (this.parent != oldParent && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 6, (Object)oldParent, (Object)this.parent));
            }
        }
        return this.parent;
    }

    public INode basicGetParent() {
        return this.parent;
    }

    @Override
    public void setParent(INode newParent) {
        INode oldParent = this.parent;
        this.parent = newParent;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldParent, (Object)this.parent));
        }
    }

    @Override
    public void changeDecoratorProperty(String property, Object value) {
        this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)property, value));
    }

    @Override
    public EList<String> getPropertyNames() {
        return new BasicEList(this.properties.keySet());
    }

    @Override
    public double getProperty(String property) {
        return this.properties.get(property);
    }

    @Override
    public void setProperty(String property, double value) {
        this.properties.put(property, value);
    }

    @Override
    public void addNode(INode child) {
        if (child != null) {
            for (INode node : this.getNodes()) {
                if (node != child) continue;
                return;
            }
            child.setParent(this);
            this.nodes.add((Object)child);
        }
        this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 3, 4, null, (Object)child));
    }

    @Override
    public void removeNode(INode child) {
        if (this.getNodes().contains((Object)child)) {
            child.setParent(null);
            this.nodes.remove((Object)child);
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 4, 5, (Object)child, (Object)child));
        }
    }

    @Override
    public void copy(Object source) {
        if (source instanceof Operator) {
            Operator castSource = (Operator)source;
            this.getCenter().setX(castSource.getCenter().getX());
            this.center.setY(castSource.getCenter().getY());
            this.center.setZ(castSource.getCenter().getZ());
            this.id = castSource.getId();
            this.name = castSource.getName();
            this.type = castSource.getType();
            for (INode node : this.getNodes()) {
                this.removeNode(node);
            }
            for (INode node : castSource.getNodes()) {
                this.addNode((INode)node.clone());
            }
            this.properties.clear();
            for (String property : castSource.getPropertyNames()) {
                this.properties.put(property, castSource.getProperty(property));
            }
            this.getTriangles().clear();
            for (Triangle triangle : castSource.getTriangles()) {
                Triangle cloneTriangle = GeometryFactory.eINSTANCE.createTriangle();
                for (Vertex vertex : triangle.getVertices()) {
                    Vertex cloneVertex = GeometryFactory.eINSTANCE.createVertex();
                    cloneVertex.setX(vertex.getX());
                    cloneVertex.setY(vertex.getY());
                    cloneVertex.setZ(vertex.getZ());
                    cloneTriangle.getVertices().add((Object)cloneVertex);
                }
                cloneTriangle.getNormal().setX(triangle.getNormal().getX());
                cloneTriangle.getNormal().setY(triangle.getNormal().getY());
                cloneTriangle.getNormal().setZ(triangle.getNormal().getZ());
            }
        }
    }

    @Override
    public Object clone() {
        Operator clone = GeometryFactory.eINSTANCE.createOperator();
        clone.copy(this);
        return clone;
    }

    public boolean equals(Object otherObject) {
        Operator otherOperator;
        if (otherObject instanceof Operator && this.name == (otherOperator = (Operator)otherObject).getName() && this.id == otherOperator.getId() && this.type == otherOperator.getType()) {
            EList<Triangle> otherTriangles = otherOperator.getTriangles();
            if (this.getTriangles().size() == otherTriangles.size()) {
                for (Triangle triangle : this.triangles) {
                    boolean found = false;
                    for (Object otherTriangle : otherTriangles) {
                        if (!triangle.equals(otherTriangle)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
                if (this.getCenter().equals(otherOperator.getCenter())) {
                    EList<String> props = this.getPropertyNames();
                    EList<String> otherProps = otherOperator.getPropertyNames();
                    if (props.size() == otherProps.size()) {
                        for (String property : props) {
                            if (otherProps.contains((Object)property) && this.getProperty(property) == otherOperator.getProperty(property)) continue;
                            return false;
                        }
                        EList<INode> ownNodes = this.getNodes();
                        EList<INode> otherNodes = otherOperator.getNodes();
                        if (ownNodes.size() == otherNodes.size()) {
                            for (INode node : ownNodes) {
                                boolean found = false;
                                for (INode otherNode : otherNodes) {
                                    if (!node.equals(otherNode)) continue;
                                    found = true;
                                    break;
                                }
                                if (found) continue;
                                return false;
                            }
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 31;
        hashCode = 31 * hashCode + this.getName().hashCode();
        hashCode *= 31;
        hashCode = (int)((long)hashCode + this.getId());
        hashCode = 31 * hashCode + this.getType().hashCode();
        hashCode = 31 * hashCode + this.getCenter().hashCode();
        hashCode = 31 * hashCode + this.properties.hashCode();
        int nodesHash = 0;
        for (INode node : this.getNodes()) {
            nodesHash += node.hashCode();
        }
        hashCode = 31 * hashCode + nodesHash;
        int trianglesHash = 0;
        for (Triangle triangle : this.getTriangles()) {
            trianglesHash += triangle.hashCode();
        }
        hashCode = 31 * hashCode + trianglesHash;
        return hashCode;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getNodes()).basicRemove((Object)otherEnd, msgs);
            }
            case 4: {
                return ((InternalEList)this.getTriangles()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getId();
            }
            case 2: {
                return this.getNodes();
            }
            case 3: {
                return this.getType();
            }
            case 4: {
                return this.getTriangles();
            }
            case 5: {
                if (resolve) {
                    return this.getCenter();
                }
                return this.basicGetCenter();
            }
            case 6: {
                if (resolve) {
                    return this.getParent();
                }
                return this.basicGetParent();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setName((String)newValue);
                return;
            }
            case 1: {
                this.setId((Long)newValue);
                return;
            }
            case 2: {
                this.getNodes().clear();
                this.getNodes().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.setType((String)newValue);
                return;
            }
            case 4: {
                this.getTriangles().clear();
                this.getTriangles().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setCenter((Vertex)newValue);
                return;
            }
            case 6: {
                this.setParent((INode)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setId(0L);
                return;
            }
            case 2: {
                this.getNodes().clear();
                return;
            }
            case 3: {
                this.setType(TYPE_EDEFAULT);
                return;
            }
            case 4: {
                this.getTriangles().clear();
                return;
            }
            case 5: {
                this.setCenter(null);
                return;
            }
            case 6: {
                this.setParent(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 1: {
                return this.id != 0L;
            }
            case 2: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
            case 3: {
                return TYPE_EDEFAULT == null ? this.type != null : !TYPE_EDEFAULT.equals(this.type);
            }
            case 4: {
                return this.triangles != null && !this.triangles.isEmpty();
            }
            case 5: {
                return this.center != null;
            }
            case 6: {
                return this.parent != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 0: {
                this.changeDecoratorProperty((String)arguments.get(0), arguments.get(1));
                return null;
            }
            case 1: {
                return this.getPropertyNames();
            }
            case 2: {
                return this.getProperty((String)arguments.get(0));
            }
            case 3: {
                this.setProperty((String)arguments.get(0), (Double)arguments.get(1));
                return null;
            }
            case 4: {
                this.addNode((INode)arguments.get(0));
                return null;
            }
            case 5: {
                this.removeNode((INode)arguments.get(0));
                return null;
            }
            case 6: {
                this.copy(arguments.get(0));
                return null;
            }
            case 7: {
                return this.clone();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(this.name);
        result.append(", id: ");
        result.append(this.id);
        result.append(", type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }

    public void eNotify(final Notification notification) {
        final Adapter[] eAdapters = this.eBasicAdapterArray();
        if (eAdapters != null && this.eDeliver()) {
            Display currDisplay = Display.getCurrent();
            if (currDisplay != null && Thread.currentThread() == currDisplay.getThread()) {
                Thread updateThread = new Thread(){

                    @Override
                    public void run() {
                        int i = 0;
                        int size = eAdapters.length;
                        while (i < size) {
                            eAdapters[i].notifyChanged(notification);
                            ++i;
                        }
                    }
                };
                updateThread.run();
            } else {
                int i = 0;
                int size = eAdapters.length;
                while (i < size) {
                    eAdapters[i].notifyChanged(notification);
                    ++i;
                }
            }
        }
    }
}

