/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.january.geometry.Face;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.TriangleStripPolyShape;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.impl.ComplexTriangle;
import org.eclipse.january.geometry.impl.PolyShapeImpl;

public class TriangleStripPolyShapeImpl
extends PolyShapeImpl
implements TriangleStripPolyShape {
    protected TriangleStripPolyShapeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.TRIANGLE_STRIP_POLY_SHAPE;
    }

    @Override
    public void calculatePolyTriangles() {
        if (this.getMaterial() != null) {
            this.getMaterial().getMaterialFiles().addAll(this.getVertexSource().getMaterialFiles());
        }
        boolean oneIndexing = true;
        for (Face face : this.getFaces()) {
            if (!face.getVertexIndices().contains((Object)0)) continue;
            oneIndexing = false;
            break;
        }
        for (Face face : this.getFaces()) {
            EList<Integer> indices = face.getVertexIndices();
            if (indices.size() <= 2) continue;
            int i = 0;
            while (i < indices.size() - 2) {
                int index1 = (Integer)indices.get(i);
                int index2 = (Integer)indices.get(i + 1);
                int index3 = (Integer)indices.get(i + 2);
                if (oneIndexing) {
                    --index1;
                    --index2;
                    --index3;
                }
                Vertex v1 = (Vertex)this.getVertexSource().getVertices().get(index1);
                Vertex v2 = (Vertex)this.getVertexSource().getVertices().get(index2);
                Vertex v3 = (Vertex)this.getVertexSource().getVertices().get(index3);
                ComplexTriangle tri = new ComplexTriangle(v1, v2, v3);
                tri.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        TriangleStripPolyShapeImpl.this.eNotify(notification);
                    }
                });
                this.getTriangles().add((Object)tri);
                ++i;
            }
        }
    }
}

