/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.Outliers;
import org.eclipse.january.dataset.Random;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class OutlierCorrectnessTest {
    Dataset dataNormal;
    Dataset dataOneToFour;
    Dataset data11;

    @Before
    public void setUp() throws Exception {
        Random.seed((int)2468);
        this.dataNormal = Random.randn((double)1.0, (double)1.0, (int[])new int[]{6});
        this.dataNormal.sort(null);
        this.dataOneToFour = DatasetFactory.createFromList(Arrays.asList(ArrayUtils.toObject((double[])new double[]{1.0, 2.0, 3.0, 4.0})));
        System.out.println("Normal data " + this.dataNormal.toString(true));
        System.out.println("data 1-4 " + this.dataOneToFour.toString(true));
    }

    @Test
    public void testSnNaive1() {
        double sn124 = Outliers.snNaive((Dataset)this.dataOneToFour);
        System.out.println(sn124);
        Assert.assertEquals((double)1.1926, (double)sn124, (double)1.0E-4);
    }

    @Test
    public void testSnNaive2() {
        double snNormal = Outliers.snNaive((Dataset)this.dataNormal);
        System.out.println(snNormal);
        Assert.assertEquals((double)0.697354, (double)snNormal, (double)1.0E-4);
    }

    @Test
    public void testSnFast1() {
        double sn124 = Outliers.snFast((Dataset)this.dataOneToFour);
        System.out.println(sn124);
        Assert.assertEquals((double)1.1926, (double)sn124, (double)1.0E-4);
    }

    @Test
    public void testSnFast2() {
        double snNormal = Outliers.snFast((Dataset)this.dataNormal);
        System.out.println(snNormal);
        Assert.assertEquals((double)0.697354, (double)snNormal, (double)1.0E-4);
    }

    @Test
    public void testArrayMedians() {
        double[] int11 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        double[] int11Mix = new double[]{4.0, 8.0, 2.0, 6.0, 3.0, 5.0, 1.0, 10.0, 7.0, 11.0, 9.0};
        double[] int12 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0};
        double[] int12Mix = new double[]{12.0, 10.0, 4.0, 8.0, 7.0, 1.0, 2.0, 9.0, 6.0, 3.0, 11.0, 5.0};
        this.fastArrayMedian(int11);
        this.fastArrayMedian(int11Mix);
        this.fastArrayMedian(int12);
        this.fastArrayMedian(int12Mix);
        DoubleDataset random = Random.rand((int[])new int[]{360});
        double[] circleOData = random.getData();
        this.fastArrayMedian(circleOData);
    }

    private void fastArrayMedian(double[] data) {
        double[] sortedCopy = Arrays.copyOf(data, data.length);
        Arrays.sort(sortedCopy);
        double expected = sortedCopy[(int)Math.floor((data.length + 1) / 2) - 1];
        int rightA = 0;
        while (rightA < data.length) {
            double[] left = Arrays.copyOfRange(data, 0, rightA + 1);
            double[] right = Arrays.copyOfRange(data, rightA + 1, data.length);
            Arrays.sort(left);
            Arrays.sort(right);
            double median = Outliers.medianOFTwoPrimitiveArrays((double[])left, (double[])right);
            Assert.assertEquals((String)"Expected median (lomed)", (double)expected, (double)median, (double)1.0E-15);
            ++rightA;
        }
    }
}

