/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;

public class ShapeUtils {
    private ShapeUtils() {
    }

    public static long calcLongSize(int[] shape) {
        if (shape == null) {
            return 0L;
        }
        int rank = shape.length;
        if (rank == 0) {
            return 1L;
        }
        double dsize = 1.0;
        int i = 0;
        while (i < rank) {
            if (shape[i] == 0) {
                return 0L;
            }
            if (shape[i] < 0) {
                throw new IllegalArgumentException(String.format("The %d-th is %d which is not allowed as it is negative", i, shape[i]));
            }
            dsize *= (double)shape[i];
            ++i;
        }
        if (dsize > 9.223372036854776E18) {
            throw new IllegalArgumentException("Size of the dataset is too large to allocate");
        }
        return (long)dsize;
    }

    public static int calcSize(int[] shape) {
        long lsize = ShapeUtils.calcLongSize(shape);
        if (lsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Size of the dataset is too large to allocate");
        }
        return (int)lsize;
    }

    public static boolean areShapesBroadcastCompatible(int[] ashape, int[] bshape) {
        if (ashape == null || bshape == null) {
            return ashape == bshape;
        }
        if (ashape.length < bshape.length) {
            return ShapeUtils.areShapesBroadcastCompatible(bshape, ashape);
        }
        int a = ashape.length - bshape.length;
        int b = 0;
        while (a < ashape.length && b < bshape.length) {
            if (ashape[a] != bshape[b] && ashape[a] != 1 && bshape[b] != 1) {
                return false;
            }
            ++a;
            ++b;
        }
        return true;
    }

    public static boolean areShapesCompatible(int[] ashape, int[] bshape) {
        if (ashape == null || bshape == null) {
            return ashape == bshape;
        }
        ArrayList<Integer> alist = new ArrayList<Integer>();
        int[] nArray = ashape;
        int n = ashape.length;
        int n2 = 0;
        while (n2 < n) {
            int a = nArray[n2];
            if (a > 1) {
                alist.add(a);
            }
            ++n2;
        }
        int imax = alist.size();
        int i = 0;
        int[] nArray2 = bshape;
        int n3 = bshape.length;
        int n4 = 0;
        while (n4 < n3) {
            int b = nArray2[n4];
            if (b != 1 && (i >= imax || b != (Integer)alist.get(i++))) {
                return false;
            }
            ++n4;
        }
        return i == imax;
    }

    public static boolean areShapesCompatible(int[] ashape, int[] bshape, int axis) {
        if (ashape == null || bshape == null) {
            return ashape == bshape;
        }
        if (ashape.length != bshape.length) {
            return false;
        }
        int rank = ashape.length;
        int i = 0;
        while (i < rank) {
            if (i != axis && ashape[i] != bshape[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static int[] squeezeShape(int[] oshape, boolean onlyFromEnds) {
        int j;
        int i;
        int unitDims = 0;
        int rank = oshape.length;
        int start = 0;
        if (onlyFromEnds) {
            i = rank - 1;
            while (i >= 0) {
                if (oshape[i] != 1) break;
                ++unitDims;
                --i;
            }
            j = 0;
            while (j <= i) {
                if (oshape[j] != 1) {
                    start = j;
                    break;
                }
                ++unitDims;
                ++j;
            }
        } else {
            i = 0;
            while (i < rank) {
                if (oshape[i] == 1) {
                    ++unitDims;
                }
                ++i;
            }
        }
        if (unitDims == 0) {
            return oshape;
        }
        int[] newDims = new int[rank - unitDims];
        if (unitDims == rank) {
            return newDims;
        }
        if (onlyFromEnds) {
            rank = newDims.length;
            int i2 = 0;
            while (i2 < rank) {
                newDims[i2] = oshape[i2 + start];
                ++i2;
            }
        } else {
            j = 0;
            int i3 = 0;
            while (i3 < rank) {
                if (oshape[i3] > 1) {
                    newDims[j++] = oshape[i3];
                    if (j >= newDims.length) break;
                }
                ++i3;
            }
        }
        return newDims;
    }

    public static int[] squeezeShape(int[] oshape, int axis) {
        if (oshape == null) {
            return null;
        }
        int rank = oshape.length;
        if (rank == 0) {
            return new int[0];
        }
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis argument is outside allowed range");
        }
        int[] nshape = new int[rank - 1];
        int i = 0;
        while (i < axis) {
            nshape[i] = oshape[i];
            ++i;
        }
        i = axis + 1;
        while (i < rank) {
            nshape[i - 1] = oshape[i];
            ++i;
        }
        return nshape;
    }

    public static int[] getShapeFromObject(Object obj) {
        if (obj == null) {
            return null;
        }
        ArrayList<Integer> lshape = new ArrayList<Integer>();
        ShapeUtils.getShapeFromObj(lshape, obj, 0);
        int rank = lshape.size();
        int[] shape = new int[rank];
        int i = 0;
        while (i < rank) {
            shape[i] = lshape.get(i);
            ++i;
        }
        return shape;
    }

    private static boolean getShapeFromObj(ArrayList<Integer> ldims, Object obj, int depth) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof List) {
            List jl = (List)obj;
            int l = jl.size();
            ShapeUtils.updateShape(ldims, depth, l);
            int i = 0;
            while (i < l) {
                Object lo = jl.get(i);
                if (!ShapeUtils.getShapeFromObj(ldims, lo, depth + 1)) break;
                ++i;
            }
            return true;
        }
        Class<?> ca = obj.getClass().getComponentType();
        if (ca != null) {
            int l = Array.getLength(obj);
            ShapeUtils.updateShape(ldims, depth, l);
            if (DTypeUtils.isClassSupportedAsElement(ca)) {
                return true;
            }
            int i = 0;
            while (i < l) {
                Object lo = Array.get(obj, i);
                if (!ShapeUtils.getShapeFromObj(ldims, lo, depth + 1)) break;
                ++i;
            }
            return true;
        }
        if (obj instanceof IDataset) {
            int[] s = ((IDataset)obj).getShape();
            int i = 0;
            while (i < s.length) {
                ShapeUtils.updateShape(ldims, depth++, s[i]);
                ++i;
            }
            return true;
        }
        return false;
    }

    private static void updateShape(ArrayList<Integer> ldims, int depth, int l) {
        if (depth >= ldims.size()) {
            ldims.add(l);
        } else if (l > ldims.get(depth)) {
            ldims.set(depth, l);
        }
    }

    public static int[] getNDPositionFromShape(int n, int[] shape) {
        if (shape == null) {
            return null;
        }
        int rank = shape.length;
        if (rank == 0) {
            return new int[0];
        }
        if (rank == 1) {
            return new int[]{n};
        }
        int[] output = new int[rank];
        --rank;
        while (rank > 0) {
            output[rank] = n % shape[rank];
            n /= shape[rank];
            --rank;
        }
        output[0] = n;
        return output;
    }

    public static int getFlat1DIndex(int[] shape, int[] pos) {
        int imax = pos.length;
        if (imax == 0) {
            return 0;
        }
        return AbstractDataset.get1DIndexFromShape(shape, pos);
    }

    public static void checkCompatibility(ILazyDataset g, ILazyDataset h) throws IllegalArgumentException {
        if (!ShapeUtils.areShapesCompatible(g.getShape(), h.getShape())) {
            throw new IllegalArgumentException("Shapes do not match");
        }
    }

    public static int checkAxis(int rank, int axis) {
        if (axis < 0) {
            axis += rank;
        }
        if (axis < 0 || axis >= rank) {
            throw new IllegalArgumentException("Axis " + axis + " given is out of range [0, " + rank + ")");
        }
        return axis;
    }

    private static int[] convert(Collection<Integer> list) {
        int[] array = new int[list.size()];
        int i = 0;
        for (Integer l : list) {
            array[i++] = l;
        }
        return array;
    }

    public static int[] checkAxes(int rank, int ... axes) {
        return ShapeUtils.convert(ShapeUtils.sanitizeAxes(rank, axes));
    }

    private static SortedSet<Integer> sanitizeAxes(int rank, int ... axes) {
        TreeSet<Integer> nAxes = new TreeSet<Integer>();
        int i = 0;
        while (i < axes.length) {
            nAxes.add(ShapeUtils.checkAxis(rank, axes[i]));
            ++i;
        }
        return nAxes;
    }

    public static int[] getRemainingAxes(int rank, int ... axes) {
        SortedSet<Integer> nAxes = ShapeUtils.sanitizeAxes(rank, axes);
        int[] remains = new int[rank - axes.length];
        int j = 0;
        int i = 0;
        while (i < rank) {
            if (!nAxes.contains(i)) {
                remains[j++] = i;
            }
            ++i;
        }
        return remains;
    }

    public static int[] reduceShape(int[] shape, int ... axes) {
        int[] remain = ShapeUtils.getRemainingAxes(shape.length, axes);
        int i = 0;
        while (i < remain.length) {
            int a = remain[i];
            remain[i] = shape[a];
            ++i;
        }
        return remain;
    }

    public static int[] getReducedShapeKeepRank(int[] shape, int ... axes) {
        int[] keep = (int[])shape.clone();
        int[] nArray = axes = ShapeUtils.checkAxes(shape.length, axes);
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            keep[i] = 1;
            ++n2;
        }
        return keep;
    }
}

