/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.DataEvent;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyWriteableDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LazyDynamicDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.io.ILazyAsyncSaver;
import org.eclipse.january.io.ILazyLoader;
import org.eclipse.january.io.ILazySaver;

public class LazyWriteableDataset
extends LazyDynamicDataset
implements ILazyWriteableDataset {
    private static final long serialVersionUID = -679846418938412535L;
    private int[] chunks;
    private ILazySaver saver;
    private Object fillValue;
    private boolean writeAsync;

    @Deprecated
    public LazyWriteableDataset(String name, int dtype, int elements, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(saver, name, elements, DTypeUtils.getInterface(dtype), shape, maxShape, chunks);
    }

    public LazyWriteableDataset(ILazySaver saver, String name, Class<? extends Dataset> clazz, int[] shape, int[] maxShape, int[] chunks) {
        this(saver, name, 1, clazz, shape, maxShape, chunks);
    }

    public LazyWriteableDataset(ILazySaver saver, String name, int elements, Class<? extends Dataset> clazz, int[] shape, int[] maxShape, int[] chunks) {
        super((ILazyLoader)saver, name, elements, clazz, shape, maxShape);
        this.chunks = chunks == null ? null : (int[])chunks.clone();
        this.saver = saver;
        this.size = ShapeUtils.calcLongSize(this.shape);
    }

    @Deprecated
    public LazyWriteableDataset(String name, int dtype, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(name, dtype, 1, shape, maxShape, chunks, saver);
    }

    public LazyWriteableDataset(String name, Class<?> eClass, int elements, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(saver, name, elements, InterfaceUtils.getInterfaceFromClass(elements, eClass), shape, maxShape, chunks);
    }

    public LazyWriteableDataset(String name, Class<?> eClass, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(saver, name, 1, InterfaceUtils.getInterfaceFromClass(1, eClass), shape, maxShape, chunks);
    }

    protected LazyWriteableDataset(LazyWriteableDataset other) {
        super(other);
        this.chunks = other.chunks;
        this.saver = other.saver;
        this.fillValue = other.fillValue;
        this.writeAsync = other.writeAsync;
    }

    public static LazyWriteableDataset createLazyDataset(Dataset dataset) {
        return LazyWriteableDataset.createLazyDataset(dataset, null);
    }

    public static LazyWriteableDataset createLazyDataset(Dataset dataset, int[] maxShape) {
        return new LazyWriteableDataset(new ILazySaver(dataset){
            private static final long serialVersionUID = 1366057382940519510L;
            Dataset d;
            {
                this.d = dataset;
            }

            @Override
            public boolean isFileReadable() {
                return true;
            }

            @Override
            public boolean isFileWriteable() {
                return true;
            }

            @Override
            public void initialize() throws IOException {
            }

            @Override
            public Dataset getDataset(IMonitor mon, SliceND slice) throws IOException {
                return this.d.getSlice(mon, slice);
            }

            @Override
            public void setSlice(IMonitor mon, IDataset data, SliceND slice) throws IOException {
                if (slice.isExpanded()) {
                    Dataset od = this.d;
                    this.d = DatasetFactory.zeros(od.getClass(), slice.getSourceShape());
                    this.d.setSlice((Object)od, SliceND.createSlice(this.d, null, od.getShapeRef()));
                }
                this.d.setSlice((Object)data, slice);
            }
        }, dataset.getName(), dataset.getElementsPerItem(), dataset.getClass(), dataset.getShapeRef(), maxShape, null);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.chunks);
        result = 31 * result + (this.fillValue == null ? 0 : this.fillValue.hashCode());
        result = 31 * result + (this.writeAsync ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        LazyWriteableDataset other = (LazyWriteableDataset)obj;
        if (!Arrays.equals(this.chunks, other.chunks)) {
            return false;
        }
        if (this.fillValue == null ? other.fillValue != null : !this.fillValue.equals(other.fillValue)) {
            return false;
        }
        if (this.saver == null ? other.saver != null : !this.saver.equals(other.saver)) {
            return false;
        }
        return this.writeAsync == other.writeAsync;
    }

    @Override
    public int[] getChunking() {
        return this.chunks;
    }

    @Override
    public void setChunking(int ... chunks) {
        this.chunks = chunks == null ? null : (int[])chunks.clone();
    }

    @Override
    public LazyWriteableDataset clone() {
        return new LazyWriteableDataset(this);
    }

    @Override
    public LazyWriteableDataset getSliceView(int[] start, int[] stop, int[] step) {
        return (LazyWriteableDataset)super.getSliceView(start, stop, step);
    }

    @Override
    public LazyWriteableDataset getSliceView(Slice ... slice) {
        return (LazyWriteableDataset)super.getSliceView(slice);
    }

    @Override
    public LazyWriteableDataset getSliceView(SliceND slice) {
        return (LazyWriteableDataset)super.getSliceView(slice);
    }

    @Override
    public LazyWriteableDataset getTransposedView(int ... axes) {
        return (LazyWriteableDataset)super.getTransposedView(axes);
    }

    @Override
    public void setWritingAsync(boolean async) {
        this.writeAsync = async;
    }

    public void setSlice(IDataset data, SliceND slice) throws DatasetException {
        this.setSlice(null, data, slice);
    }

    @Override
    public void setSlice(IMonitor monitor, IDataset data, int[] start, int[] stop, int[] step) throws DatasetException {
        this.internalSetSlice(monitor, this.writeAsync, data, new SliceND(this.shape, this.maxShape, start, stop, step));
    }

    @Override
    public void setSlice(IMonitor monitor, IDataset data, SliceND slice) throws DatasetException {
        this.checkSliceND(slice);
        this.internalSetSlice(monitor, this.writeAsync, data, slice);
    }

    @Override
    public void setSliceSync(IMonitor monitor, IDataset data, SliceND slice) throws DatasetException {
        this.checkSliceND(slice);
        this.internalSetSlice(monitor, false, data, slice);
    }

    private void internalSetSlice(IMonitor monitor, boolean async, IDataset data, SliceND slice) throws DatasetException {
        SliceND nslice;
        if (slice != null) {
            int[] dshape;
            int[] nArray = dshape = data instanceof Dataset ? ((Dataset)data).getShapeRef() : data.getShape();
            if (!Arrays.equals(slice.getShape(), dshape)) {
                data = data.getSliceView(new Slice[0]);
                data.setShape(slice.getShape());
            }
        }
        if ((nslice = this.calcTrueSlice(slice)) == null) {
            return;
        }
        data = this.transformInput(data, slice);
        if (this.saver == null) {
            throw new DatasetException("Cannot write to file as saver not defined!");
        }
        try {
            if (async && this.saver instanceof ILazyAsyncSaver) {
                ((ILazyAsyncSaver)this.saver).setSliceAsync(monitor, data, nslice);
            } else {
                if (!this.saver.isFileWriteable()) {
                    throw new DatasetException("Cannot write to file as it is not writeable!");
                }
                this.saver.setSlice(monitor, data, nslice);
            }
        }
        catch (IOException e) {
            throw new DatasetException("Could not save dataset", e);
        }
        if (!this.refreshShape()) {
            this.eventDelegate.fire(new DataEvent(this.name, this.shape));
        }
    }

    @Override
    public void setSaver(ILazySaver saver) {
        this.saver = saver;
        this.loader = saver;
    }

    @Override
    protected SliceND createSlice(int[] nstart, int[] nstop, int[] nstep) {
        return SliceND.createSlice(this.oShape, this.maxShape, nstart, nstop, nstep);
    }

    @Override
    public Object getFillValue() {
        return this.fillValue;
    }

    @Override
    public void setFillValue(Object fill) {
        this.fillValue = fill;
    }

    @Override
    public LazyWriteableDataset squeezeEnds() {
        return (LazyWriteableDataset)super.squeezeEnds();
    }
}

