/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.Maths;
import org.junit.Assert;
import org.junit.Test;

public class ComplexFloatDatasetTest {
    @Test
    public void testConstructor() {
        Assert.assertEquals((long)0L, (long)new ComplexFloatDataset().getSize());
        Assert.assertEquals((long)0L, (long)((ComplexFloatDataset)DatasetFactory.createFromObject(ComplexFloatDataset.class, (Object)Float.valueOf(1.0f))).getRank());
        float[] da = new float[]{0.0f, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f, 10.0f, 11.0f};
        ComplexFloatDataset a = new ComplexFloatDataset(da, new int[0]);
        Assert.assertTrue((String)"Interface", (boolean)ComplexFloatDataset.class.isAssignableFrom(a.getClass()));
        Assert.assertEquals((long)2L, (long)a.getElementsPerItem());
        Assert.assertEquals((long)8L, (long)a.getItemBytes());
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(i * 2), (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
        ComplexFloatDataset b = new ComplexFloatDataset(da, new int[]{3, 2});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(i2 * 2), (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        Dataset aa = Maths.abs((Object)a);
        Assert.assertTrue((String)"Interface", (boolean)FloatDataset.class.isAssignableFrom(aa.getClass()));
        Assert.assertEquals((long)1L, (long)aa.getElementsPerItem());
        Assert.assertEquals((long)4L, (long)aa.getItemBytes());
        a.hashCode();
        b.hashCode();
        aa.hashCode();
        Class<?> clazz = a.getClass();
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isElemental(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isCompound(clazz));
        Assert.assertEquals((Object)false, (Object)InterfaceUtils.isInteger(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isNumerical(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isFloating(clazz));
        Assert.assertEquals((Object)true, (Object)InterfaceUtils.isComplex(clazz));
    }
}

