/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;

public class Slice
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 3714928852236201310L;
    private Integer start;
    private Integer stop;
    private int step;
    private int length;
    private static final int COLON = 58;

    public Slice() {
        this(null, null, 1);
    }

    public Slice(Integer stop) {
        this(null, stop, 1);
    }

    public Slice(Integer start, Integer stop) {
        this(start, stop, 1);
    }

    public Slice(Integer start, Integer stop, Integer step) {
        this.start = start;
        this.stop = stop;
        this.step = step == null ? 1 : step;
        this.length = -1;
    }

    private Slice(Slice other) {
        this.start = other.start;
        this.stop = other.stop;
        this.step = other.step;
        this.length = other.length;
    }

    public Slice clone() {
        return new Slice(this);
    }

    public Slice setLength(int length) {
        if (this.stop != null && this.step > 0 && this.stop > length) {
            throw new IllegalArgumentException("Stop must be less than or equal to length");
        }
        if (this.start != null && this.start > length) {
            throw new IllegalArgumentException("Start must be less than or equal to length");
        }
        this.length = length;
        return this;
    }

    public boolean isSliceComplete() {
        if (this.start == null && this.stop == null && (this.step == 1 || this.step == -1)) {
            return true;
        }
        if (this.length > 0) {
            return this.getNumSteps() == this.length;
        }
        return true;
    }

    public int getLength() {
        return this.length;
    }

    public Integer getStart() {
        return this.start;
    }

    public Integer getStop() {
        return this.stop;
    }

    public int getStep() {
        return this.step;
    }

    public void setStart(Integer start) {
        if (start != null && this.length > 0) {
            if (this.step > 0) {
                int end;
                int n = end = this.stop == null ? this.length : this.stop;
                if (start >= end) {
                    throw new IllegalArgumentException("Non-null start must be less than end");
                }
            } else {
                int end;
                int n = end = this.stop == null ? -1 : this.stop;
                if (start < end) {
                    throw new IllegalArgumentException("Non-null start must be greater than end for negative step");
                }
            }
        }
        this.start = start;
    }

    public void setStop(Integer stop) {
        if (stop != null && this.length > 0) {
            if (this.step > 0) {
                int beg;
                int n = beg = this.start == null ? 0 : this.start;
                if (stop < beg) {
                    throw new IllegalArgumentException("Non-null stop must be greater than or equal to beginning");
                }
            } else {
                int beg;
                int n = beg = this.start == null ? this.length - 1 : this.start;
                if (stop >= beg) {
                    throw new IllegalArgumentException("Non-null stop must be less than beginning for negative step");
                }
            }
            if (stop > this.length) {
                stop = this.length;
            }
        }
        this.stop = stop;
    }

    public boolean setPosition(int beg) {
        int max;
        boolean end = false;
        int len = this.getNumSteps();
        if (len > (max = Slice.getNumSteps(beg, this.length, this.step))) {
            len = max;
            end = true;
        }
        this.start = beg;
        this.stop = this.start + (len - 1) * this.step + 1;
        return end;
    }

    public int getPosition(int n) {
        int beg;
        if (n < 0) {
            throw new IllegalArgumentException("Given n-th step should be non-negative");
        }
        if (n >= this.getNumSteps()) {
            throw new IllegalArgumentException("N-th step exceeds extent of slice");
        }
        if (this.start == null) {
            if (this.step < 0) {
                if (this.length < 0) {
                    if (this.stop == null) {
                        throw new IllegalStateException("Length or stop should be set");
                    }
                    beg = this.stop - 1;
                } else {
                    beg = this.length - 1;
                }
            } else {
                beg = 0;
            }
        } else {
            beg = this.start;
        }
        return beg + this.step * n;
    }

    public void setStep(int step) {
        if (step == 0) {
            throw new IllegalArgumentException("Step must not be zero");
        }
        this.step = step;
    }

    public static void appendSliceToString(StringBuilder s, int len, int beg, int end, int del) {
        int n;
        int o = s.length();
        if (del > 0) {
            if (beg != 0) {
                s.append(beg);
            }
        } else if (beg != len - 1) {
            s.append(beg);
        }
        if ((n = Slice.getNumSteps(beg, end, del)) == 1) {
            if (s.length() == o) {
                s.append(beg);
            }
            return;
        }
        s.append(':');
        if (del > 0) {
            if (end != len) {
                s.append(end);
            }
        } else if (end != -1) {
            s.append(end);
        }
        if (del != 1) {
            s.append(':');
            s.append(del);
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        Slice.appendSliceToString(s, this.length, this.start != null ? this.start : (this.step > 0 ? 0 : this.length - 1), this.stop != null ? this.stop : (this.step > 0 ? this.length : -1), this.step);
        return s.toString();
    }

    public int getNumSteps() {
        int beg;
        if (this.length < 0) {
            int beg2;
            if (this.stop == null) {
                throw new IllegalStateException("Slice is underspecified - stop is null and length is negative");
            }
            int n = this.start == null ? (this.step > 0 ? 0 : this.stop - 1) : (beg2 = this.start.intValue());
            if (this.step > 0 && this.stop <= beg2) {
                return 0;
            }
            if (this.step < 0 && this.stop > beg2) {
                return 0;
            }
            return Slice.getNumSteps(beg2, this.stop, this.step);
        }
        int n = this.start == null ? (this.step > 0 ? 0 : this.length - 1) : (beg = this.start.intValue());
        int end = this.stop == null ? (this.step > 0 ? this.length : -1) : this.stop;
        return Slice.getNumSteps(beg, end, this.step);
    }

    public int getNumSteps(int beg, int end) {
        return Slice.getNumSteps(beg, end, this.step);
    }

    private static int getNumSteps(int beg, int end, int step) {
        int del = step > 0 ? 1 : -1;
        return Math.max(0, (end - beg - del) / step + 1);
    }

    public int getEnd() {
        int n = this.getNumSteps() - 1;
        if (n < 0) {
            throw new IllegalStateException("End is not defined");
        }
        return this.getPosition(n);
    }

    public Slice flip() {
        if (this.length < 0) {
            Integer tmp = this.start == null ? null : Integer.valueOf(this.start - this.step);
            this.start = this.stop == null ? null : Integer.valueOf(this.getEnd());
            this.stop = tmp;
        } else {
            Integer tstart = this.start;
            this.start = this.stop == null ? null : Integer.valueOf(this.getEnd());
            this.stop = tstart == null ? null : Integer.valueOf(tstart - this.step);
        }
        this.step = -this.step;
        return this;
    }

    public static void convertFromSlice(Slice[] slice, int[] shape, int[] start, int[] stop, int[] step) {
        int rank = shape.length;
        int length = slice == null ? 0 : slice.length;
        int i = 0;
        while (i < length) {
            if (length > rank) break;
            Slice s = slice[i];
            if (s == null) {
                start[i] = 0;
                stop[i] = shape[i];
                step[i] = 1;
            } else {
                int n;
                if (s.start == null) {
                    start[i] = s.step > 0 ? 0 : shape[i] - 1;
                } else {
                    n = s.start;
                    if (n < 0) {
                        n += shape[i];
                    }
                    if (n < 0 || n >= shape[i]) {
                        throw new IllegalArgumentException(String.format("Start is out of bounds: %d is not in [%d,%d)", n, s.start, shape[i]));
                    }
                    start[i] = n;
                }
                if (s.stop == null) {
                    stop[i] = s.step > 0 ? shape[i] : -1;
                } else {
                    n = s.stop;
                    if (n < 0) {
                        n += shape[i];
                    }
                    if (n < 0 || n > shape[i]) {
                        throw new IllegalArgumentException(String.format("Stop is out of bounds: %d is not in [%d,%d)", n, s.stop, shape[i]));
                    }
                    stop[i] = n;
                }
                n = s.step;
                if (n == 0) {
                    throw new IllegalArgumentException("Step cannot be zero");
                }
                if (n > 0) {
                    if (start[i] > stop[i]) {
                        throw new IllegalArgumentException("Start must be less than stop for positive steps");
                    }
                } else if (start[i] < stop[i]) {
                    throw new IllegalArgumentException("Start must be greater than stop for negative steps");
                }
                step[i] = n;
            }
            ++i;
        }
        while (i < rank) {
            start[i] = 0;
            stop[i] = shape[i];
            step[i] = 1;
            ++i;
        }
    }

    public static Slice[] convertToSlice(int[] start, int[] stop, int[] step) {
        int orank = start.length;
        if (stop.length != orank || step.length != orank) {
            throw new IllegalArgumentException("All arrays must be same length");
        }
        Slice[] slice = new Slice[orank];
        int j = 0;
        while (j < orank) {
            slice[j] = new Slice(start[j], stop[j], step[j]);
            ++j;
        }
        return slice;
    }

    public static Slice[] convertFromString(String sliceString) {
        String clean = sliceString.replace("[", "").replace("]", "");
        String[] sub = clean.split(",");
        Slice[] slices = new Slice[sub.length];
        int i = 0;
        while (i < sub.length) {
            Slice slice;
            String s = sub[i];
            slices[i] = slice = new Slice();
            int idx0 = s.indexOf(58);
            int n = 0;
            if (idx0 == -1) {
                n = Integer.parseInt(s);
                slice.setStart(n);
                slice.setStop(n + 1);
            } else {
                String t;
                if (idx0 != 0) {
                    n = Integer.parseInt(s.substring(0, idx0));
                }
                slice.setStart(n);
                int idx1 = s.indexOf(58, ++idx0);
                if (idx1 == -1) {
                    t = s.substring(idx0).trim();
                    if (t.length() != 0) {
                        slice.setStop(Integer.parseInt(t));
                    }
                } else {
                    if (idx1 != idx0) {
                        slice.setStop(Integer.parseInt(s.substring(idx0, idx1)));
                    }
                    if ((t = s.substring(idx1 + 1).trim()).length() > 0) {
                        slice.setStep(Integer.parseInt(t));
                    }
                }
            }
            ++i;
        }
        return slices;
    }

    public static String createString(int[] shape, int[] start, int[] stop, int[] step) {
        int rank = shape.length;
        if (rank == 0) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int i = 0;
        while (i < rank) {
            int b;
            int d;
            int l = shape[i];
            int n = d = step == null ? 1 : step[i];
            int n2 = start == null ? (d > 0 ? 0 : l - 1) : (b = start[i]);
            int e = stop == null ? (d > 0 ? l : -1) : stop[i];
            Slice.appendSliceToString(s, l, b, e, d);
            s.append(',');
            ++i;
        }
        return s.substring(0, s.length() - 1);
    }

    public static String createString(Slice ... slices) {
        if (slices == null || slices.length == 0) {
            return "";
        }
        StringBuilder t = new StringBuilder();
        Slice[] sliceArray = slices;
        int n = slices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice s = sliceArray[n2];
            t.append(s != null ? s.toString() : Character.valueOf(':'));
            t.append(',');
            ++n2;
        }
        return t.substring(0, t.length() - 1);
    }
}

