/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastUtils;
import org.eclipse.january.dataset.Dataset;

public class BooleanContiguousIterator
extends BooleanIterator {
    private final int cMax;
    private final int cStep;

    public BooleanContiguousIterator(boolean v, Dataset a, Dataset c, Dataset o, boolean createIfNull) {
        super(v, a, c, o);
        this.aMax = a.getSize() * this.aStep;
        this.cStep = c.getElementsPerItem();
        this.cMax = c.getSize() * this.cStep;
        if (this.outputA) {
            this.oStep = this.aStep;
        } else if (o != null) {
            this.oStep = o.getElementsPerItem();
        } else if (createIfNull) {
            this.oDataset = BroadcastUtils.createDataset(a, c, a.getShapeRef());
            this.oStep = this.oDataset.getElementsPerItem();
        } else {
            this.oStep = 1;
        }
        this.maxShape = a.getShape();
        this.reset();
    }

    @Override
    public boolean hasNext() {
        do {
            this.index += this.aStep;
            this.cIndex += this.cStep;
            this.oIndex = this.outputA ? this.index : (this.oIndex += this.oStep);
            if (this.index < this.aMax && this.cIndex < this.cMax) continue;
            return false;
        } while (this.cDataset.getElementBooleanAbs(this.cIndex) != this.value);
        return true;
    }

    @Override
    public int[] getPos() {
        return null;
    }

    @Override
    public void reset() {
        this.index = -this.aStep;
        this.cIndex = -this.cStep;
        this.oIndex = -this.oStep;
    }
}

