/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.dataset.AbstractDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.BroadcastIterator;
import org.eclipse.january.dataset.BroadcastSelfIterator;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerIterator;
import org.eclipse.january.dataset.IntegersIterator;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.metadata.StatisticsMetadata;

public class ByteDataset
extends AbstractDataset {
    private static final long serialVersionUID = -6891075135217265625L;
    protected byte[] data;

    @Override
    protected void setData() {
        this.data = (byte[])this.odata;
    }

    protected static byte[] createArray(int size) {
        byte[] array = null;
        try {
            array = new byte[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            logger.error("The size of the dataset ({}) that is being created is too large and there is not enough memory to hold it.", (Object)size);
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return array;
    }

    @Override
    public int getDType() {
        return 1;
    }

    ByteDataset() {
    }

    ByteDataset(int ... shape) {
        if (shape != null) {
            this.size = ShapeUtils.calcSize(shape);
            this.shape = (int[])shape.clone();
            try {
                this.data = ByteDataset.createArray(this.size);
                this.odata = this.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
        }
    }

    ByteDataset(byte[] data, int ... shape) {
        if (data == null) {
            throw new IllegalArgumentException("Data must not be null");
        }
        if (shape == null || shape.length == 0) {
            shape = new int[]{data.length};
        }
        this.size = ShapeUtils.calcSize(shape);
        if (this.size != data.length) {
            throw new IllegalArgumentException(String.format("Shape %s is not compatible with size of data array, %d", Arrays.toString(shape), data.length));
        }
        this.shape = this.size == 0 ? null : (int[])shape.clone();
        this.data = data;
        this.odata = data;
    }

    ByteDataset(ByteDataset dataset) {
        ByteDataset.copyToView(dataset, this, true, true);
        try {
            if (dataset.stride == null) {
                this.data = (byte[])dataset.data.clone();
                this.odata = this.data;
            } else {
                this.offset = 0;
                this.stride = null;
                this.base = null;
                this.data = ByteDataset.createArray(this.size);
                this.odata = this.data;
                IndexIterator iter = dataset.getIterator();
                int i = 0;
                while (iter.hasNext()) {
                    this.data[i] = dataset.data[iter.index];
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
    }

    ByteDataset(Dataset dataset) {
        ByteDataset.copyToView(dataset, this, true, false);
        this.offset = 0;
        this.stride = null;
        this.base = null;
        try {
            this.data = ByteDataset.createArray(this.size);
            this.odata = this.data;
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        IndexIterator iter = dataset.getIterator();
        int i = 0;
        while (iter.hasNext()) {
            this.data[i] = (byte)dataset.getElementLongAbs(iter.index);
            ++i;
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getRank() == 0 && !this.getClass().equals(obj.getClass())) {
            return true;
        }
        ByteDataset other = (ByteDataset)obj;
        IndexIterator iter = this.getIterator();
        IndexIterator oiter = other.getIterator();
        while (iter.hasNext() && oiter.hasNext()) {
            if (this.data[iter.index] == other.data[oiter.index]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ByteDataset clone() {
        return new ByteDataset(this);
    }

    static ByteDataset createFromObject(Object obj) {
        ByteDataset result = new ByteDataset();
        if (obj != null) {
            result.shape = ShapeUtils.getShapeFromObject(obj);
            result.size = ShapeUtils.calcSize(result.shape);
            try {
                result.data = ByteDataset.createArray(result.size);
                result.odata = result.data;
            }
            catch (Throwable t) {
                logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(result.shape), (Object)t);
                throw new IllegalArgumentException(t);
            }
            int[] pos = new int[result.shape.length];
            result.fillData(obj, 0, pos);
        }
        return result;
    }

    static ByteDataset createRange(double stop) {
        return ByteDataset.createRange(0.0, stop, 1.0);
    }

    static ByteDataset createRange(double start, double stop, double step) {
        int size = ByteDataset.calcSteps(start, stop, step);
        ByteDataset result = new ByteDataset(size);
        int i = 0;
        while (i < size) {
            result.data[i] = (byte)(start + (double)i * step);
            ++i;
        }
        return result;
    }

    static ByteDataset ones(int ... shape) {
        return new ByteDataset(shape).fill(1);
    }

    @Override
    public ByteDataset fill(Object obj) {
        this.setDirty();
        byte dv = (byte)DTypeUtils.toLong(obj);
        IndexIterator iter = this.getIterator();
        while (iter.hasNext()) {
            this.data[iter.index] = dv;
        }
        return this;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    protected int getBufferLength() {
        if (this.data == null) {
            return 0;
        }
        return this.data.length;
    }

    @Override
    public ByteDataset getView(boolean deepCopyMetadata) {
        ByteDataset view = new ByteDataset();
        ByteDataset.copyToView(this, view, true, deepCopyMetadata);
        view.setData();
        return view;
    }

    public byte getAbs(int index) {
        return this.data[index];
    }

    @Override
    public boolean getElementBooleanAbs(int index) {
        return this.data[index] != 0;
    }

    @Override
    public double getElementDoubleAbs(int index) {
        return this.data[index];
    }

    @Override
    public long getElementLongAbs(int index) {
        return this.data[index];
    }

    @Override
    public Object getObjectAbs(int index) {
        return this.data[index];
    }

    @Override
    public String getStringAbs(int index) {
        return this.stringFormat == null ? String.format("%d", this.data[index]) : this.stringFormat.format(this.data[index]);
    }

    public void setAbs(int index, byte val) {
        this.setDirty();
        this.data[index] = val;
    }

    @Override
    protected void setItemDirect(int dindex, int sindex, Object src) {
        this.setDirty();
        byte[] dsrc = (byte[])src;
        this.data[dindex] = dsrc[sindex];
    }

    @Override
    public void setObjectAbs(int index, Object obj) {
        if (index < 0 || index > this.data.length) {
            throw new IndexOutOfBoundsException("Index given is outside dataset");
        }
        this.setAbs(index, (byte)DTypeUtils.toLong(obj));
    }

    public byte get() {
        return this.data[this.getFirst1DIndex()];
    }

    public byte get(int i) {
        return this.data[this.get1DIndex(i)];
    }

    public byte get(int i, int j) {
        return this.data[this.get1DIndex(i, j)];
    }

    public byte get(int ... pos) {
        return this.data[this.get1DIndex(pos)];
    }

    @Override
    public Object getObject() {
        return this.get();
    }

    @Override
    public Object getObject(int i) {
        return this.get(i);
    }

    @Override
    public Object getObject(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public Object getObject(int ... pos) {
        return this.get(pos);
    }

    @Override
    public String getString() {
        return this.getStringAbs(this.getFirst1DIndex());
    }

    @Override
    public String getString(int i) {
        return this.getStringAbs(this.get1DIndex(i));
    }

    @Override
    public String getString(int i, int j) {
        return this.getStringAbs(this.get1DIndex(i, j));
    }

    @Override
    public String getString(int ... pos) {
        return this.getStringAbs(this.get1DIndex(pos));
    }

    @Override
    public double getDouble() {
        return this.get();
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    @Override
    public double getDouble(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public double getDouble(int ... pos) {
        return this.get(pos);
    }

    @Override
    public float getFloat() {
        return this.get();
    }

    @Override
    public float getFloat(int i) {
        return this.get(i);
    }

    @Override
    public float getFloat(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public float getFloat(int ... pos) {
        return this.get(pos);
    }

    @Override
    public long getLong() {
        return this.get();
    }

    @Override
    public long getLong(int i) {
        return this.get(i);
    }

    @Override
    public long getLong(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public long getLong(int ... pos) {
        return this.get(pos);
    }

    @Override
    public int getInt() {
        return this.get();
    }

    @Override
    public int getInt(int i) {
        return this.get(i);
    }

    @Override
    public int getInt(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public int getInt(int ... pos) {
        return this.get(pos);
    }

    @Override
    public short getShort() {
        return this.get();
    }

    @Override
    public short getShort(int i) {
        return this.get(i);
    }

    @Override
    public short getShort(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public short getShort(int ... pos) {
        return this.get(pos);
    }

    @Override
    public byte getByte() {
        return this.get();
    }

    @Override
    public byte getByte(int i) {
        return this.get(i);
    }

    @Override
    public byte getByte(int i, int j) {
        return this.get(i, j);
    }

    @Override
    public byte getByte(int ... pos) {
        return this.get(pos);
    }

    @Override
    public boolean getBoolean() {
        return this.get() != 0;
    }

    @Override
    public boolean getBoolean(int i) {
        return this.get(i) != 0;
    }

    @Override
    public boolean getBoolean(int i, int j) {
        return this.get(i, j) != 0;
    }

    @Override
    public boolean getBoolean(int ... pos) {
        return this.get(pos) != 0;
    }

    public void setItem(byte value) {
        this.setAbs(this.getFirst1DIndex(), value);
    }

    public void setItem(byte value, int i) {
        this.setAbs(this.get1DIndex(i), value);
    }

    public void setItem(byte value, int i, int j) {
        this.setAbs(this.get1DIndex(i, j), value);
    }

    public void setItem(byte value, int ... pos) {
        this.setAbs(this.get1DIndex(pos), value);
    }

    @Override
    public void set(Object obj) {
        this.setItem((byte)DTypeUtils.toLong(obj));
    }

    @Override
    public void set(Object obj, int i) {
        this.setItem((byte)DTypeUtils.toLong(obj), i);
    }

    @Override
    public void set(Object obj, int i, int j) {
        this.setItem((byte)DTypeUtils.toLong(obj), i, j);
    }

    @Override
    public void set(Object obj, int ... pos) {
        if (pos == null || pos.length == 0 && this.shape.length > 0) {
            pos = new int[this.shape.length];
        }
        this.setItem((byte)DTypeUtils.toLong(obj), pos);
    }

    @Override
    public void resize(int ... newShape) {
        byte[] ndata;
        this.setDirty();
        IndexIterator iter = this.getIterator();
        int nsize = ShapeUtils.calcSize(newShape);
        try {
            ndata = ByteDataset.createArray(nsize);
        }
        catch (Throwable t) {
            logger.error("Could not create a dataset of shape {}", (Object)Arrays.toString(this.shape), (Object)t);
            throw new IllegalArgumentException(t);
        }
        int i = 0;
        while (iter.hasNext() && i < nsize) {
            ndata[i] = this.data[iter.index];
            ++i;
        }
        this.data = ndata;
        this.odata = ndata;
        this.size = nsize;
        this.shape = newShape;
        this.stride = null;
        this.offset = 0;
        this.base = null;
    }

    @Override
    public ByteDataset sort(Integer axis) {
        this.setDirty();
        if (axis == null) {
            if (this.stride == null) {
                Arrays.sort(this.data);
            } else {
                ByteDataset ads = this.clone().sort(null);
                this.setSlicedView(this.getView(false), ads);
            }
        } else {
            axis = this.checkAxis(axis);
            ByteDataset ads = new ByteDataset(this.shape[axis]);
            PositionIterator pi = this.getPositionIterator(axis);
            int[] pos = pi.getPos();
            boolean[] hit = pi.getOmit();
            while (pi.hasNext()) {
                this.copyItemsFromAxes(pos, hit, ads);
                Arrays.sort(ads.data);
                this.setItemsOnAxes(pos, hit, ads.data);
            }
        }
        return this;
    }

    @Override
    public ByteDataset getUniqueItems() {
        TreeSet<Byte> set = new TreeSet<Byte>();
        IndexIterator it = this.getIterator();
        while (it.hasNext()) {
            set.add(this.data[it.index]);
        }
        ByteDataset u = new ByteDataset(set.size());
        int i = 0;
        byte[] udata = u.getData();
        for (Byte v : set) {
            udata[i++] = v;
        }
        return u;
    }

    @Override
    public ByteDataset getSlice(SliceIterator siter) {
        ByteDataset result = new ByteDataset(siter.getShape());
        byte[] rdata = result.data;
        int i = 0;
        while (siter.hasNext()) {
            rdata[i] = this.data[siter.index];
            ++i;
        }
        result.setName(String.valueOf(this.name) + '[' + Slice.createString(siter.shape, siter.start, siter.stop, siter.step) + ']');
        return result;
    }

    @Override
    public void fillDataset(Dataset result, IndexIterator iter) {
        this.setDirty();
        IndexIterator riter = result.getIterator();
        byte[] rdata = ((ByteDataset)result).data;
        while (riter.hasNext() && iter.hasNext()) {
            rdata[riter.index] = this.data[iter.index];
        }
    }

    @Override
    public ByteDataset setByBoolean(Object obj, Dataset selection) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            int length = ((Number)selection.sum(new boolean[0])).intValue();
            if (length != ds.getSize()) {
                throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext() && oiter.hasNext()) {
                this.data[biter.index] = (byte)ds.getElementLongAbs(oiter.index);
            }
        } else {
            byte dv = (byte)DTypeUtils.toLong(obj);
            BooleanIterator biter = this.getBooleanIterator(selection);
            while (biter.hasNext()) {
                this.data[biter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public ByteDataset setBy1DIndex(Object obj, Dataset index) {
        this.setDirty();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (index.getSize() != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index dataset does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext() && oiter.hasNext()) {
                this.data[iter.index] = (byte)ds.getElementLongAbs(oiter.index);
            }
        } else {
            byte dv = (byte)DTypeUtils.toLong(obj);
            IntegerIterator iter = new IntegerIterator(index, this.size);
            while (iter.hasNext()) {
                this.data[iter.index] = dv;
            }
        }
        return this;
    }

    @Override
    public ByteDataset setByIndexes(Object obj, Object ... indexes) {
        this.setDirty();
        IntegersIterator iter = new IntegersIterator(this.shape, indexes);
        int[] pos = iter.getPos();
        if (obj instanceof Dataset) {
            Dataset ds = (Dataset)obj;
            if (ShapeUtils.calcSize(iter.getShape()) != ds.getSize()) {
                throw new IllegalArgumentException("Number of items in index datasets does not match number of items in dataset");
            }
            IndexIterator oiter = ds.getIterator();
            while (iter.hasNext() && oiter.hasNext()) {
                this.setItem((byte)ds.getElementLongAbs(oiter.index), pos);
            }
        } else {
            byte dv = (byte)DTypeUtils.toLong(obj);
            while (iter.hasNext()) {
                this.setItem(dv, pos);
            }
        }
        return this;
    }

    @Override
    ByteDataset setSlicedView(Dataset view, Dataset d) {
        this.setDirty();
        BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(view, d);
        while (it.hasNext()) {
            this.data[it.aIndex] = (byte)it.bLong;
        }
        return this;
    }

    @Override
    public ByteDataset setSlice(Object obj, IndexIterator siter) {
        this.setDirty();
        if (obj instanceof IDataset) {
            IDataset ds = (IDataset)obj;
            int[] oshape = ds.getShape();
            if (!ShapeUtils.areShapesCompatible(siter.getShape(), oshape)) {
                throw new IllegalArgumentException(String.format("Input dataset is not compatible with slice: %s cf %s", Arrays.toString(oshape), Arrays.toString(siter.getShape())));
            }
            if (ds instanceof Dataset) {
                Dataset ads = (Dataset)ds;
                IndexIterator oiter = ads.getIterator();
                while (siter.hasNext() && oiter.hasNext()) {
                    this.data[siter.index] = (byte)ads.getElementLongAbs(oiter.index);
                }
            } else {
                PositionIterator oiter = new PositionIterator(oshape);
                int[] pos = ((IndexIterator)oiter).getPos();
                while (siter.hasNext() && ((IndexIterator)oiter).hasNext()) {
                    this.data[siter.index] = ds.getByte(pos);
                }
            }
        } else {
            try {
                byte v = (byte)DTypeUtils.toLong(obj);
                while (siter.hasNext()) {
                    this.data[siter.index] = v;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        return this;
    }

    @Override
    public void copyItemsFromAxes(int[] pos, boolean[] axes, Dataset dest) {
        byte[] ddata = (byte[])dest.getBuffer();
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        int[] sshape = ShapeUtils.squeezeShape(siter.getShape(), false);
        IndexIterator diter = dest.getSliceIterator(null, sshape, null);
        if (ddata.length < ShapeUtils.calcSize(sshape)) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        dest.setDirty();
        while (siter.hasNext() && diter.hasNext()) {
            ddata[diter.index] = this.data[siter.index];
        }
    }

    @Override
    public void setItemsOnAxes(int[] pos, boolean[] axes, Object src) {
        this.setDirty();
        byte[] sdata = (byte[])src;
        SliceIterator siter = this.getSliceIteratorFromAxes(pos, axes);
        if (sdata.length < ShapeUtils.calcSize(siter.getShape())) {
            throw new IllegalArgumentException("destination array is not large enough");
        }
        int i = 0;
        while (siter.hasNext()) {
            this.data[siter.index] = sdata[i];
            ++i;
        }
    }

    private List<int[]> findPositions(byte value) {
        IndexIterator iter = this.getIterator(true);
        ArrayList<int[]> posns = new ArrayList<int[]>();
        int[] pos = iter.getPos();
        while (iter.hasNext()) {
            if (this.data[iter.index] != value) continue;
            posns.add((int[])pos.clone());
        }
        return posns;
    }

    @Override
    public int[] maxPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> md = this.getStats();
        List<int[]> max = md.getMaximumPositions(ignoreInvalids);
        if (max == null) {
            max = this.findPositions(md.getMaximum(ignoreInvalids).byteValue());
            md.setMaximumPositions(max, new boolean[0]);
        }
        return max.get(0);
    }

    @Override
    public int[] minPos(boolean ... ignoreInvalids) {
        StatisticsMetadata<Number> md = this.getStats();
        List<int[]> min = md.getMinimumPositions(ignoreInvalids);
        if (min == null) {
            min = this.findPositions(md.getMinimum(ignoreInvalids).byteValue());
            md.setMinimumPositions(min, new boolean[0]);
        }
        return min.get(0);
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    @Override
    public boolean containsInvalidNumbers() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteDataset iadd(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = (byte)((long)this.data[v0] + lb);
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (byte)((double)this.data[v1] + db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl30
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = (byte)((long)this.data[v2] + it.bLong);
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (byte)((double)this.data[v3] + it.bDouble);
lbl30:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public ByteDataset isubtract(Object b) {
        this.setDirty();
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        boolean useLong = bds.getElementClass().equals(Long.class);
        if (bds.getSize() == 1) {
            IndexIterator it = this.getIterator();
            if (useLong) {
                long lb = bds.getElementLongAbs(0);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = (byte)((long)this.data[n] - lb);
                }
            } else {
                double db = bds.getElementDoubleAbs(0);
                while (it.hasNext()) {
                    int n = it.index;
                    this.data[n] = (byte)((double)this.data[n] - db);
                }
            }
        } else {
            BroadcastSelfIterator it = BroadcastSelfIterator.createIterator(this, bds);
            if (useLong) {
                it.setOutputDouble(false);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = (byte)((long)this.data[n] - it.bLong);
                }
            } else {
                it.setOutputDouble(true);
                while (it.hasNext()) {
                    int n = it.aIndex;
                    this.data[n] = (byte)((double)this.data[n] - it.bDouble);
                }
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteDataset imultiply(Object b) {
        block7: {
            block6: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block6;
                it = this.getIterator();
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    while (it.hasNext()) {
                        v0 = it.index;
                        this.data[v0] = (byte)((long)this.data[v0] * lb);
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    while (it.hasNext()) {
                        v1 = it.index;
                        this.data[v1] = (byte)((double)this.data[v1] * db);
                    }
                }
                break block7;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl30
            while (it.hasNext()) {
                v2 = it.aIndex;
                this.data[v2] = (byte)((long)this.data[v2] * it.bLong);
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                v3 = it.aIndex;
                this.data[v3] = (byte)((double)this.data[v3] * it.bDouble);
lbl30:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteDataset idivide(Object b) {
        block13: {
            block12: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block12;
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = (byte)((long)this.data[v0] / lb);
                        }
                    }
                } else {
                    db = bds.getElementDoubleAbs(0);
                    if (db == 0.0) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v1 = it.index;
                            this.data[v1] = (byte)((double)this.data[v1] / db);
                        }
                    }
                }
                break block13;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl45
            while (it.hasNext()) {
                if (it.bLong == 0L) {
                    this.data[it.aIndex] = 0;
                    continue;
                }
                v2 = it.aIndex;
                this.data[v2] = (byte)((long)this.data[v2] / it.bLong);
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                if (it.bDouble == 0.0) {
                    this.data[it.aIndex] = 0;
                    continue;
                }
                v3 = it.aIndex;
                this.data[v3] = (byte)((double)this.data[v3] / it.bDouble);
lbl45:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public ByteDataset ifloor() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteDataset iremainder(Object b) {
        block15: {
            block14: {
                this.setDirty();
                bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                useLong = bds.getElementClass().equals(Long.class);
                if (bds.getSize() != 1) break block14;
                if (useLong) {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v0 = it.index;
                            this.data[v0] = (byte)((long)this.data[v0] % lb);
                        }
                    }
                } else {
                    lb = bds.getElementLongAbs(0);
                    if (lb == 0L) {
                        this.fill(0);
                    } else {
                        it = this.getIterator();
                        while (it.hasNext()) {
                            v1 = it.index;
                            this.data[v1] = (byte)((long)this.data[v1] % lb);
                        }
                    }
                }
                break block15;
            }
            it = BroadcastSelfIterator.createIterator(this, bds);
            it.setOutputDouble(useLong == false);
            if (!useLong) ** GOTO lbl47
            while (it.hasNext()) {
                try {
                    v2 = it.aIndex;
                    this.data[v2] = (byte)((long)this.data[v2] % it.bLong);
                }
                catch (ArithmeticException v3) {
                    this.data[it.aIndex] = 0;
                }
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                try {
                    v4 = it.aIndex;
                    this.data[v4] = (byte)((double)this.data[v4] % it.bDouble);
                    continue;
                }
                catch (ArithmeticException v5) {
                    this.data[it.aIndex] = 0;
                }
lbl47:
                // 3 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ByteDataset ipower(Object b) {
        block8: {
            block7: {
                this.setDirty();
                v0 = bds = b instanceof Dataset != false ? (Dataset)b : DatasetFactory.createFromObject(b);
                if (bds.getSize() != 1) break block7;
                vr = bds.getElementDoubleAbs(0);
                it = this.getIterator();
                if (!bds.isComplex()) ** GOTO lbl23
                vi = bds.getElementDoubleAbs(1);
                if (vi == 0.0) {
                    while (it.hasNext()) {
                        v = Math.pow(this.data[it.index], vr);
                        this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (byte)v;
                    }
                } else {
                    zv = new Complex(vr, vi);
                    while (it.hasNext()) {
                        zd = new Complex((double)this.data[it.index], 0.0);
                        v = zd.pow(zv).getReal();
                        this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (byte)v;
                    }
                }
                break block8;
lbl-1000:
                // 1 sources

                {
                    v = Math.pow(this.data[it.index], vr);
                    this.data[it.index] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (byte)v;
lbl23:
                    // 2 sources

                    ** while (it.hasNext())
                }
lbl24:
                // 1 sources

                break block8;
            }
            it = BroadcastIterator.createIterator(this, bds);
            it.setOutputDouble(true);
            if (!bds.isComplex()) ** GOTO lbl37
            while (it.hasNext()) {
                zv = new Complex(it.bDouble, bds.getElementDoubleAbs(it.bIndex + 1));
                v = new Complex(it.aDouble, 0.0).pow(zv).getReal();
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (byte)v;
            }
            break block8;
lbl-1000:
            // 1 sources

            {
                v = Math.pow(it.aDouble, it.bDouble);
                this.data[it.aIndex] = Double.isInfinite(v) != false || Double.isNaN(v) != false ? 0 : (byte)v;
lbl37:
                // 2 sources

                ** while (it.hasNext())
            }
        }
        return this;
    }

    @Override
    public double residual(Object b, Dataset w, boolean ignoreNaNs) {
        Dataset bds = b instanceof Dataset ? (Dataset)b : DatasetFactory.createFromObject(b);
        BroadcastIterator it = BroadcastIterator.createIterator(this, bds);
        it.setOutputDouble(true);
        double sum = 0.0;
        double comp = 0.0;
        if (w == null) {
            while (it.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        } else {
            IndexIterator itw = w.getIterator();
            while (it.hasNext() && itw.hasNext()) {
                double diff = it.aDouble - it.bDouble;
                double err = diff * diff * w.getElementDoubleAbs(itw.index) - comp;
                double temp = sum + err;
                comp = temp - sum - err;
                sum = temp;
            }
        }
        return sum;
    }
}

