/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.Serializable;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.PositionIterator;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceIterator;
import org.eclipse.january.dataset.SliceND;

public interface Dataset
extends IDataset {
    public static final int BOOL = 0;
    public static final int INT8 = 1;
    public static final int INT16 = 2;
    public static final int INT32 = 3;
    public static final int INT = 3;
    public static final int INT64 = 4;
    public static final int FLOAT32 = 5;
    public static final int FLOAT64 = 6;
    public static final int FLOAT = 6;
    public static final int COMPLEX64 = 7;
    public static final int COMPLEX128 = 8;
    public static final int COMPLEX = 8;
    public static final int STRING = 9;
    public static final int OBJECT = 10;
    public static final int DATE = 11;
    public static final int ARRAYMUL = 100;
    public static final int ARRAYINT8 = 100;
    public static final int ARRAYINT16 = 200;
    public static final int RGB = 203;
    public static final int ARRAYINT32 = 300;
    public static final int ARRAYINT64 = 400;
    public static final int ARRAYFLOAT32 = 500;
    public static final int ARRAYFLOAT64 = 600;
    public static final long serialVersionUID = -6891075135217265625L;

    public int[] getShapeRef();

    public int getDType();

    public int[] getStrides();

    public int getOffset();

    public boolean hasFloatingPointElements();

    public int getNbytes();

    public Serializable getBuffer();

    public void overrideInternal(Serializable var1, int ... var2);

    public Dataset synchronizedCopy();

    public Dataset getView(boolean var1);

    public Dataset getBroadcastView(int ... var1);

    public String toString(boolean var1);

    @Override
    public Dataset squeezeEnds();

    @Override
    public Dataset squeeze();

    @Override
    public Dataset squeeze(boolean var1);

    @Override
    public Dataset clone();

    public void setDirty();

    public int[] getNDPosition(int var1);

    public int get1DIndex(int ... var1);

    public int checkAxis(int var1);

    public boolean isCompatibleWith(ILazyDataset var1);

    public void checkCompatibility(ILazyDataset var1) throws IllegalArgumentException;

    public Dataset reshape(int ... var1);

    public boolean isComplex();

    public Dataset getRealPart();

    public Dataset getRealView();

    @Override
    public Dataset getErrors();

    public Dataset getErrorBuffer();

    public void setErrorBuffer(Serializable var1);

    public Dataset copy(int var1);

    public <T extends Dataset> T copy(Class<T> var1);

    public Dataset cast(int var1);

    public <T extends Dataset> T cast(Class<T> var1);

    public Dataset cast(boolean var1, int var2, int var3);

    public IntegerDataset getIndices();

    @Override
    public Dataset getTransposedView(int ... var1);

    public Dataset transpose(int ... var1);

    public Dataset swapAxes(int var1, int var2);

    public Dataset flatten();

    public Dataset getUniqueItems();

    public IndexIterator getIterator(boolean var1);

    public IndexIterator getIterator();

    public PositionIterator getPositionIterator(int ... var1);

    public IndexIterator getSliceIterator(int[] var1, int[] var2, int[] var3);

    public SliceIterator getSliceIteratorFromAxes(int[] var1, boolean[] var2);

    public void copyItemsFromAxes(int[] var1, boolean[] var2, Dataset var3);

    public void setItemsOnAxes(int[] var1, boolean[] var2, Object var3);

    public BooleanIterator getBooleanIterator(Dataset var1);

    public BooleanIterator getBooleanIterator(Dataset var1, boolean var2);

    public Dataset getByBoolean(Dataset var1);

    public Dataset setByBoolean(Object var1, Dataset var2);

    public Dataset getBy1DIndex(IntegerDataset var1);

    public Dataset getByIndexes(Object ... var1);

    public Dataset setBy1DIndex(Object var1, Dataset var2);

    public Dataset setByIndexes(Object var1, Object ... var2);

    public Dataset fill(Object var1);

    public boolean getElementBooleanAbs(int var1);

    public double getElementDoubleAbs(int var1);

    public long getElementLongAbs(int var1);

    public Object getObjectAbs(int var1);

    public String getStringAbs(int var1);

    public void setObjectAbs(int var1, Object var2);

    public Object getObject();

    public Object getObject(int var1);

    public Object getObject(int var1, int var2);

    public String getString();

    public String getString(int var1);

    public String getString(int var1, int var2);

    public double getDouble();

    public double getDouble(int var1);

    public double getDouble(int var1, int var2);

    public float getFloat();

    public float getFloat(int var1);

    public float getFloat(int var1, int var2);

    public long getLong();

    public long getLong(int var1);

    public long getLong(int var1, int var2);

    public int getInt();

    public int getInt(int var1);

    public int getInt(int var1, int var2);

    public short getShort();

    public short getShort(int var1);

    public short getShort(int var1, int var2);

    public byte getByte();

    public byte getByte(int var1);

    public byte getByte(int var1, int var2);

    public boolean getBoolean();

    public boolean getBoolean(int var1);

    public boolean getBoolean(int var1, int var2);

    public double getError();

    public double getError(int var1);

    public double getError(int var1, int var2);

    public double[] getErrorArray(int var1);

    public double[] getErrorArray(int var1, int var2);

    public void set(Object var1);

    public void set(Object var1, int var2);

    public void set(Object var1, int var2, int var3);

    public Dataset sort(Integer var1);

    @Override
    public Dataset getSlice(int[] var1, int[] var2, int[] var3);

    @Override
    public Dataset getSlice(IMonitor var1, int[] var2, int[] var3, int[] var4);

    @Override
    public Dataset getSlice(Slice ... var1);

    @Override
    public Dataset getSlice(IMonitor var1, Slice ... var2);

    @Override
    public Dataset getSlice(SliceND var1);

    @Override
    public Dataset getSlice(IMonitor var1, SliceND var2);

    @Override
    public Dataset getSliceView(int[] var1, int[] var2, int[] var3);

    @Override
    public Dataset getSliceView(Slice ... var1);

    @Override
    public Dataset getSliceView(SliceND var1);

    public Dataset setSlice(Object var1, int[] var2, int[] var3, int[] var4);

    public Dataset setSlice(Object var1, Slice ... var2);

    public Dataset setSlice(Object var1, SliceND var2);

    public Dataset setSlice(Object var1, IndexIterator var2);

    public void fillDataset(Dataset var1, IndexIterator var2);

    public boolean all();

    public Dataset all(int var1);

    public boolean any();

    public Dataset any(int var1);

    public Dataset iadd(Object var1);

    public Dataset isubtract(Object var1);

    public Dataset imultiply(Object var1);

    public Dataset idivide(Object var1);

    public Dataset ifloorDivide(Object var1);

    public Dataset iremainder(Object var1);

    public Dataset ifloor();

    public Dataset ipower(Object var1);

    public double residual(Object var1);

    public double residual(Object var1, boolean var2);

    public double residual(Object var1, Dataset var2, boolean var3);

    public boolean containsInfs();

    public boolean containsNans();

    public boolean containsInvalidNumbers();

    public Dataset max(int var1, boolean ... var2);

    public Dataset min(int var1, boolean ... var2);

    public int argMax(boolean ... var1);

    public Dataset argMax(int var1, boolean ... var2);

    public int argMin(boolean ... var1);

    public Dataset argMin(int var1, boolean ... var2);

    public Number peakToPeak(boolean ... var1);

    public Dataset peakToPeak(int var1, boolean ... var2);

    public long count(boolean ... var1);

    public Dataset count(int var1, boolean ... var2);

    public Object sum(boolean ... var1);

    public Dataset sum(int var1, boolean ... var2);

    public Object product(boolean ... var1);

    public Dataset product(int var1, boolean ... var2);

    public Dataset mean(int var1, boolean ... var2);

    public double variance();

    public double variance(boolean var1, boolean ... var2);

    public Dataset variance(int var1);

    public Dataset variance(int var1, boolean var2, boolean ... var3);

    public double stdDeviation();

    public double stdDeviation(boolean var1, boolean ... var2);

    public Dataset stdDeviation(int var1);

    public Dataset stdDeviation(int var1, boolean var2, boolean ... var3);

    public double rootMeanSquare(boolean ... var1);

    public Dataset rootMeanSquare(int var1, boolean ... var2);
}

