/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.BooleanIterator;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BooleanIteratorTest {
    Dataset a;
    Dataset b;
    int size = 1024;

    @Before
    public void setUpClass() {
        this.a = DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0});
        this.b = DatasetFactory.createFromObject((Object)new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0});
    }

    @Test
    public void testEqualTo() {
        Dataset c = this.a.clone().reshape(new int[]{2, 3});
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset s = (BooleanDataset)DatasetFactory.createFromObject(BooleanDataset.class, (Object)blArray);
        s.setShape(new int[]{2, 3});
        ArrayList<Integer> inds = new ArrayList<Integer>();
        BooleanIterator iter = c.getBooleanIterator((Dataset)s);
        while (iter.hasNext()) {
            inds.add((int)c.getElementLongAbs(iter.index));
        }
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromList(IntegerDataset.class, inds), (Dataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{1, 5, -9}, null));
        iter = c.getBooleanIterator((Dataset)s, false);
        inds.clear();
        while (iter.hasNext()) {
            inds.add((int)c.getElementLongAbs(iter.index));
        }
        int[] nArray = new int[3];
        nArray[1] = 3;
        nArray[2] = -7;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromList(IntegerDataset.class, inds), (Dataset)DatasetFactory.createFromObject(IntegerDataset.class, (Object)nArray, null));
    }

    @Test
    public void testBooleanIterator() {
        DoubleDataset choice = null;
        int count = this.size;
        this.testIterator((Dataset)choice, count, null);
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
        choice = DatasetFactory.zeros((int[])new int[]{this.size});
        count = 0;
        this.testIterator((Dataset)choice, count, null);
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
        int i = 1;
        while (i < this.size) {
            choice.set((Object)1, i);
            ++count;
            i += 7;
        }
        this.testIterator((Dataset)choice, count, null);
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
    }

    @Test
    public void testBroadcastBooleanIterator() {
        DoubleDataset choice = null;
        int count = this.size;
        this.testBroadcastIterator((Dataset)choice, count, null);
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
        choice = DatasetFactory.zeros((int[])new int[]{this.size});
        count = 0;
        this.testBroadcastIterator((Dataset)choice, count, null);
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
        int i = 1;
        while (i < this.size) {
            choice.set((Object)1, i);
            ++count;
            i += 7;
        }
        this.testBroadcastIterator((Dataset)choice, count, null);
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{this.size}));
        this.testBroadcastIterator((Dataset)choice, count, (Dataset)DatasetFactory.zeros((int[])new int[]{3, this.size}));
    }

    private void testIterator(Dataset choice, int count, Dataset output) {
        int[] nShape;
        int nRank;
        DoubleDataset ch = null;
        DoubleDataset out = null;
        DoubleDataset ta = DatasetFactory.zeros((int[])new int[0]);
        if (choice != null) {
            ch = DatasetFactory.ones((int[])new int[0]);
        }
        if (output != null) {
            out = DatasetFactory.zeros((int[])new int[0]);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), 1);
        if (choice != null) {
            ch = DatasetFactory.zeros((int[])new int[0]);
            if (output != null) {
                out = DatasetFactory.zeros((int[])new int[0]);
            }
            this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), 0);
        }
        ta = DatasetFactory.createRange(DoubleDataset.class, (double)0.0, (double)this.size, (double)1.0);
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            out = output;
            out.fill((Object)0);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{16, this.size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 1;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 2, 2);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{this.size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 1;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 2, 2);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{16, 8, this.size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 2;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 3, 3);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{this.size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 2;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 3, 3);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset((Dataset)ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
    }

    private void testBroadcastIterator(Dataset choice, int count, Dataset output) {
        int[] nShape;
        int nRank;
        DoubleDataset ch = null;
        DoubleDataset out = null;
        Dataset ta = DatasetFactory.createRange(DoubleDataset.class, (double)0.0, (double)this.size, (double)1.0);
        ta = ta.getSliceView(new Slice[]{new Slice(Integer.valueOf(this.size - 2), Integer.valueOf(this.size - 1), Integer.valueOf(1))});
        ta.setShape(new int[0]);
        if (choice != null) {
            ch = DatasetFactory.ones((int[])new int[0]);
        }
        if (output != null) {
            out = DatasetFactory.zeros((int[])new int[0]);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), 1);
        if (choice != null) {
            ch = DatasetFactory.zeros((int[])new int[0]);
            if (output != null) {
                out = DatasetFactory.zeros((int[])new int[0]);
            }
            this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), 0);
        }
        ta = DatasetFactory.createRange(DoubleDataset.class, (double)0.0, (double)this.size, (double)1.0);
        ta = ta.getSliceView(new Slice[]{new Slice(null, null, Integer.valueOf(-1))});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            out = output;
            out.fill((Object)0);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{16, this.size / 16});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 1;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 2, 2);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{this.size / 32, 32});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 1;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 2, 2);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{16, 8, this.size / 128});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 2;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 3, 3);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
        ta = ta.reshape(new int[]{this.size / 128, 16, 8});
        TestUtils.verbosePrintf((String)" Shape: %s\n", (Object[])new Object[]{Arrays.toString(ta.getShape())});
        if (choice != null) {
            ch = choice.reshape(ta.getShapeRef());
        }
        if (output != null) {
            nRank = output.getRank() + 2;
            nShape = Arrays.copyOf(output.getShapeRef(), nRank);
            System.arraycopy(ta.getShapeRef(), 0, nShape, nRank - 3, 3);
            out = output.reshape(nShape);
            out.fill((Object)0);
        }
        this.testDataset(ta, (Dataset)out, BooleanIterator.createIterator((Dataset)ta, (Dataset)ch, (Dataset)out), count);
    }

    private void testDataset(Dataset ta, Dataset out, BooleanIterator iter, int counts) {
        int counted = 0;
        while (iter.hasNext()) {
            ++counted;
            if (out == null) continue;
            out.setObjectAbs(iter.oIndex, (Object)1);
        }
        if (out != null) {
            Assert.assertEquals((long)(counts * out.getSize() / ta.getSize()), (long)counted);
            Assert.assertEquals((long)(counts * out.getSize() / ta.getSize()), (long)((Number)out.sum(new boolean[0])).intValue());
        } else {
            Assert.assertEquals((long)counts, (long)counted);
        }
        iter.reset();
        counted = 0;
        while (iter.hasNext()) {
            ++counted;
            if (out == null) continue;
            out.setObjectAbs(iter.oIndex, (Object)1);
        }
        if (out != null) {
            Assert.assertEquals((long)(counts * out.getSize() / ta.getSize()), (long)counted);
            Assert.assertEquals((long)(counts * out.getSize() / ta.getSize()), (long)((Number)out.sum(new boolean[0])).intValue());
        } else {
            Assert.assertEquals((long)counts, (long)counted);
        }
    }
}

