/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LinearAlgebra;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Random;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class LinearAlgebraTest {
    private static boolean close(Number a, double b) {
        double x = a.doubleValue();
        return x == 0.0 ? Math.abs(b) < 1.0E-5 : Math.abs(x - b) < 1.0E-5 * x;
    }

    @Test
    public void testTensorDot() {
        Dataset a = ((FloatDataset)DatasetFactory.createRange(FloatDataset.class, (double)60.0)).reshape(new int[]{3, 4, 5});
        Dataset b = ((ShortDataset)DatasetFactory.createRange(ShortDataset.class, (double)24.0)).reshape(new int[]{4, 3, 2});
        long start = -System.nanoTime();
        int[] nArray = new int[2];
        nArray[0] = 1;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        Dataset c = LinearAlgebra.tensorDotProduct((Dataset)a, (Dataset)b, (int[])nArray, (int[])nArray2);
        System.out.printf("Time taken %dus\n", (start += System.nanoTime()) / 1000L);
        Assert.assertArrayEquals((String)"Shape", (int[])new int[]{5, 2}, (int[])c.getShapeRef());
        Assert.assertTrue((String)"Interface", (boolean)(c instanceof FloatDataset));
        Dataset d = DatasetFactory.createFromObject((Object)new double[]{4400.0, 4730.0, 4532.0, 4874.0, 4664.0, 5018.0, 4796.0, 5162.0, 4928.0, 5306.0}, (int[])new int[]{5, 2});
        Assert.assertTrue((String)"Data does not match", (boolean)d.cast(c.getClass()).equals(c));
        int n = 16;
        a = ((FloatDataset)DatasetFactory.createRange(FloatDataset.class, (double)(20 * n))).reshape(new int[]{n, 4, 5});
        b = ((ShortDataset)DatasetFactory.createRange(ShortDataset.class, (double)(8 * n))).reshape(new int[]{4, n, 2});
        start = -System.nanoTime();
        c = LinearAlgebra.tensorDotProduct((Dataset)a, (Dataset)b, (int)0, (int)1);
        long nstart = -System.nanoTime();
        d = LinearAlgebra.tensorDotProduct((Dataset)a, (Dataset)b, (int[])new int[1], (int[])new int[]{1});
        System.out.printf("Time taken %dus %dus\n", (start += System.nanoTime()) / 1000L, (nstart += System.nanoTime()) / 1000L);
        Assert.assertTrue((String)"Data does not match", (boolean)d.equals(c));
    }

    @Test
    public void testDot() {
        DoubleDataset a = DatasetFactory.createRange((double)10.0);
        Dataset b = DatasetFactory.createRange(ShortDataset.class, (double)-6.0, (double)4.0, (double)1.0);
        long start = -System.nanoTime();
        Dataset c = LinearAlgebra.dotProduct((Dataset)a, (Dataset)b);
        long nstart = -System.nanoTime();
        Dataset d = Maths.multiply((Object)a, (Object)b);
        Number n = (Number)d.sum(new boolean[0]);
        System.out.printf("Time taken %dus %dus\n", (start += System.nanoTime()) / 1000L, (nstart += System.nanoTime()) / 1000L);
        Assert.assertTrue((String)"Data does not match", (boolean)n.equals(c.getObjectAbs(0)));
        Assert.assertTrue((String)"Data does not match", (boolean)n.equals(c.getObject()));
    }

    @Test
    public void testRandomDot() {
        DoubleDataset a = Random.randn((double)123.5, (double)23.4, (int[])new int[]{100});
        Dataset aa = Maths.square((Object)a);
        Dataset c = LinearAlgebra.tensorDotProduct((Dataset)a, (Dataset)a, (int)0, (int)0);
        System.nanoTime();
        Number n = (Number)aa.sum(new boolean[0]);
        Assert.assertTrue((String)("Second moment does not match: " + n + " cf " + c.getObject()), (boolean)LinearAlgebraTest.close(n, c.getDouble()));
        c = LinearAlgebra.dotProduct((Dataset)aa, (Dataset)a);
        Dataset d = Maths.multiply((Object)a, (Object)aa);
        n = (Number)d.sum(new boolean[0]);
        Assert.assertTrue((String)("Third moment does not match: " + n + " cf " + c.getObject()), (boolean)LinearAlgebraTest.close(n, c.getDouble()));
        c = LinearAlgebra.dotProduct((Dataset)aa, (Dataset)aa);
        d = Maths.multiply((Object)aa, (Object)aa);
        n = (Number)d.sum(new boolean[0]);
        Assert.assertTrue((String)("Fourth moment does not match: " + n + " cf " + c.getObject()), (boolean)LinearAlgebraTest.close(n, c.getDouble()));
    }

    @Test
    public void testOuter() {
        Dataset a = DatasetFactory.createRange(DoubleDataset.class, (double)2.0);
        Dataset b = DatasetFactory.createRange(DoubleDataset.class, (double)3.0);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 2.0}, (int[])new int[]{2, 3}), (Dataset)LinearAlgebra.outerProduct((Dataset)a, (Dataset)b), (double)1.0E-12, (double)1.0E-12);
        a = Random.randn((double)123.5, (double)23.4, (int[])new int[]{10});
        b = Random.randn((double)-31.2, (double)12.4, (int[])new int[]{7});
        Dataset c = LinearAlgebra.outerProduct((Dataset)a, (Dataset)b);
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 7) {
                Assert.assertEquals((String)"", (double)(a.getDouble(i) * b.getDouble(j)), (double)c.getDouble(i, j), (double)1.0E-12);
                ++j;
            }
            ++i;
        }
    }

    @Test
    public void testCross() {
        Dataset a = DatasetFactory.createFromObject((Object)new int[]{2, 3, 5}, (int[])new int[]{3});
        Dataset b = DatasetFactory.createFromObject((Object)new float[]{1.0f, 4.0f, 7.0f, 2.0f, 5.0f, 8.0f}, (int[])new int[]{2, 3});
        Dataset c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.0, -9.0, 5.0, -1.0, -6.0, 4.0}, (int[])new int[]{2, 3}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        Dataset d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b, (int)-1, (int)-1, (int)0);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.0, -1.0, -9.0, -6.0, 5.0, 4.0}, (int[])new int[]{3, 2}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a, (int)-1, (int)-1, (int)0);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 3;
        a = DatasetFactory.createFromObject((Object)nArray, (int[])new int[]{3});
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{21.0, -14.0, 5.0, 24.0, -16.0, 4.0}, (int[])new int[]{2, 3}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        a = DatasetFactory.createFromObject((Object)new int[]{2, 3}, (int[])new int[]{2});
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{21.0, -14.0, 5.0, 24.0, -16.0, 4.0}, (int[])new int[]{2, 3}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        a = DatasetFactory.createFromObject((Object)new int[]{2, 3, 5}, (int[])new int[]{3});
        b = DatasetFactory.createFromObject((Object)new float[]{1.0f, 4.0f, 0.0f, 2.0f, 5.0f, 0.0f}, (int[])new int[]{2, 3});
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-20.0, 5.0, 5.0, -25.0, 10.0, 4.0}, (int[])new int[]{2, 3}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        b = DatasetFactory.createFromObject((Object)new float[]{1.0f, 4.0f, 2.0f, 5.0f}, (int[])new int[]{2, 2});
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{-20.0, 5.0, 5.0, -25.0, 10.0, 4.0}, (int[])new int[]{2, 3}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
        a = DatasetFactory.createFromObject((Object)new int[]{2, 3}, (int[])new int[]{2});
        b = DatasetFactory.createFromObject((Object)new float[]{1.0f, 4.0f, 2.0f, 5.0f}, (int[])new int[]{2, 2});
        c = LinearAlgebra.crossProduct((Dataset)a, (Dataset)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{5.0, 4.0}, (int[])new int[]{2}), (Dataset)c, (double)1.0E-15, (double)1.0E-15);
        d = LinearAlgebra.crossProduct((Dataset)b, (Dataset)a);
        TestUtils.assertDatasetEquals((Dataset)Maths.negative((Object)c), (Dataset)d, (double)1.0E-15, (double)1.0E-15);
    }

    @Test
    public void testNorm() {
        Dataset a = DatasetFactory.createRange(IntegerDataset.class, (double)9.0);
        a.isubtract((Object)4);
        Dataset b = a.reshape(new int[]{3, 3});
        LinearAlgebra.NormOrder n = LinearAlgebra.NormOrder.DEFAULT;
        Assert.assertEquals((double)7.745966692414834, (double)LinearAlgebra.norm((Dataset)a, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        Assert.assertEquals((double)7.745966692414834, (double)LinearAlgebra.norm((Dataset)b, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        n = LinearAlgebra.NormOrder.POS_INFINITY;
        Assert.assertEquals((double)4.0, (double)LinearAlgebra.norm((Dataset)a, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        Assert.assertEquals((double)9.0, (double)LinearAlgebra.norm((Dataset)b, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        n = LinearAlgebra.NormOrder.NEG_INFINITY;
        Assert.assertEquals((double)0.0, (double)LinearAlgebra.norm((Dataset)a, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        Assert.assertEquals((double)2.0, (double)LinearAlgebra.norm((Dataset)b, (LinearAlgebra.NormOrder)n), (double)1.0E-15);
        int p = 1;
        Assert.assertEquals((double)20.0, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-15);
        Assert.assertEquals((double)7.0, (double)LinearAlgebra.norm((Dataset)b, (double)p), (double)1.0E-15);
        p = -1;
        Assert.assertEquals((double)-4.656612877414201E-10, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-9);
        Assert.assertEquals((double)6.0, (double)LinearAlgebra.norm((Dataset)b, (double)p), (double)1.0E-15);
        p = 2;
        Assert.assertEquals((double)7.745966692414834, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-15);
        Assert.assertEquals((double)7.3484692283495345, (double)LinearAlgebra.norm((Dataset)b, (double)p), (double)1.0E-15);
        p = -2;
        Assert.assertEquals((double)0.0, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-15);
        Assert.assertEquals((double)1.8570331885190563E-16, (double)LinearAlgebra.norm((Dataset)b, (double)p), (double)1.0E-15);
        p = 3;
        Assert.assertEquals((double)5.848035476425731, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-15);
        p = -3;
        Assert.assertEquals((double)0.0, (double)LinearAlgebra.norm((Dataset)a, (double)p), (double)1.0E-15);
    }

    @Test
    public void testDeterminant() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)1.0, (double)21.0, (double)1.0)).reshape(new int[]{4, 5});
        Assert.assertEquals((double)0.0, (double)LinearAlgebra.calcDeterminant((Dataset)a.getSliceView(new Slice[]{null, new Slice(Integer.valueOf(4))})), (double)1.0E-8);
    }

    @Test
    public void testTrace() {
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)20.0)).reshape(new int[]{4, 5});
        Assert.assertEquals((long)36L, (long)LinearAlgebra.trace((Dataset)a).getInt());
        Assert.assertEquals((long)33L, (long)LinearAlgebra.trace((Dataset)a, (int)-1, (int)0, (int)1).getInt());
        Assert.assertEquals((long)40L, (long)LinearAlgebra.trace((Dataset)a, (int)1, (int)0, (int)1).getInt());
        a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)60.0)).reshape(new int[]{3, 4, 5});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{36, 116, 196}, null), (Dataset)LinearAlgebra.trace((Dataset)a, (int)0, (int)1, (int)2), (boolean)true, (double)1.0E-12, (double)1.0E-12);
    }

    @Test
    public void testKronecker() {
        Dataset a = DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{1, 10, 100}, null);
        Dataset b = DatasetFactory.createFromObject(IntegerDataset.class, (Object)new int[]{5, 6, 7}, null);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{5, 6, 7, 50, 60, 70, 500, 600, 700}, null), (Dataset)LinearAlgebra.kroneckerProduct((Dataset)a, (Dataset)b), (boolean)true, (double)1.0E-12, (double)1.0E-12);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new int[]{5, 50, 500, 6, 60, 600, 7, 70, 700}, null), (Dataset)LinearAlgebra.kroneckerProduct((Dataset)b, (Dataset)a), (boolean)true, (double)1.0E-12, (double)1.0E-12);
        a = DatasetUtils.eye(ShortDataset.class, (int)2, (int)2, (int)0);
        b = DatasetFactory.ones(FloatDataset.class, (int[])new int[]{2, 2});
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new float[]{1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f}, (int[])new int[]{4, 4}), (Dataset)LinearAlgebra.kroneckerProduct((Dataset)a, (Dataset)b), (boolean)true, (double)1.0E-12, (double)1.0E-12);
    }

    @Test
    public void testPower() {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = -1;
        Dataset a = DatasetFactory.createFromObject((Object)nArray, (int[])new int[]{2, 2});
        int[] nArray2 = new int[4];
        nArray2[1] = -1;
        nArray2[2] = 1;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)nArray2, (int[])new int[]{2, 2}), (Dataset)LinearAlgebra.power((Dataset)a, (int)3), (boolean)true, (double)1.0E-12, (double)1.0E-12);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{0.0, 1.0, -1.0, 0.0}, (int[])new int[]{2, 2}), (Dataset)LinearAlgebra.power((Dataset)a, (int)-3), (boolean)true, (double)1.0E-12, (double)1.0E-12);
        TestUtils.assertDatasetEquals((Dataset)DatasetUtils.eye(IntegerDataset.class, (int)4, (int)4, (int)0), (Dataset)LinearAlgebra.power((Dataset)DatasetFactory.zeros(IntegerDataset.class, (int[])new int[]{4, 4}), (int)0), (boolean)true, (double)1.0E-12, (double)1.0E-12);
    }

    @Test
    public void testSolve() {
        Dataset a = DatasetFactory.createFromObject((Object)new int[]{3, 1, 1, 2}, (int[])new int[]{2, 2});
        Dataset b = DatasetFactory.createFromObject((Object)new int[]{9, 8}, null);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{2.0, 3.0}), (Dataset)LinearAlgebra.solve((Dataset)a, (Dataset)b), (boolean)true, (double)1.0E-12, (double)1.0E-12);
    }
}

