/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;
import org.eclipse.january.dataset.BooleanDataset;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.ComplexFloatDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundDoubleDataset;
import org.eclipse.january.dataset.CompoundFloatDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.CompoundLongDataset;
import org.eclipse.january.dataset.CompoundShortDataset;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.DateDatasetImpl;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.InterfaceUtils;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.ObjectDataset;
import org.eclipse.january.dataset.RGBDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.StringDataset;

public class DatasetFactory {
    public static DoubleDataset createRange(double stop) {
        return DatasetFactory.createRange(DoubleDataset.class, 0.0, stop, 1.0);
    }

    public static DoubleDataset createRange(double start, double stop, double step) {
        return DatasetFactory.createRange(DoubleDataset.class, start, stop, step);
    }

    @Deprecated
    public static Dataset createRange(double stop, int dtype) {
        return DatasetFactory.createRange(0.0, stop, 1.0, dtype);
    }

    @Deprecated
    public static Dataset createRange(double start, double stop, double step, int dtype) {
        if (step > 0.0 != start <= stop) {
            throw new IllegalArgumentException("Invalid parameters: start and stop must be in correct order for step");
        }
        switch (dtype) {
            case 0: {
                break;
            }
            case 1: {
                return ByteDataset.createRange(start, stop, step);
            }
            case 2: {
                return ShortDataset.createRange(start, stop, step);
            }
            case 3: {
                return IntegerDataset.createRange(start, stop, step);
            }
            case 4: {
                return LongDataset.createRange(start, stop, step);
            }
            case 5: {
                return FloatDataset.createRange(start, stop, step);
            }
            case 6: {
                return DoubleDataset.createRange(start, stop, step);
            }
            case 7: {
                return ComplexFloatDataset.createRange(start, stop, step);
            }
            case 8: {
                return ComplexDoubleDataset.createRange(start, stop, step);
            }
        }
        throw new IllegalArgumentException("dtype not known");
    }

    @Deprecated
    public static CompoundDataset createRange(int itemSize, double stop, int dtype) {
        return DatasetFactory.createRange(itemSize, 0.0, stop, 1.0, dtype);
    }

    @Deprecated
    public static CompoundDataset createRange(int itemSize, double start, double stop, double step, int dtype) {
        if (itemSize < 1) {
            throw new IllegalArgumentException("Item size must be greater or equal to 1");
        }
        if (step > 0.0 != start <= stop) {
            throw new IllegalArgumentException("Invalid parameters: start and stop must be in correct order for step");
        }
        switch (dtype) {
            case 0: {
                break;
            }
            case 1: 
            case 100: {
                return CompoundIntegerDataset.createRange(itemSize, start, stop, step);
            }
            case 2: 
            case 200: {
                return CompoundShortDataset.createRange(itemSize, start, stop, step);
            }
            case 3: 
            case 300: {
                return CompoundIntegerDataset.createRange(itemSize, start, stop, step);
            }
            case 4: 
            case 400: {
                return CompoundLongDataset.createRange(itemSize, start, stop, step);
            }
            case 5: 
            case 500: {
                return CompoundFloatDataset.createRange(itemSize, start, stop, step);
            }
            case 6: 
            case 600: {
                return CompoundDoubleDataset.createRange(itemSize, start, stop, step);
            }
            case 7: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Item size must be equal to 2");
                }
                return ComplexFloatDataset.createRange(start, stop, step);
            }
            case 8: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Item size must be equal to 2");
                }
                return ComplexFloatDataset.createRange(start, stop, step);
            }
        }
        throw new IllegalArgumentException("dtype not known");
    }

    public static Dataset createFromObject(Object obj) {
        return DatasetFactory.createFromObject(obj, null);
    }

    public static Dataset createFromObject(Object obj, int ... shape) {
        if (obj instanceof IDataset) {
            Dataset d = DatasetUtils.convertToDataset((IDataset)obj);
            if (shape != null) {
                d.setShape(shape);
            }
            return d;
        }
        if (obj instanceof BigInteger) {
            obj = ((BigInteger)obj).longValue();
        }
        int dtype = DTypeUtils.getDTypeFromObject(obj);
        return DatasetFactory.createFromObject(dtype, obj, shape);
    }

    public static Dataset createFromObject(boolean isUnsigned, Object obj) {
        Dataset a = DatasetFactory.createFromObject(obj);
        if (isUnsigned) {
            a = DatasetUtils.makeUnsigned(a, true);
        }
        return a;
    }

    @Deprecated
    public static Dataset createFromObject(int dtype, Object obj) {
        return DatasetFactory.createFromObject(dtype, obj, null);
    }

    @Deprecated
    public static Dataset createFromObject(int dtype, Object obj, int ... shape) {
        return DatasetFactory.createFromObject(1, dtype, obj, shape);
    }

    @Deprecated
    public static Dataset createFromObject(int itemSize, int dtype, Object obj, int ... shape) {
        Dataset d = null;
        if (obj instanceof IDataset) {
            d = itemSize == 1 ? DatasetUtils.cast((IDataset)obj, dtype) : DatasetUtils.cast((IDataset)obj, false, dtype, itemSize);
        } else {
            Class<?> ca;
            Class<?> clazz = ca = obj == null ? null : obj.getClass().getComponentType();
            if (ca != null && (ca.isPrimitive() || ca.equals(String.class))) {
                switch (dtype) {
                    case 7: {
                        return new ComplexFloatDataset(DTypeUtils.toFloatArray(obj, DTypeUtils.getLength(obj)), shape);
                    }
                    case 8: {
                        return new ComplexDoubleDataset(DTypeUtils.toDoubleArray(obj, DTypeUtils.getLength(obj)), shape);
                    }
                }
                d = DatasetFactory.createFromPrimitiveArray(DTypeUtils.getDTypeFromClass(ca), obj);
                if (!DTypeUtils.isDTypeElemental(dtype)) {
                    d = DatasetUtils.createCompoundDataset(d, dtype == 203 ? 3 : itemSize);
                    if (dtype == 203 && d.getSize() == 1) {
                        d.setShape(new int[0]);
                    }
                }
                d = DatasetUtils.cast(d, dtype);
            } else {
                switch (dtype) {
                    case 0: {
                        d = BooleanDataset.createFromObject(obj);
                        break;
                    }
                    case 1: {
                        d = ByteDataset.createFromObject(obj);
                        break;
                    }
                    case 2: {
                        d = ShortDataset.createFromObject(obj);
                        break;
                    }
                    case 3: {
                        d = IntegerDataset.createFromObject(obj);
                        break;
                    }
                    case 4: {
                        d = LongDataset.createFromObject(obj);
                        break;
                    }
                    case 100: {
                        d = CompoundByteDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 200: {
                        d = CompoundShortDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 300: {
                        d = CompoundIntegerDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 400: {
                        d = CompoundLongDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 5: {
                        d = FloatDataset.createFromObject(obj);
                        break;
                    }
                    case 6: {
                        d = DoubleDataset.createFromObject(obj);
                        break;
                    }
                    case 500: {
                        d = CompoundFloatDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 600: {
                        d = CompoundDoubleDataset.createFromObject(itemSize, obj);
                        break;
                    }
                    case 7: {
                        d = ComplexFloatDataset.createFromObject(obj);
                        break;
                    }
                    case 8: {
                        d = ComplexDoubleDataset.createFromObject(obj);
                        break;
                    }
                    case 11: {
                        d = DateDatasetImpl.createFromObject(obj);
                        break;
                    }
                    case 9: {
                        d = StringDataset.createFromObject(obj);
                        break;
                    }
                    case 10: {
                        d = ObjectDataset.createFromObject(obj);
                        break;
                    }
                    case 203: {
                        d = RGBDataset.createFromObject(obj);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Dataset type is not known");
                    }
                }
            }
        }
        if (shape != null && (shape.length != 0 || d.getSize() <= 1)) {
            d.setShape(shape);
        }
        return d;
    }

    private static Dataset createFromPrimitiveArray(int dtype, Object array) {
        switch (dtype) {
            case 0: {
                return new BooleanDataset((boolean[])array, new int[0]);
            }
            case 1: {
                return new ByteDataset((byte[])array, new int[0]);
            }
            case 2: {
                return new ShortDataset((short[])array, new int[0]);
            }
            case 3: {
                return new IntegerDataset((int[])array, null);
            }
            case 4: {
                return new LongDataset((long[])array, new int[0]);
            }
            case 5: {
                return new FloatDataset((float[])array, new int[0]);
            }
            case 6: {
                return new DoubleDataset((double[])array, new int[0]);
            }
            case 9: {
                return new StringDataset((String[])array, new int[0]);
            }
            case 11: {
                return new DateDatasetImpl((Date[])array, new int[0]);
            }
        }
        return null;
    }

    public static Dataset createFromList(List<?> objectList) {
        if (objectList == null || objectList.size() == 0) {
            throw new IllegalArgumentException("No list or zero-length list given");
        }
        Object obj = null;
        for (Object o : objectList) {
            if (o == null) continue;
            obj = o;
            break;
        }
        if (obj == null) {
            return DatasetFactory.zeros(ObjectDataset.class, objectList.size());
        }
        Class<?> clazz = obj.getClass();
        if (InterfaceUtils.isElementSupported(clazz)) {
            return DatasetFactory.createFromList(InterfaceUtils.getInterface(obj), objectList);
        }
        return DatasetFactory.createFromObject(objectList);
    }

    @Deprecated
    public static Dataset createFromList(int dtype, List<?> objectList) {
        int len = objectList.size();
        Dataset result = DatasetFactory.zeros(new int[]{len}, dtype);
        int i = 0;
        while (i < len) {
            result.setObjectAbs(i, objectList.get(i));
            ++i;
        }
        return result;
    }

    public static CompoundDataset createCompoundDataset(Object ... objects) {
        Dataset[] datasets = new Dataset[objects.length];
        int i = 0;
        while (i < objects.length) {
            datasets[i] = DatasetFactory.createFromObject(objects[i]);
            ++i;
        }
        return DatasetUtils.createCompoundDataset(datasets);
    }

    @Deprecated
    public static CompoundDataset createCompoundDataset(int dtype, Object ... objects) {
        Dataset[] datasets = new Dataset[objects.length];
        int i = 0;
        while (i < objects.length) {
            datasets[i] = DatasetFactory.createFromObject(objects[i]);
            ++i;
        }
        return DatasetUtils.createCompoundDataset(dtype, datasets);
    }

    @Deprecated
    public static CompoundDataset createComplexDataset(int dtype, Object real, Object imag) {
        switch (dtype) {
            case 7: {
                return new ComplexFloatDataset(DatasetFactory.createFromObject(real), DatasetFactory.createFromObject(imag));
            }
            case 8: {
                return new ComplexDoubleDataset(DatasetFactory.createFromObject(real), DatasetFactory.createFromObject(imag));
            }
        }
        throw new IllegalArgumentException("Dataset class must be a complex one");
    }

    public static DoubleDataset zeros(int ... shape) {
        return DatasetFactory.zeros(DoubleDataset.class, shape);
    }

    @Deprecated
    public static Dataset zeros(int[] shape, int dtype) {
        switch (dtype) {
            case 0: {
                return new BooleanDataset(shape);
            }
            case 1: 
            case 100: {
                return new ByteDataset(shape);
            }
            case 2: 
            case 200: {
                return new ShortDataset(shape);
            }
            case 203: {
                return new RGBDataset(shape);
            }
            case 3: 
            case 300: {
                return new IntegerDataset(shape);
            }
            case 4: 
            case 400: {
                return new LongDataset(shape);
            }
            case 5: 
            case 500: {
                return new FloatDataset(shape);
            }
            case 6: 
            case 600: {
                return new DoubleDataset(shape);
            }
            case 7: {
                return new ComplexFloatDataset(shape);
            }
            case 8: {
                return new ComplexDoubleDataset(shape);
            }
            case 9: {
                return new StringDataset(shape);
            }
            case 11: {
                return new DateDatasetImpl(shape);
            }
            case 10: {
                return new ObjectDataset(shape);
            }
        }
        throw new IllegalArgumentException("dtype not known or unsupported");
    }

    @Deprecated
    public static Dataset zeros(int itemSize, int[] shape, int dtype) {
        if (itemSize == 1) {
            return DatasetFactory.zeros(shape, dtype);
        }
        return DatasetFactory.compoundZeros(itemSize, shape, dtype);
    }

    @Deprecated
    public static CompoundDataset compoundZeros(int itemSize, int[] shape, int dtype) {
        switch (dtype) {
            case 1: 
            case 100: {
                return new CompoundByteDataset(itemSize, shape);
            }
            case 2: 
            case 200: {
                return new CompoundShortDataset(itemSize, shape);
            }
            case 203: {
                if (itemSize != 3) {
                    throw new IllegalArgumentException("Number of elements not compatible with RGB type");
                }
                return new RGBDataset(shape);
            }
            case 3: 
            case 300: {
                return new CompoundIntegerDataset(itemSize, shape);
            }
            case 4: 
            case 400: {
                return new CompoundLongDataset(itemSize, shape);
            }
            case 5: 
            case 500: {
                return new CompoundFloatDataset(itemSize, shape);
            }
            case 6: 
            case 600: {
                return new CompoundDoubleDataset(itemSize, shape);
            }
            case 7: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexFloatDataset(shape);
            }
            case 8: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return new ComplexDoubleDataset(shape);
            }
        }
        throw new IllegalArgumentException("dtype not a known compound type");
    }

    public static <T extends Dataset> T zeros(T dataset) {
        int dtype = dataset.getDType();
        return (T)(DTypeUtils.isDTypeElemental(dtype) ? DatasetFactory.zeros(dataset, dtype) : DatasetFactory.compoundZeros(dataset.getElementsPerItem(), dataset.getShapeRef(), dtype));
    }

    @Deprecated
    public static Dataset zeros(Dataset dataset, int dtype) {
        int[] shape = dataset.getShapeRef();
        int isize = DTypeUtils.isDTypeElemental(dtype) ? 1 : dataset.getElementsPerItem();
        return DatasetFactory.zeros(isize, shape, dtype);
    }

    public static <T extends Dataset> T ones(T dataset) {
        return (T)DatasetFactory.ones(dataset, dataset.getDType());
    }

    @Deprecated
    public static Dataset ones(Dataset dataset, int dtype) {
        int[] shape = dataset.getShapeRef();
        int isize = DTypeUtils.isDTypeElemental(dtype) ? 1 : dataset.getElementsPerItem();
        return DatasetFactory.ones(isize, shape, dtype);
    }

    public static DoubleDataset ones(int ... shape) {
        return DatasetFactory.ones(DoubleDataset.class, shape);
    }

    @Deprecated
    public static Dataset ones(int[] shape, int dtype) {
        switch (dtype) {
            case 0: {
                return BooleanDataset.ones(shape);
            }
            case 1: {
                return ByteDataset.ones(shape);
            }
            case 2: {
                return ShortDataset.ones(shape);
            }
            case 203: {
                return new RGBDataset(shape).fill(1);
            }
            case 3: {
                return IntegerDataset.ones(shape);
            }
            case 4: {
                return LongDataset.ones(shape);
            }
            case 5: {
                return FloatDataset.ones(shape);
            }
            case 6: {
                return DoubleDataset.ones(shape);
            }
            case 7: {
                return ComplexFloatDataset.ones(shape);
            }
            case 8: {
                return ComplexDoubleDataset.ones(shape);
            }
        }
        throw new IllegalArgumentException("dtype not known");
    }

    @Deprecated
    public static Dataset ones(int itemSize, int[] shape, int dtype) {
        if (itemSize == 1) {
            return DatasetFactory.ones(shape, dtype);
        }
        switch (dtype) {
            case 1: 
            case 100: {
                return CompoundByteDataset.ones(itemSize, shape);
            }
            case 2: 
            case 200: {
                return CompoundShortDataset.ones(itemSize, shape);
            }
            case 203: {
                if (itemSize != 3) {
                    throw new IllegalArgumentException("Number of elements not compatible with RGB type");
                }
                return new RGBDataset(shape).fill(1);
            }
            case 3: 
            case 300: {
                return CompoundIntegerDataset.ones(itemSize, shape);
            }
            case 4: 
            case 400: {
                return CompoundLongDataset.ones(itemSize, shape);
            }
            case 5: 
            case 500: {
                return CompoundFloatDataset.ones(itemSize, shape);
            }
            case 6: 
            case 600: {
                return CompoundDoubleDataset.ones(itemSize, shape);
            }
            case 7: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return ComplexFloatDataset.ones(shape);
            }
            case 8: {
                if (itemSize != 2) {
                    throw new IllegalArgumentException("Number of elements not compatible with complex type");
                }
                return ComplexDoubleDataset.ones(shape);
            }
        }
        throw new IllegalArgumentException("dtype not a known compound type");
    }

    @Deprecated
    public static Dataset createLinearSpace(double start, double stop, int length, int dtype) {
        return DatasetFactory.createLinearSpace(DTypeUtils.getInterface(dtype), start, stop, length);
    }

    public static <T extends Dataset> T createLinearSpace(Class<T> clazz, double start, double stop, int length) {
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one");
        }
        if (length == 1) {
            return DatasetFactory.createFromObject(clazz, (Object)start);
        }
        T ds = DatasetFactory.zeros(clazz, length);
        double num = stop - start;
        double den = length - 1;
        int i = 0;
        while (i < length) {
            double value = start + num * (double)i / den;
            ds.setObjectAbs(i, value);
            ++i;
        }
        return ds;
    }

    @Deprecated
    public static Dataset createLogSpace(double start, double stop, int length, double base, int dtype) {
        return DatasetFactory.createLogSpace(DTypeUtils.getInterface(dtype), start, stop, length, base);
    }

    public static <T extends Dataset> T createLogSpace(Class<T> clazz, double start, double stop, int length, double base) {
        if (length < 1) {
            throw new IllegalArgumentException("Length is less than one");
        }
        if (length == 1) {
            return DatasetFactory.createFromObject(clazz, (Object)Math.pow(base, start));
        }
        T ds = DatasetFactory.zeros(clazz, length);
        double step = (stop - start) / (double)(length - 1);
        int i = 0;
        while (i < length) {
            double value = start + (double)i * step;
            ds.setObjectAbs(i, Math.pow(base, value));
            ++i;
        }
        return ds;
    }

    public static <T extends Dataset> T createRange(Class<T> clazz, double stop) {
        return (T)DatasetFactory.createRange(0.0, stop, 1.0, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T createRange(Class<T> clazz, double start, double stop, double step) {
        return (T)DatasetFactory.createRange(start, stop, step, DTypeUtils.getDType(clazz));
    }

    public static <T extends CompoundDataset> T createRange(int itemSize, Class<T> clazz, double stop) {
        return (T)DatasetFactory.createRange(itemSize, 0.0, stop, 1.0, DTypeUtils.getDType(clazz));
    }

    public static <T extends CompoundDataset> T createRange(int itemSize, Class<T> clazz, double start, double stop, double step) {
        return (T)DatasetFactory.createRange(itemSize, start, stop, step, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T createFromObject(Class<T> clazz, Object obj) {
        return (T)DatasetFactory.createFromObject(1, DTypeUtils.getDType(clazz), obj, null);
    }

    public static <T extends Dataset> T createFromObject(Class<T> clazz, Object obj, int ... shape) {
        return (T)DatasetFactory.createFromObject(1, DTypeUtils.getDType(clazz), obj, shape);
    }

    public static <T extends Dataset> T createFromObject(int itemSize, Class<T> clazz, Object obj, int ... shape) {
        return (T)DatasetFactory.createFromObject(itemSize, DTypeUtils.getDType(clazz), obj, shape);
    }

    public static <T extends Dataset> T createFromList(Class<T> clazz, List<?> objectList) {
        return (T)DatasetFactory.createFromList(DTypeUtils.getDType(clazz), objectList);
    }

    public static <T extends Dataset> T createCompoundDataset(Class<T> clazz, Object ... objects) {
        return (T)DatasetFactory.createCompoundDataset(DTypeUtils.getDType(clazz), objects);
    }

    public static <T extends Dataset> T createComplexDataset(Class<T> clazz, Object real, Object imag) {
        return (T)DatasetFactory.createComplexDataset(DTypeUtils.getDType(clazz), real, imag);
    }

    public static <T extends Dataset> T zeros(Class<T> clazz, int ... shape) {
        return (T)DatasetFactory.zeros(shape, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T zeros(int itemSize, Class<T> clazz, int ... shape) {
        return (T)DatasetFactory.zeros(itemSize, shape, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T zeros(Dataset dataset, Class<T> clazz) {
        return (T)DatasetFactory.zeros(dataset, DTypeUtils.getDType(clazz));
    }

    public static <T extends CompoundDataset> T compoundZeros(int itemSize, Class<T> clazz, int ... shape) {
        return (T)DatasetFactory.compoundZeros(itemSize, shape, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T ones(Class<T> clazz, int ... shape) {
        return (T)DatasetFactory.ones(shape, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T ones(int itemSize, Class<T> clazz, int ... shape) {
        return (T)DatasetFactory.ones(itemSize, shape, DTypeUtils.getDType(clazz));
    }

    public static <T extends Dataset> T ones(Dataset dataset, Class<T> clazz) {
        return (T)DatasetFactory.ones(dataset, DTypeUtils.getDType(clazz));
    }
}

