/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.signaturetest;

import ee.jakarta.tck.jsonp.signaturetest.SigTestData;
import ee.jakarta.tck.jsonp.signaturetest.SigTestResult;
import ee.jakarta.tck.jsonp.signaturetest.SignatureTestDriver;
import ee.jakarta.tck.jsonp.signaturetest.SignatureTestDriverFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class SigTestEE {
    private static final Logger LOGGER = Logger.getLogger(SigTestEE.class.getName());
    String[] sVehicles;
    private Object theSharedObject;
    private Object[] theSharedObjectArray;
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl(this.testInfo.getBinDir());
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl(this.testInfo.getBinDir());
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl(this.testInfo.getTSHome());
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages(String var1);

    protected String[] getClasses(String vehicleName) {
        return new String[0];
    }

    public void setup() {
        try {
            LOGGER.info("$$$ SigTestEE.setup() called");
            this.testInfo = new SigTestData();
            LOGGER.info("$$$ SigTestEE.setup() complete");
        }
        catch (Exception e) {
            LOGGER.info("Unexpected exception " + e.getMessage());
        }
    }

    public void signatureTest() throws Fault {
        LOGGER.info("$$$ SigTestEE.signatureTest() called");
        SigTestResult results = null;
        String mapFile = this.getMapFile();
        String repositoryDir = this.getRepositoryDir();
        String[] packages = this.getPackages(this.testInfo.getVehicle());
        String[] classes = this.getClasses(this.testInfo.getVehicle());
        String packageFile = this.getPackageFile();
        String testClasspath = this.testInfo.getTestClasspath();
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = this.testInfo.getJImageDir();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            LOGGER.info("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                LOGGER.info(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    LOGGER.info(line);
                }
                int rc = proc.waitFor();
                LOGGER.info("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                LOGGER.info("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            LOGGER.info(results.toString());
            if (!results.passed()) {
                LOGGER.info("results.passed() returned false");
                throw new Exception();
            }
            if ("standalone".equalsIgnoreCase(this.testInfo.getVehicle())) {
                Properties mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
                if (mapFileAsProps == null || mapFileAsProps.size() == 0) {
                    LOGGER.info("SigTestEE.signatureTest() returning, as signature map file is empty.");
                    return;
                }
                boolean isJTASigTest = false;
                String jtaVersion = mapFileAsProps.getProperty("jakarta.transaction");
                if (jtaVersion == null || "".equals(jtaVersion.trim())) {
                    LOGGER.info("SigTestEE.signatureTest() returning, as this is neither JTA TCK run, not Java EE CTS run.");
                    return;
                }
                LOGGER.info("jtaVersion " + jtaVersion);
                if (mapFileAsProps.size() == 1) {
                    isJTASigTest = true;
                }
                if (isJTASigTest || !jtaVersion.startsWith("1.2")) {
                    this.verifyJtaJarTest();
                }
            }
            LOGGER.info("$$$ SigTestEE.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new Fault("SigTestEE.signatureTest() failed!, diffs found");
            }
            LOGGER.info("Unexpected exception " + e.getMessage());
            throw new Fault("signatureTest failed with an unexpected exception", e);
        }
    }

    public void verifyJtaJarTest() throws Exception {
        LOGGER.info("SigTestEE#verifyJtaJarTest - Starting:");
        String repositoryDir = this.getRepositoryDir();
        String jtaJarClasspath = this.testInfo.getJtaJarClasspath();
        boolean result = this.getSigTestDriver().verifyJTAJarForNoXA(this.testInfo.getJtaJarClasspath(), repositoryDir);
        if (!result) {
            LOGGER.info("FAIL: javax.transaction.xa found in API jar");
            throw new Fault("javax.transaction.xa validation failed");
        }
        LOGGER.info("PASS: javax.transaction.xa not found in API jar");
        LOGGER.info("SigTestEE#verifyJtaJarTest returning");
    }

    public void cleanup() throws Fault {
        LOGGER.info("$$$ SigTestEE.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            LOGGER.info("$$$ SigTestEE.cleanup() returning");
        }
        catch (Exception e) {
            throw new Fault("Cleanup failed!", e);
        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = -1574745208867827913L;
        public Throwable t;

        public Fault(String msg) {
            super(msg);
            LOGGER.info(msg);
        }

        public Fault(String msg, Throwable t) {
            super(msg);
            this.t = t;
            LOGGER.info(msg);
            t.printStackTrace();
        }

        public Fault(Throwable t) {
            super(t);
            this.t = t;
        }

        @Override
        public void printStackTrace() {
            if (this.t != null) {
                this.t.printStackTrace();
            } else {
                super.printStackTrace();
            }
        }

        @Override
        public void printStackTrace(PrintStream s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            if (this.t != null) {
                this.t.printStackTrace(s);
            } else {
                super.printStackTrace(s);
            }
        }

        @Override
        public Throwable getCause() {
            return this.t;
        }

        @Override
        public synchronized Throwable initCause(Throwable cause) {
            if (this.t != null) {
                throw new IllegalStateException("Can't overwrite cause");
            }
            if (!Exception.class.isInstance(cause)) {
                throw new IllegalArgumentException("Cause not permitted");
            }
            this.t = (Exception)cause;
            return this;
        }
    }
}

