/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.emde.diagram.javaaction;

import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EStringToStringMapEntryImpl;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.polarsys.kitalpha.emde.diagram.javaaction.AbstractEmdeExternalJavaAction;
import org.polarsys.kitalpha.emde.diagram.services.ExtensibilityService;

public class DeleteExtendedElementAction
extends AbstractEmdeExternalJavaAction {
    private static final String ENTRY = "entry";
    private static final String LINK = "link";
    private static final String VIEW = "view";

    public void execute(Collection<? extends EObject> selections, Map<String, Object> parameters) {
        EStringToStringMapEntryImpl entry = (EStringToStringMapEntryImpl)parameters.get(ENTRY);
        DEdge link = (DEdge)parameters.get(LINK);
        EClass targetClass = (EClass)((DDiagramElement)link.getTargetNode()).getTarget();
        if (targetClass != null) {
            String fragment = targetClass.eResource().getURIFragment((EObject)targetClass);
            EObject container = entry.eContainer().eContainer();
            if (container instanceof EClass) {
                EAnnotation annotation = ExtensibilityService.getAnnotation((EClass)container, "http://www.polarsys.org/kitalpha/emde/1.0.0/constraint");
                EStringToStringMapEntryImpl mappingEntry = ExtensibilityService.getEntry(annotation, "ExtendedElement");
                this.remove(entry, fragment);
                this.remove(mappingEntry, fragment);
            }
            UniqueEList objects = new UniqueEList();
            objects.add(targetClass);
            EObject view = (EObject)parameters.get(VIEW);
            ExtensibilityService.clean(view, (Collection<EObject>)objects);
        }
    }

    public void remove(EStringToStringMapEntryImpl entry, String fragment) {
        StringTokenizer stringTokenizer = new StringTokenizer(entry.getValue());
        StringBuilder builder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            String s = stringTokenizer.nextToken();
            if (s.contains(fragment)) continue;
            builder.append(s);
            builder.append(" ");
        }
        String newValue = builder.toString();
        if (newValue.replaceAll(" ", "").length() > 0) {
            entry.setValue(newValue);
        } else {
            EAnnotation annotation = (EAnnotation)entry.eContainer();
            EClass eClass = (EClass)annotation.eContainer();
            eClass.getEAnnotations().remove((Object)annotation);
        }
    }
}

