/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.inventory;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.cloudconnection.message.KuraMessage;
import org.eclipse.kura.cloudconnection.request.RequestHandlerMessageConstants;
import org.eclipse.kura.core.inventory.InventoryHandlerV1;
import org.eclipse.kura.message.KuraPayload;
import org.eclipse.kura.message.KuraResponsePayload;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.osgi.service.useradmin.UserAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/inventory/v1")
public class InventoryRestService {
    private static final Logger logger = LoggerFactory.getLogger(InventoryRestService.class);
    private static final String KURA_PERMISSION_REST_CONFIGURATION_ROLE = "kura.permission.rest.inventory";
    private InventoryHandlerV1 inventoryHandlerV1;

    public void setUserAdmin(UserAdmin userAdmin) {
        userAdmin.createRole(KURA_PERMISSION_REST_CONFIGURATION_ROLE, 2);
    }

    public void setInventoryHandlerV1(InventoryHandlerV1 inventoryHandlerV1) {
        this.inventoryHandlerV1 = inventoryHandlerV1;
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/inventory")
    @Produces(value={"application/json"})
    public Response getInventorySummary() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("inventory"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/bundles")
    @Produces(value={"application/json"})
    public Response getBundles() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("bundles"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"inventory"})
    @Path(value="/bundles/_start")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response startBundle(String bundleJson) {
        try {
            return this.makeInventoryDoExecRequest(this.buildKuraMessage(InventoryHandlerV1.START_BUNDLE, bundleJson));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"inventory"})
    @Path(value="/bundles/_stop")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response stopBundle(String bundleJson) {
        try {
            return this.makeInventoryDoExecRequest(this.buildKuraMessage(InventoryHandlerV1.STOP_BUNDLE, bundleJson));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/deploymentPackages")
    @Produces(value={"application/json"})
    public Response getDeploymentPackages() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("deploymentPackages"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/systemPackages")
    @Produces(value={"application/json"})
    public Response getSystemPackages() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("systemPackages"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/containers")
    @Produces(value={"application/json"})
    public Response getContainers() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("containers"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"inventory"})
    @Path(value="/containers/_start")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response startContainer(String bundleJson) {
        try {
            return this.makeInventoryDoExecRequest(this.buildKuraMessage(InventoryHandlerV1.START_CONTAINER, bundleJson));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"inventory"})
    @Path(value="/containers/_stop")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response stopContainer(String bundleJson) {
        try {
            return this.makeInventoryDoExecRequest(this.buildKuraMessage(InventoryHandlerV1.STOP_CONTAINER, bundleJson));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @GET
    @RolesAllowed(value={"inventory"})
    @Path(value="/images")
    @Produces(value={"application/json"})
    public Response getImages() {
        try {
            return this.makeInventoryDoGetRequest(this.buildKuraMessage(Arrays.asList("images"), ""));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    @POST
    @RolesAllowed(value={"inventory"})
    @Path(value="/images/_delete")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response deleteImage(String bundleJson) {
        try {
            return this.makeInventoryDoExecRequest(this.buildKuraMessage(InventoryHandlerV1.DELETE_IMAGE, bundleJson));
        }
        catch (KuraException e) {
            throw DefaultExceptionHandler.toWebApplicationException((KuraException)e);
        }
    }

    private KuraMessage buildKuraMessage(List<String> requestObject, String body) {
        HashMap<String, List<String>> payloadProperties = new HashMap<String, List<String>>();
        payloadProperties.put(RequestHandlerMessageConstants.ARGS_KEY.value(), requestObject);
        KuraPayload kuraPayload = new KuraPayload();
        kuraPayload.setBody(body.getBytes());
        return new KuraMessage(kuraPayload, payloadProperties);
    }

    private Response makeInventoryDoGetRequest(KuraMessage kuraMessage) throws KuraException {
        return this.buildResponse(this.inventoryHandlerV1.doGet(null, kuraMessage).getPayload());
    }

    private Response makeInventoryDoExecRequest(KuraMessage kuraMessage) throws KuraException {
        return this.buildResponse(this.inventoryHandlerV1.doExec(null, kuraMessage).getPayload());
    }

    private Response buildResponse(KuraPayload kuraPayload) throws KuraException {
        if (kuraPayload instanceof KuraResponsePayload) {
            KuraResponsePayload kuraResponsePayload = (KuraResponsePayload)kuraPayload;
            return Response.status((int)kuraResponsePayload.getResponseCode()).entity((Object)kuraPayload.getBody()).build();
        }
        throw new KuraException(KuraErrorCode.INVALID_MESSAGE_EXCEPTION);
    }
}

