/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.kura.deployment.agent.DeploymentAgentService;
import org.eclipse.kura.deployment.agent.MarketplacePackageDescriptor;
import org.eclipse.kura.ssl.SslManagerService;
import org.eclipse.kura.web.server.OsgiRemoteServiceServlet;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraErrorCode;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.GwtSafeHtmlUtils;
import org.eclipse.kura.web.shared.model.GwtDeploymentPackage;
import org.eclipse.kura.web.shared.model.GwtMarketplacePackageDescriptor;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtPackageService;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.deploymentadmin.BundleInfo;
import org.osgi.service.deploymentadmin.DeploymentAdmin;
import org.osgi.service.deploymentadmin.DeploymentPackage;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GwtPackageServiceImpl
extends OsgiRemoteServiceServlet
implements GwtPackageService {
    private static final long serialVersionUID = -3422518194598042896L;
    private static final Logger logger = LoggerFactory.getLogger(GwtPackageServiceImpl.class);
    private static final int MARKETPLACE_FEEDBACK_REQUEST_TIMEOUT = 20000;
    private static final String MARKETPLACE_URL = "https://marketplace.eclipse.org/node/%s/api/p";
    private final Supplier<Optional<SslManagerService>> sslManagerServiceSupplier;

    public GwtPackageServiceImpl(Supplier<Optional<SslManagerService>> sslManagerServiceSupplier) {
        this.sslManagerServiceSupplier = sslManagerServiceSupplier;
    }

    @Override
    public List<GwtDeploymentPackage> findDeviceDeploymentPackages(GwtXSRFToken xsrfToken) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        DeploymentAdmin deploymentAdmin = ServiceLocator.getInstance().getService(DeploymentAdmin.class);
        ArrayList<GwtDeploymentPackage> gwtDeploymentPackages = new ArrayList<GwtDeploymentPackage>();
        DeploymentPackage[] deploymentPackages = deploymentAdmin.listDeploymentPackages();
        BundleContext bc = FrameworkUtil.getBundle(this.getClass()).getBundleContext();
        List<Bundle> bundles = Arrays.asList(bc.getBundles());
        if (Objects.isNull(deploymentPackages)) {
            return gwtDeploymentPackages;
        }
        DeploymentPackage[] deploymentPackageArray = deploymentPackages;
        int n = deploymentPackages.length;
        int n2 = 0;
        while (n2 < n) {
            DeploymentPackage deploymentPackage = deploymentPackageArray[n2];
            GwtDeploymentPackage gwtDeploymentPackage = new GwtDeploymentPackage();
            gwtDeploymentPackage.setName(GwtSafeHtmlUtils.htmlEscape(deploymentPackage.getName()));
            gwtDeploymentPackage.setVersion(GwtSafeHtmlUtils.htmlEscape(deploymentPackage.getVersion().toString()));
            gwtDeploymentPackage.setSigned(true);
            BundleInfo[] bundleInfos = deploymentPackage.getBundleInfos();
            if (bundleInfos != null) {
                BundleInfo[] bundleInfoArray = bundleInfos;
                int n3 = bundleInfos.length;
                int n4 = 0;
                while (n4 < n3) {
                    BundleInfo bundleInfo = bundleInfoArray[n4];
                    Optional<Bundle> bundle = bundles.stream().filter(b -> b.getSymbolicName().equals(bundleInfo.getSymbolicName()) && b.getVersion().toString().equals(bundleInfo.getVersion().toString())).findFirst();
                    if (bundle.isPresent() && bundle.get().getSignerCertificates(1).isEmpty()) {
                        gwtDeploymentPackage.setSigned(false);
                        break;
                    }
                    ++n4;
                }
            }
            gwtDeploymentPackages.add(gwtDeploymentPackage);
            ++n2;
        }
        return gwtDeploymentPackages;
    }

    @Override
    public void uninstallDeploymentPackage(GwtXSRFToken xsrfToken, String packageName) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        DeploymentAgentService deploymentAgentService = ServiceLocator.getInstance().getService(DeploymentAgentService.class);
        try {
            deploymentAgentService.uninstallDeploymentPackageAsync(GwtSafeHtmlUtils.htmlEscape(packageName));
        }
        catch (Exception e) {
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR, (Throwable)e);
        }
    }

    @Override
    public GwtMarketplacePackageDescriptor getMarketplacePackageDescriptor(GwtXSRFToken xsrfToken, String nodeId) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        GwtMarketplacePackageDescriptor descriptor = new GwtMarketplacePackageDescriptor();
        try {
            SslManagerService sslManagerService = this.sslManagerServiceSupplier.get().orElseThrow(() -> new IllegalStateException("Failed to download package from Eclipse Marketplace, SslManagerService is not bound"));
            String url = String.format(MARKETPLACE_URL, nodeId);
            DeploymentAgentService deploymentAgentService = ServiceLocator.getInstance().getService(DeploymentAgentService.class);
            MarketplacePackageDescriptor marketplacePackageDescriptor = deploymentAgentService.getMarketplacePackageDescriptor(url, sslManagerService);
            descriptor.setCompatible(marketplacePackageDescriptor.isCompatible());
            descriptor.setDpUrl(marketplacePackageDescriptor.getDpUrl());
            descriptor.setMinKuraVersion(marketplacePackageDescriptor.getMinKuraVersion());
            descriptor.setMaxKuraVersion(marketplacePackageDescriptor.getMaxKuraVersion());
            descriptor.setCurrentKuraVersion(marketplacePackageDescriptor.getCurrentKuraVersion());
            descriptor.setNodeId(marketplacePackageDescriptor.getNodeId());
            descriptor.setUrl(marketplacePackageDescriptor.getUrl());
        }
        catch (Exception e) {
            logger.warn("failed to get deployment package descriptor from Eclipse Marketplace", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
        return descriptor;
    }

    @Override
    public void installPackageFromMarketplace(GwtXSRFToken xsrfToken, GwtMarketplacePackageDescriptor descriptor) throws GwtKuraException {
        this.checkXSRFToken(xsrfToken);
        try {
            ServiceLocator.applyToServiceOptionally(DeploymentAgentService.class, deploymentAgentService -> {
                if (deploymentAgentService == null) {
                    throw new IllegalStateException("Deployment Agent Service not running");
                }
                String dpUrl = descriptor.getDpUrl();
                Objects.requireNonNull(dpUrl);
                logger.info("Installing deployment package from Eclipse Marketplace, URL {}...", (Object)dpUrl);
                if (descriptor.getUrl() != null) {
                    new MarketplaceFeedbackEventHandler(descriptor);
                }
                deploymentAgentService.installDeploymentPackageAsync(dpUrl);
                return null;
            });
        }
        catch (Exception e) {
            logger.warn("failed to start package install from Eclipse Marketplace", (Throwable)e);
            throw new GwtKuraException(GwtKuraErrorCode.INTERNAL_ERROR);
        }
    }

    private static class MarketplaceFeedbackEventHandler
    implements EventHandler {
        private final GwtMarketplacePackageDescriptor descriptor;
        private final ServiceRegistration<EventHandler> registration;
        private static Hashtable<String, Object> serviceProperties;

        static {
            String[] topics = new String[]{DeploymentAgentService.EVENT_INSTALLED_TOPIC};
            serviceProperties = new Hashtable();
            serviceProperties.put("event.topics", topics);
        }

        private MarketplaceFeedbackEventHandler(GwtMarketplacePackageDescriptor descriptor) {
            this.descriptor = descriptor;
            this.registration = FrameworkUtil.getBundle(GwtPackageServiceImpl.class).getBundleContext().registerService(EventHandler.class, (Object)this, serviceProperties);
        }

        private void sendSuccessFeedbackToMarketplace() {
            block8: {
                HttpURLConnection connection = null;
                try {
                    try {
                        logger.info("Sending successful install feedback to Eclipse Marketplace...");
                        String feedbackUrl = this.descriptor.getUrl();
                        feedbackUrl = String.valueOf(feedbackUrl) + (feedbackUrl.endsWith("/") ? "success" : "/success");
                        connection = (HttpURLConnection)new URL(feedbackUrl).openConnection();
                        connection.setRequestMethod("GET");
                        connection.setReadTimeout(20000);
                        connection.connect();
                        if (connection.getResponseCode() / 200 == 1) {
                            logger.info("Sending successful install feedback to Eclipse Marketplace...done");
                            break block8;
                        }
                        throw new IOException("got status: " + connection.getResponseCode());
                    }
                    catch (Exception e) {
                        logger.warn("Sending successful install feedback to Eclipse Marketplace...failure", (Throwable)e);
                        if (connection != null) {
                            connection.disconnect();
                        }
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
        }

        public void handleEvent(Event event) {
            String eventUrl = (String)event.getProperty("deploymentpackage.url");
            String dpUrl = this.descriptor.getDpUrl();
            if (eventUrl != null && eventUrl.equals(this.descriptor.getDpUrl())) {
                try {
                    Boolean successful = (Boolean)event.getProperty("successful");
                    if (successful != null && successful.booleanValue()) {
                        logger.info("Installing deployment package from Eclipse Marketplace, URL {}...success", (Object)dpUrl);
                        this.sendSuccessFeedbackToMarketplace();
                    } else {
                        logger.info("Installing deployment package from Eclipse Marketplace, URL {}...failure", (Object)dpUrl);
                    }
                }
                finally {
                    this.registration.unregister();
                }
            }
        }
    }
}

