/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.server.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.asset.provider.AssetConstants;
import org.eclipse.kura.configuration.ComponentConfiguration;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.configuration.Password;
import org.eclipse.kura.core.configuration.ComponentConfigurationImpl;
import org.eclipse.kura.core.configuration.XmlComponentConfigurations;
import org.eclipse.kura.core.configuration.metatype.Tocd;
import org.eclipse.kura.crypto.CryptoService;
import org.eclipse.kura.marshalling.Marshaller;
import org.eclipse.kura.web.server.GwtWireGraphServiceImpl;
import org.eclipse.kura.web.server.KuraRemoteServiceServlet;
import org.eclipse.kura.web.server.RequiredPermissions;
import org.eclipse.kura.web.server.servlet.AuditServlet;
import org.eclipse.kura.web.server.util.GwtServerUtil;
import org.eclipse.kura.web.server.util.ServiceLocator;
import org.eclipse.kura.web.shared.GwtKuraException;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.wire.graph.WireComponentConfiguration;
import org.eclipse.kura.wire.graph.WireGraphService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WiresSnapshotServlet
extends AuditServlet {
    private static final String WIRE_GRAPH_SERVICE_PID = "org.eclipse.kura.wire.graph.WireGraphService";
    private static final String WIRE_ASSET_FACTORY_PID = "org.eclipse.kura.wire.WireAsset";
    private static final String JSON_FORMAT = "json";
    private static final String XML_FORMAT = "xml";
    private static final long serialVersionUID = -7483037360719617846L;
    private static final Logger logger = LoggerFactory.getLogger(WiresSnapshotServlet.class);

    public WiresSnapshotServlet() {
        super("UI Wires Snapshots", "Get wires snapshot");
    }

    private String toSnapshot(XmlComponentConfigurations configs) throws GwtKuraException {
        String string;
        block5: {
            BundleContext context = FrameworkUtil.getBundle(GwtWireGraphServiceImpl.class).getBundleContext();
            ServiceReference marshallerRef = null;
            Marshaller marshaller = null;
            try {
                marshallerRef = (ServiceReference)context.getServiceReferences(Marshaller.class, "(kura.service.pid=org.eclipse.kura.xml.marshaller.unmarshaller.provider)").iterator().next();
                marshaller = (Marshaller)context.getService(marshallerRef);
                string = marshaller.marshal((Object)configs);
                if (marshaller == null) break block5;
            }
            catch (Exception e) {
                try {
                    throw new GwtKuraException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (marshaller != null) {
                        context.ungetService(marshallerRef);
                    }
                    throw throwable;
                }
            }
            context.ungetService(marshallerRef);
        }
        return string;
    }

    private Set<String> findReferencedDrivers(List<ComponentConfiguration> configs) {
        return configs.stream().map(config -> {
            Map configurationProperties = config.getConfigurationProperties();
            if (configurationProperties == null) {
                return null;
            }
            if (!WIRE_ASSET_FACTORY_PID.equals(configurationProperties.get("service.factoryPid"))) {
                return null;
            }
            Object driverPid = configurationProperties.get(AssetConstants.ASSET_DRIVER_PROP.value());
            if (!(driverPid instanceof String)) {
                return null;
            }
            return (String)driverPid;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        KuraRemoteServiceServlet.requirePermissions(request, RequiredPermissions.Mode.ALL, new String[]{"kura.wires.admin"});
        try {
            GwtXSRFToken token = new GwtXSRFToken(request.getParameter("xsrfToken"));
            KuraRemoteServiceServlet.checkXSRFToken(request, token);
        }
        catch (Exception e) {
            throw new ServletException("Security error: please retry this operation correctly.", (Throwable)e);
        }
        try {
            ArrayList<ComponentConfiguration> result = new ArrayList<ComponentConfiguration>();
            ServiceLocator.applyToServiceOptionally(CryptoService.class, cryptoService -> {
                ServiceLocator.applyToServiceOptionally(WireGraphService.class, wireGraphService -> {
                    wireGraphService.get().getWireComponentConfigurations().stream().map(WireComponentConfiguration::getConfiguration).map(config -> WiresSnapshotServlet.removeDefinition(WiresSnapshotServlet.processPasswords(config, cryptoService))).forEach(result::add);
                    return null;
                });
                Set<String> driverPids = this.findReferencedDrivers(result);
                ServiceLocator.applyToServiceOptionally(ConfigurationService.class, configurationService -> {
                    configurationService.getComponentConfigurations().stream().filter(config -> driverPids.contains(config.getPid())).map(config -> WiresSnapshotServlet.removeDefinition(WiresSnapshotServlet.processPasswords(config, cryptoService))).forEach(result::add);
                    result.add(WiresSnapshotServlet.removeDefinition(configurationService.getComponentConfiguration(WIRE_GRAPH_SERVICE_PID)));
                    return null;
                });
                return null;
            });
            GwtServerUtil.writeSnapshot(request, response, result, "graph_snapshot_" + System.currentTimeMillis());
        }
        catch (Exception e) {
            logger.warn("Failed to download snapshot", (Throwable)e);
            throw new ServletException("Failed to download snapshot");
        }
    }

    private static ComponentConfiguration processPasswords(ComponentConfiguration config, CryptoService cryptoService) {
        HashMap newProperties = new HashMap(config.getConfigurationProperties());
        for (Map.Entry entry : newProperties.entrySet()) {
            try {
                Object value = entry.getValue();
                if (value instanceof Password) {
                    entry.setValue(WiresSnapshotServlet.decrypt((Password)value, cryptoService));
                    continue;
                }
                if (!(value instanceof Password[])) continue;
                entry.setValue(WiresSnapshotServlet.decrypt((Password[])value, cryptoService));
            }
            catch (Exception e) {
                logger.warn("failed to process property", (Throwable)e);
            }
        }
        return new ComponentConfigurationImpl(config.getPid(), (Tocd)config.getDefinition(), newProperties);
    }

    private static Password decrypt(Password password, CryptoService cryptoService) throws KuraException {
        return new Password(cryptoService.decryptAes(password.getPassword()));
    }

    private static Password[] decrypt(Password[] passwords, CryptoService cryptoService) throws KuraException {
        Password[] result = new Password[passwords.length];
        int i = 0;
        while (i < passwords.length) {
            result[i] = WiresSnapshotServlet.decrypt(passwords[i], cryptoService);
            ++i;
        }
        return result;
    }

    private static ComponentConfiguration removeDefinition(ComponentConfiguration config) {
        return new ComponentConfigurationImpl(config.getPid(), null, config.getConfigurationProperties());
    }
}

