/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.eclipse.kura.web.shared.model.GwtUserData;

public class GwtUserConfig
extends GwtUserData {
    private static final String PASSWORD_ENABLED_KEY = "password.enabled";
    private static final String PASSWORD_KEY = "password";
    private static final String PASSWORD_CHANGE_NEEDED_KEY = "password.change.needed";
    private static final long serialVersionUID = 8795619406606205153L;
    private Map<String, GwtConfigComponent> additionalConfigurations;

    public GwtUserConfig() {
    }

    public GwtUserConfig(String userName, Set<String> permissions, Map<String, GwtConfigComponent> additionalConfigurations, boolean isPasswordAuthEnabled, boolean isPasswordChangeNeeded) {
        super(userName, permissions);
        this.setPasswordAuthEnabled(isPasswordAuthEnabled);
        this.setPasswordChangeNeeded(isPasswordChangeNeeded);
        this.setAdditionalConfigurations(additionalConfigurations);
    }

    public boolean isPasswordAuthEnabled() {
        return (Boolean)this.get(PASSWORD_ENABLED_KEY);
    }

    public void setPasswordAuthEnabled(boolean enabled) {
        this.set(PASSWORD_ENABLED_KEY, enabled);
    }

    public void setNewPassword(Optional<String> password) {
        if (password.isPresent()) {
            this.set(PASSWORD_KEY, password.get());
        } else {
            this.set(PASSWORD_KEY, null);
        }
    }

    public Optional<String> getNewPassword() {
        return Optional.ofNullable((String)this.get(PASSWORD_KEY));
    }

    public boolean isPasswordChangeNeeded() {
        return Optional.ofNullable((Boolean)this.get(PASSWORD_CHANGE_NEEDED_KEY)).orElse(false);
    }

    public void setPasswordChangeNeeded(boolean isPasswordChangeNeeded) {
        this.set(PASSWORD_CHANGE_NEEDED_KEY, isPasswordChangeNeeded);
    }

    public Map<String, GwtConfigComponent> getAdditionalConfigurations() {
        return this.additionalConfigurations;
    }

    public void setAdditionalConfigurations(Map<String, GwtConfigComponent> additionalConfigurations) {
        this.additionalConfigurations = additionalConfigurations;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.isPasswordAuthEnabled(), this.getNewPassword());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GwtUserConfig other = (GwtUserConfig)obj;
        return this.isPasswordAuthEnabled() == other.isPasswordAuthEnabled() && Objects.equals(this.getNewPassword(), other.getNewPassword());
    }
}

