/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.shared.model;

import java.util.Map;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;

public class GwtWifiNetInterfaceConfig
extends GwtNetInterfaceConfig {
    private static final long serialVersionUID = -7509149975400963837L;
    private GwtWifiConfig m_adhocWifiConfig;
    private GwtWifiConfig m_stationWifiConfig;
    private GwtWifiConfig m_accessPointWifiConfig;

    public GwtWifiNetInterfaceConfig() {
        this.m_adhocWifiConfig = new GwtWifiConfig();
        this.m_stationWifiConfig = new GwtWifiConfig();
        this.m_accessPointWifiConfig = new GwtWifiConfig();
        this.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
    }

    public GwtWifiNetInterfaceConfig(GwtWifiConfig adhocConfig, GwtWifiConfig stationConfig, GwtWifiConfig accessPointConfig) {
        this.m_adhocWifiConfig = adhocConfig;
        this.m_stationWifiConfig = stationConfig;
        this.m_accessPointWifiConfig = accessPointConfig;
        this.setWirelessMode(GwtWifiWirelessMode.netWifiWirelessModeStation.name());
    }

    public void setAdhocWifiConfig(GwtWifiConfig adhocConfig) {
        this.m_adhocWifiConfig = adhocConfig;
    }

    public void setAdhocWifiConfig(Map<String, Object> properties) {
        this.m_adhocWifiConfig = new GwtWifiConfig();
        this.m_adhocWifiConfig.setProperties(properties);
    }

    public GwtWifiConfig getAdhocWifiConfig() {
        return this.m_adhocWifiConfig;
    }

    public Map<String, Object> getAdhocWifiConfigProps() {
        return this.m_adhocWifiConfig.getProperties();
    }

    public void setStationWifiConfig(GwtWifiConfig stationConfig) {
        this.m_stationWifiConfig = stationConfig;
    }

    public void setStationWifiConfig(Map<String, Object> properties) {
        this.m_stationWifiConfig = new GwtWifiConfig();
        this.m_stationWifiConfig.setProperties(properties);
    }

    public GwtWifiConfig getStationWifiConfig() {
        return this.m_stationWifiConfig;
    }

    public Map<String, Object> getStationWifiConfigProps() {
        return this.m_stationWifiConfig.getProperties();
    }

    public void setAccessPointWifiConfig(GwtWifiConfig accessPointConfig) {
        this.m_accessPointWifiConfig = accessPointConfig;
    }

    public void setAccessPointWifiConfig(Map<String, Object> properties) {
        this.m_accessPointWifiConfig = new GwtWifiConfig();
        this.m_accessPointWifiConfig.setProperties(properties);
    }

    public GwtWifiConfig getAccessPointWifiConfig() {
        return this.m_accessPointWifiConfig;
    }

    public Map<String, Object> getAccessPointWifiConfigProps() {
        return this.m_accessPointWifiConfig.getProperties();
    }

    public void setWifiConfig(GwtWifiConfig wifiConfig) {
        GwtWifiWirelessMode wifiMode = wifiConfig.getWirelessModeEnum();
        if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeAccessPoint)) {
            this.setAccessPointWifiConfig(wifiConfig);
        } else if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeAdHoc)) {
            this.setAdhocWifiConfig(wifiConfig);
        } else if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeStation)) {
            this.setStationWifiConfig(wifiConfig);
        }
    }

    public GwtWifiConfig getActiveWifiConfig() {
        GwtWifiWirelessMode wifiMode = this.getWirelessModeEnum();
        GwtWifiConfig activeConfig = new GwtWifiConfig();
        activeConfig.setWirelessMode(wifiMode.name());
        if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeAccessPoint)) {
            activeConfig = this.m_accessPointWifiConfig;
        } else if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeAdHoc)) {
            activeConfig = this.m_adhocWifiConfig;
        } else if (wifiMode.equals((Object)GwtWifiWirelessMode.netWifiWirelessModeStation)) {
            activeConfig = this.m_stationWifiConfig;
        }
        return activeConfig;
    }

    public void setWirelessMode(String wirelessMode) {
        this.set("wirelessMode", wirelessMode);
    }

    public String getWirelessMode() {
        return (String)this.get("wirelessMode");
    }

    public GwtWifiWirelessMode getWirelessModeEnum() {
        return GwtWifiWirelessMode.valueOf(this.getWirelessMode());
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof GwtWifiNetInterfaceConfig)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GwtWifiNetInterfaceConfig other = (GwtWifiNetInterfaceConfig)o;
        return this.compare(this.getActiveWifiConfig(), other.getActiveWifiConfig());
    }

    private boolean compare(Object obj1, Object obj2) {
        if (obj1 == null) {
            return obj2 == null;
        }
        return obj1.equals(obj2);
    }
}

