/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.linux.executor.unprivileged;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.commons.io.Charsets;
import org.eclipse.kura.core.internal.linux.executor.ExecutorUtil;
import org.eclipse.kura.core.linux.executor.LinuxExitStatus;
import org.eclipse.kura.core.linux.executor.LinuxSignal;
import org.eclipse.kura.executor.Command;
import org.eclipse.kura.executor.CommandStatus;
import org.eclipse.kura.executor.ExitStatus;
import org.eclipse.kura.executor.Pid;
import org.eclipse.kura.executor.Signal;
import org.eclipse.kura.executor.UnprivilegedExecutorService;
import org.eclipse.kura.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnprivilegedExecutorServiceImpl
implements UnprivilegedExecutorService {
    private static final Logger logger = LoggerFactory.getLogger(UnprivilegedExecutorServiceImpl.class);
    private static final LinuxSignal DEFAULT_SIGNAL = LinuxSignal.SIGTERM;
    private SystemService systemService;
    private ExecutorUtil executorUtil;

    public void setSystemService(SystemService systemService) {
        this.systemService = systemService;
    }

    public void unsetSystemService(SystemService systemService) {
        if (this.systemService == systemService) {
            this.systemService = null;
        }
    }

    protected void activate() {
        logger.info("activate...");
        String user = this.systemService.getCommandUser();
        this.executorUtil = user == null || user.equals("unknown") ? new ExecutorUtil() : new ExecutorUtil(user);
    }

    protected void deactivate() {
        logger.info("deactivate...");
    }

    public CommandStatus execute(Command command) {
        if (command.getCommandLine() == null || command.getCommandLine().length == 0) {
            return this.buildErrorStatus(command);
        }
        if (command.getSignal() == null) {
            command.setSignal((Signal)DEFAULT_SIGNAL);
        }
        return this.executorUtil.executeUnprivileged(command);
    }

    public void execute(Command command, Consumer<CommandStatus> callback) {
        if (command.getCommandLine() == null || command.getCommandLine().length == 0) {
            callback.accept(this.buildErrorStatus(command));
            return;
        }
        if (command.getSignal() == null) {
            command.setSignal((Signal)DEFAULT_SIGNAL);
        }
        this.executorUtil.executeUnprivileged(command, callback);
    }

    public boolean stop(Pid pid, Signal signal) {
        boolean isStopped = false;
        isStopped = signal == null ? this.executorUtil.stopUnprivileged(pid, DEFAULT_SIGNAL) : this.executorUtil.stopUnprivileged(pid, signal);
        return isStopped;
    }

    public boolean kill(String[] commandLine, Signal signal) {
        boolean isKilled = false;
        isKilled = signal == null ? this.executorUtil.killUnprivileged(commandLine, DEFAULT_SIGNAL) : this.executorUtil.killUnprivileged(commandLine, signal);
        return isKilled;
    }

    public boolean isRunning(Pid pid) {
        return this.executorUtil.isRunning(pid);
    }

    public boolean isRunning(String[] commandLine) {
        return this.executorUtil.isRunning(commandLine);
    }

    public Map<String, Pid> getPids(String[] commandLine) {
        return this.executorUtil.getPids(commandLine);
    }

    private CommandStatus buildErrorStatus(Command command) {
        CommandStatus status = new CommandStatus(command, (ExitStatus)new LinuxExitStatus(1));
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        try {
            err.write("The commandLine cannot be empty or not defined".getBytes(Charsets.UTF_8));
        }
        catch (IOException e) {
            logger.error("Cannot write to error stream", (Throwable)e);
        }
        status.setErrorStream((OutputStream)err);
        return status;
    }
}

