/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.core.identity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.kura.KuraErrorCode;
import org.eclipse.kura.KuraException;
import org.eclipse.kura.identity.PasswordStrengthVerificationService;

public class ValidationUtil {
    private static final String NEW_PASSWORD = "New password";
    private static final String PERMISSION_NAME = "Permission name";
    private static final String IDENTITY_NAME = "Identity name";

    private ValidationUtil() {
    }

    public static void validateNewPassword(char[] password, PasswordStrengthVerificationService passwordStrengthVerificationService) throws KuraException {
        if (password.length == 0) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{"New password cannot be empty"});
        }
        String asString = new String(password);
        ValidationUtil.requireMaximumLength(NEW_PASSWORD, asString, 255);
        ValidationUtil.requireNoWhitespaceCharacters(NEW_PASSWORD, asString);
        passwordStrengthVerificationService.checkPasswordStrength(password);
    }

    public static void validateNewIdentityName(String identityName) throws KuraException {
        ValidationUtil.requireMinimumLength(IDENTITY_NAME, identityName, 3);
        ValidationUtil.requireMaximumLength(IDENTITY_NAME, identityName, 255);
        new PunctuatedAlphanumericSequenceValidator(IDENTITY_NAME, Arrays.asList(Character.valueOf('.'), Character.valueOf('_'))).validate(identityName);
    }

    public static void validateNewPermissionName(String permissionName) throws KuraException {
        ValidationUtil.requireMinimumLength(PERMISSION_NAME, permissionName, 3);
        ValidationUtil.requireMaximumLength(PERMISSION_NAME, permissionName, 255);
        new PunctuatedAlphanumericSequenceValidator(PERMISSION_NAME, Collections.singletonList(Character.valueOf('.'))).validate(permissionName);
    }

    private static void requireMinimumLength(String parameterName, String value, int length) throws KuraException {
        if (value.length() < length) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{String.valueOf(parameterName) + " name must be at least " + length + " characters long"});
        }
    }

    private static void requireMaximumLength(String parameterName, String value, int length) throws KuraException {
        if (value.length() > length) {
            throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{String.valueOf(parameterName) + " must be at most " + length + " characters long"});
        }
    }

    private static void requireNoWhitespaceCharacters(String parameterName, String value) throws KuraException {
        int i = 0;
        while (i < value.length()) {
            if (Character.isWhitespace(value.codePointAt(i))) {
                throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{String.valueOf(parameterName) + " cannot contain whitespace characters"});
            }
            ++i;
        }
    }

    private static class PunctuatedAlphanumericSequenceValidator {
        private final String parameterName;
        private final List<Character> delimiters;
        private static final Pattern ALPHANUMERIC_PATTERN = Pattern.compile("[a-zA-Z0-9]+");

        public PunctuatedAlphanumericSequenceValidator(String parameterName, List<Character> delimiters) {
            this.parameterName = parameterName;
            this.delimiters = delimiters;
        }

        private boolean isDelimiter(char value) {
            for (char delimiter : this.delimiters) {
                if (value != delimiter) continue;
                return true;
            }
            return false;
        }

        private void requireNonEmptyAlphanumericString(String value) throws KuraException {
            if (!ALPHANUMERIC_PATTERN.matcher(value).matches()) {
                throw new KuraException(KuraErrorCode.INVALID_PARAMETER, new Object[]{String.valueOf(this.parameterName) + " must be composed of one or more non empty alphanumeric characters sequences separated by the following characters: " + this.delimiters.stream().map(c -> "'" + c + "'").collect(Collectors.joining(" "))});
            }
        }

        public void validate(String value) throws KuraException {
            if (value.isEmpty()) {
                return;
            }
            StringBuilder component = new StringBuilder();
            int i = 0;
            while (i < value.length()) {
                char c = value.charAt(i);
                if (this.isDelimiter(c)) {
                    this.requireNonEmptyAlphanumericString(component.toString());
                    component.setLength(0);
                } else {
                    component.append(c);
                }
                ++i;
            }
            this.requireNonEmptyAlphanumericString(component.toString());
        }
    }
}

