/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.auth;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Optional;
import javax.annotation.Priority;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.container.ContainerRequestContext;
import org.eclipse.kura.audit.AuditConstants;
import org.eclipse.kura.audit.AuditContext;
import org.eclipse.kura.rest.auth.AuthenticationProvider;
import org.eclipse.kura.util.useradmin.UserAdminHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=100)
public class CertificateAuthenticationProvider
implements AuthenticationProvider {
    private final UserAdminHelper userAdminHelper;
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"AuditLogger");

    public CertificateAuthenticationProvider(UserAdminHelper userAdminHelper) {
        this.userAdminHelper = userAdminHelper;
    }

    @Override
    public Optional<Principal> authenticate(HttpServletRequest request, ContainerRequestContext requestContext) {
        return this.authenticate(requestContext, "Certificate Authentication");
    }

    public Optional<Principal> authenticate(ContainerRequestContext requestContext, String auditAuthenticationKind) {
        AuditContext auditContext = AuditContext.currentOrInternal();
        try {
            Principal principal = this.authenticate(requestContext);
            auditLogger.info("{} Rest - Success - {} succeeded", (Object)auditContext, (Object)auditAuthenticationKind);
            return Optional.of(principal);
        }
        catch (CertificateAuthException e) {
            if (e.getReason() == CertificateAuthException.Reason.IDENTITY_NOT_FOUND) {
                auditLogger.warn("{} Rest - Failure - {} failed", (Object)auditContext, (Object)auditAuthenticationKind);
            }
            return Optional.empty();
        }
    }

    public Principal authenticate(ContainerRequestContext requestContext) throws CertificateAuthException {
        AuditContext auditContext = AuditContext.currentOrInternal();
        try {
            Object clientCertificatesRaw = requestContext.getProperty("javax.servlet.request.X509Certificate");
            if (!(clientCertificatesRaw instanceof X509Certificate[])) {
                throw new CertificateAuthException(CertificateAuthException.Reason.CLIENT_CERTIFICATE_CHAIN_MISSING);
            }
            X509Certificate[] clientCertificates = (X509Certificate[])clientCertificatesRaw;
            if (clientCertificates.length == 0) {
                throw new CertificateAuthException(CertificateAuthException.Reason.CLIENT_CERTIFICATE_CHAIN_MISSING);
            }
            LdapName ldapName = new LdapName(clientCertificates[0].getSubjectX500Principal().getName());
            Optional<Rdn> commonNameRdn = ldapName.getRdns().stream().filter(r -> "cn".equalsIgnoreCase(r.getType())).findAny();
            if (!commonNameRdn.isPresent()) {
                throw new CertificateAuthException(CertificateAuthException.Reason.MISSING_COMMON_NAME);
            }
            String commonName = (String)commonNameRdn.get().getValue();
            auditContext.getProperties().put(AuditConstants.KEY_IDENTITY.getValue(), commonName);
            if (this.userAdminHelper.getUser(commonName).isPresent()) {
                return () -> commonName;
            }
            throw new CertificateAuthException(CertificateAuthException.Reason.IDENTITY_NOT_FOUND);
        }
        catch (CertificateAuthException e) {
            throw e;
        }
        catch (Exception exception) {
            throw new CertificateAuthException(CertificateAuthException.Reason.UNEXPECTED_ERROR);
        }
    }

    @Override
    public void onEnabled() {
    }

    @Override
    public void onDisabled() {
    }

    public static class CertificateAuthException
    extends Exception {
        private final Reason reason;

        public CertificateAuthException(Reason reason) {
            this.reason = reason;
        }

        public Reason getReason() {
            return this.reason;
        }

        public static enum Reason {
            CLIENT_CERTIFICATE_CHAIN_MISSING,
            MISSING_COMMON_NAME,
            IDENTITY_NOT_FOUND,
            UNEXPECTED_ERROR;

        }
    }
}

