/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.internal.rest.service.listing.provider;

import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.eclipse.kura.cloudconnection.request.RequestHandler;
import org.eclipse.kura.cloudconnection.request.RequestHandlerRegistry;
import org.eclipse.kura.configuration.ConfigurationService;
import org.eclipse.kura.internal.rest.service.listing.provider.dto.FilterDTO;
import org.eclipse.kura.internal.rest.service.listing.provider.dto.InterfaceNamesDTO;
import org.eclipse.kura.internal.rest.service.listing.provider.dto.RefDTO;
import org.eclipse.kura.internal.rest.service.listing.provider.util.FilterBuilder;
import org.eclipse.kura.request.handler.jaxrs.DefaultExceptionHandler;
import org.eclipse.kura.request.handler.jaxrs.JaxRsRequestHandlerProxy;
import org.eclipse.kura.rest.configuration.api.PidSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.service.component.runtime.dto.ComponentDescriptionDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="serviceListing/v1")
public class RestServiceListingProvider {
    private static final String OBJECT_CLASS = "objectClass";
    private static final Logger logger = LoggerFactory.getLogger(RestServiceListingProvider.class);
    private static final String APP_ID_MQTT = "SVCLIST-V1";
    private static final String KURA_SERVICE_PID = "kura.service.pid";
    private final RequestHandler requestHandler = new JaxRsRequestHandlerProxy((Object)this);
    private ConfigurationService configurationService;
    private ServiceComponentRuntime scr;
    private BundleContext bundleContext;

    public void bindRequestHandlerRegistry(RequestHandlerRegistry bindingRegistry) {
        try {
            bindingRegistry.registerRequestHandler(APP_ID_MQTT, this.requestHandler);
        }
        catch (Exception e) {
            logger.warn("Failed to register {} request handler", (Object)APP_ID_MQTT, (Object)e);
        }
    }

    public void unbindRequestHandlerRegistry(RequestHandlerRegistry unbindingRegistry) {
        try {
            unbindingRegistry.unregister(APP_ID_MQTT);
        }
        catch (Exception e) {
            logger.warn("Failed to unregister {} request handler", (Object)APP_ID_MQTT, (Object)e);
        }
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setServiceComponentRuntime(ServiceComponentRuntime scr) {
        this.scr = scr;
    }

    public void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
    }

    @GET
    @Path(value="/servicePids")
    @Produces(value={"application/json"})
    public PidSet getServicePids(@Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            List<ServiceReference<?>> servicesList = Arrays.asList(this.bundleContext.getServiceReferences(null, null));
            return new PidSet(this.getServicePids(servicesList));
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @POST
    @Path(value="/servicePids/byInterface")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PidSet getServicePidsByInterface(InterfaceNamesDTO interfacesList, @Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            interfacesList.validate();
            return new PidSet(this.getServicesProvidingInterfaces(interfacesList.getInterfacesIds()));
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @POST
    @Path(value="/servicePids/byProperty")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PidSet getServicePidsByFilter(FilterDTO filter, @Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            filter.validate();
            return new PidSet(this.getServicesMatchingFilter(filter.toOSGIFilter()));
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @POST
    @Path(value="/servicePids/satisfyingReference")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public PidSet getServicePidsSatisfyingReference(RefDTO ref, @Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            ref.validate();
            String componentName = this.getComponentNameFromPid(ref.getPid()).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            String targetRef = ref.getReferenceName();
            String referenceInterface = this.getReferenceInterface(componentName, targetRef).orElseThrow(() -> new WebApplicationException(Response.Status.NOT_FOUND));
            Set<String> pids = this.getServicesProvidingInterfaces(Collections.singleton(referenceInterface));
            return new PidSet(pids);
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @GET
    @Path(value="/factoryPids")
    @Produces(value={"application/json"})
    public PidSet getFactoryPids(@Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            return new PidSet(this.configurationService.getFactoryComponentPids());
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @POST
    @Path(value="/factoryPids/byInterface")
    @Produces(value={"application/json"})
    public PidSet getFactoryPidsByInterface(InterfaceNamesDTO interfacesList, @Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            interfacesList.validate();
            Set result = this.getFactoryComponentDescriptors().filter(component -> Arrays.asList(component.serviceInterfaces).containsAll(interfacesList.getInterfacesIds())).map(component -> component.name).collect(Collectors.toSet());
            return new PidSet(result);
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    @POST
    @Path(value="/factoryPids/byProperty")
    @Produces(value={"application/json"})
    public PidSet getFactoryPidsByFilter(FilterDTO filter, @Context ContainerRequestContext requestContext) {
        try {
            this.expectAuthenticatedUser(requestContext);
            filter.validate();
            Filter osgiFilter = FrameworkUtil.createFilter((String)filter.toOSGIFilter());
            Set result = this.getFactoryComponentDescriptors().filter(component -> {
                HashMap<String, String[]> properties = new HashMap<String, String[]>(component.properties);
                if (component.serviceInterfaces.length != 0) {
                    properties.put(OBJECT_CLASS, component.serviceInterfaces);
                }
                return osgiFilter.matches(properties);
            }).map(component -> component.name).collect(Collectors.toSet());
            return new PidSet(result);
        }
        catch (Exception ex) {
            throw DefaultExceptionHandler.toWebApplicationException((Throwable)ex);
        }
    }

    private void expectAuthenticatedUser(ContainerRequestContext requestContext) {
        if (requestContext != null && !this.getPrincipal(requestContext).isPresent()) {
            throw new WebApplicationException(Response.Status.UNAUTHORIZED);
        }
    }

    private Optional<Principal> getPrincipal(ContainerRequestContext containerRequestContext) {
        return Optional.ofNullable(containerRequestContext.getSecurityContext()).flatMap(entry -> Optional.ofNullable(entry.getUserPrincipal()));
    }

    private Set<String> getServicesProvidingInterfaces(Set<String> interfacesIds) throws InvalidSyntaxException {
        String filter = new FilterBuilder().and(f -> interfacesIds.forEach(i -> {
            FilterBuilder filterBuilder2 = f.property(OBJECT_CLASS, (String)i);
        })).build();
        return this.getServicesMatchingFilter(filter);
    }

    private Set<String> getServicesMatchingFilter(String filter) throws InvalidSyntaxException {
        List servicesList = Optional.ofNullable(this.bundleContext.getServiceReferences(null, filter)).map(serviceReferenceArray -> Arrays.asList(serviceReferenceArray)).orElseGet(Collections::emptyList);
        return this.getServicePids(servicesList);
    }

    private Set<String> getServicePids(List<ServiceReference<?>> references) {
        return references.stream().filter(s -> s.getProperty(KURA_SERVICE_PID) instanceof String).map(s -> (String)s.getProperty(KURA_SERVICE_PID)).collect(Collectors.toSet());
    }

    private Optional<String> getComponentNameFromPid(String pid) {
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(null, "(kura.service.pid=" + pid + ")");
            if (refs == null || refs.length == 0) {
                return Optional.empty();
            }
            ServiceReference ref = refs[0];
            String result = Optional.ofNullable(ref.getProperty("service.factoryPid")).flatMap(s -> s instanceof String ? Optional.of((String)s) : Optional.empty()).orElse(pid);
            return Optional.of(result);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            logger.warn("bad pid name: {}", (Object)pid);
            return Optional.empty();
        }
    }

    private Optional<String> getReferenceInterface(String componentName, String targetRef) {
        return this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(componentDescription -> componentDescription.name.equals(componentName)).findAny().flatMap(componentDescription -> Arrays.stream(componentDescription.references).filter(reference -> targetRef.equals(reference.name)).findAny().map(reference -> reference.interfaceName));
    }

    private Stream<ComponentDescriptionDTO> getFactoryComponentDescriptors() {
        Set factories = this.configurationService.getFactoryComponentPids();
        return this.scr.getComponentDescriptionDTOs(new Bundle[0]).stream().filter(s -> factories.contains(s.name));
    }
}

