/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants;

import java.util.HashMap;
import java.util.Map;
import org.apache.xerces.xni.XMLLocator;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.extensions.contentmodel.participants.codeactions.ElementDeclUnterminatedCodeAction;
import org.eclipse.lemminx.services.extensions.ICodeActionParticipant;
import org.eclipse.lemminx.services.extensions.diagnostics.IXMLErrorCode;
import org.eclipse.lemminx.utils.StringUtils;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public enum DTDErrorCode implements IXMLErrorCode
{
    AttNameRequiredInAttDef,
    AttTypeRequiredInAttDef,
    ElementDeclUnterminated,
    EntityDeclUnterminated,
    EntityNotDeclared,
    ExternalIDorPublicIDRequired,
    IDInvalidWithNamespaces,
    IDREFInvalidWithNamespaces,
    IDREFSInvalid,
    LessthanInAttValue,
    MSG_ATTRIBUTE_NOT_DECLARED,
    MSG_ATTRIBUTE_VALUE_NOT_IN_LIST,
    MSG_CONTENT_INCOMPLETE,
    MSG_CONTENT_INVALID,
    MSG_ELEMENT_ALREADY_DECLARED,
    MSG_ELEMENT_NOT_DECLARED,
    MSG_ELEMENT_TYPE_REQUIRED_IN_ATTLISTDECL,
    MSG_ELEMENT_TYPE_REQUIRED_IN_ELEMENTDECL,
    MSG_ELEMENT_WITH_ID_REQUIRED,
    MSG_ENTITY_NAME_REQUIRED_IN_ENTITYDECL,
    MSG_FIXED_ATTVALUE_INVALID,
    MSG_MARKUP_NOT_RECOGNIZED_IN_DTD,
    MSG_NOTATION_NAME_REQUIRED_IN_NOTATIONDECL,
    MSG_OPEN_PAREN_OR_ELEMENT_TYPE_REQUIRED_IN_CHILDREN,
    MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED,
    MSG_SPACE_REQUIRED_AFTER_NOTATION_NAME_IN_NOTATIONDECL,
    NotationDeclUnterminated,
    OpenQuoteExpected,
    OpenQuoteMissingInDecl,
    PEReferenceWithinMarkup,
    QuoteRequiredInPublicID,
    QuoteRequiredInSystemID,
    SpaceRequiredAfterSYSTEM,
    dtd_not_found("dtd-not-found");

    private final String code;
    private static final Map<String, DTDErrorCode> codes;

    private DTDErrorCode() {
        this(null);
    }

    private DTDErrorCode(String code) {
        this.code = code;
    }

    @Override
    public String getCode() {
        if (this.code == null) {
            return this.name();
        }
        return this.code;
    }

    public static DTDErrorCode get(String name) {
        return codes.get(name);
    }

    public static Range toLSPRange(XMLLocator location, DTDErrorCode code, Object[] arguments, DOMDocument document) {
        int offset = location.getCharacterOffset() - 1;
        switch (code) {
            case MSG_CONTENT_INCOMPLETE: 
            case MSG_REQUIRED_ATTRIBUTE_NOT_SPECIFIED: 
            case MSG_ELEMENT_NOT_DECLARED: 
            case MSG_CONTENT_INVALID: {
                return XMLPositionUtility.selectStartTagName(offset, document);
            }
            case MSG_ATTRIBUTE_NOT_DECLARED: {
                return XMLPositionUtility.selectAttributeValueAt(StringUtils.getString(arguments[1]), offset, document);
            }
            case MSG_FIXED_ATTVALUE_INVALID: {
                String attrName = StringUtils.getString(arguments[1]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case MSG_ATTRIBUTE_VALUE_NOT_IN_LIST: {
                String attrName = StringUtils.getString(arguments[0]);
                return XMLPositionUtility.selectAttributeValueAt(attrName, offset, document);
            }
            case MSG_ELEMENT_WITH_ID_REQUIRED: {
                DOMElement element = document.getDocumentElement();
                if (element != null) {
                    return XMLPositionUtility.selectStartTagName(element);
                }
            }
            case IDREFSInvalid: 
            case IDREFInvalidWithNamespaces: 
            case IDInvalidWithNamespaces: {
                String attrValue = StringUtils.getString(arguments[0]);
                return XMLPositionUtility.selectAttributeValueByGivenValueAt(attrValue, offset, document);
            }
            case MSG_MARKUP_NOT_RECOGNIZED_IN_DTD: {
                return XMLPositionUtility.selectWholeTag(offset + 2, document);
            }
            case ExternalIDorPublicIDRequired: {
                return XMLPositionUtility.getLastValidDTDDeclParameter(offset, document);
            }
            case PEReferenceWithinMarkup: {
                return XMLPositionUtility.getLastValidDTDDeclParameter(offset, document, true);
            }
            case EntityNotDeclared: {
                try {
                    Position position = document.positionAt(offset);
                    int line = position.getLine();
                    String text = document.lineText(line);
                    String name = StringUtils.getString(arguments[0]);
                    String subString = "&" + name + ";";
                    int start = text.indexOf(subString);
                    int end = start + subString.length();
                    Position startPosition = new Position(line, start);
                    Position endPosition = new Position(line, end);
                    return new Range(startPosition, endPosition);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            case QuoteRequiredInPublicID: 
            case QuoteRequiredInSystemID: 
            case OpenQuoteMissingInDecl: 
            case SpaceRequiredAfterSYSTEM: 
            case MSG_SPACE_REQUIRED_AFTER_NOTATION_NAME_IN_NOTATIONDECL: 
            case AttTypeRequiredInAttDef: 
            case LessthanInAttValue: 
            case OpenQuoteExpected: 
            case AttNameRequiredInAttDef: 
            case EntityDeclUnterminated: 
            case NotationDeclUnterminated: 
            case ElementDeclUnterminated: {
                return XMLPositionUtility.getLastValidDTDDeclParameterOrUnrecognized(offset, document);
            }
            case MSG_OPEN_PAREN_OR_ELEMENT_TYPE_REQUIRED_IN_CHILDREN: {
                return XMLPositionUtility.getElementDeclMissingContentOrCategory(offset, document);
            }
            case MSG_ELEMENT_ALREADY_DECLARED: 
            case MSG_NOTATION_NAME_REQUIRED_IN_NOTATIONDECL: 
            case MSG_ENTITY_NAME_REQUIRED_IN_ENTITYDECL: 
            case MSG_ELEMENT_TYPE_REQUIRED_IN_ATTLISTDECL: 
            case MSG_ELEMENT_TYPE_REQUIRED_IN_ELEMENTDECL: {
                return XMLPositionUtility.selectDTDDeclTagNameAt(offset, document);
            }
        }
        try {
            return new Range(new Position(0, 0), document.positionAt(document.getEnd()));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public static void registerCodeActionParticipants(Map<String, ICodeActionParticipant> codeActions) {
        codeActions.put(ElementDeclUnterminated.getCode(), new ElementDeclUnterminatedCodeAction());
    }

    static {
        codes = new HashMap<String, DTDErrorCode>();
        for (DTDErrorCode errorCode : DTDErrorCode.values()) {
            codes.put(errorCode.getCode(), errorCode);
        }
    }
}

