/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import com.google.common.base.Objects;
import org.apache.xerces.impl.dtd.DTDGrammar;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.xni.grammars.Grammar;
import org.apache.xerces.xni.grammars.XMLGrammarDescription;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.eclipse.lemminx.extensions.contentmodel.model.FilesChangedTracker;
import org.eclipse.lemminx.extensions.dtd.utils.DTDUtils;
import org.eclipse.lemminx.extensions.xsd.utils.XSDUtils;

public class LSPXMLGrammarPool
implements XMLGrammarPool {
    private static final int TABLE_SIZE = 11;
    private final Entry[] fGrammars;

    public LSPXMLGrammarPool() {
        this(11);
    }

    public LSPXMLGrammarPool(int initialCapacity) {
        this.fGrammars = new Entry[initialCapacity];
    }

    public Grammar[] retrieveInitialGrammarSet(String grammarType) {
        return null;
    }

    public void cacheGrammars(String grammarType, Grammar[] grammars) {
        for (int i = 0; i < grammars.length; ++i) {
            this.putGrammar(grammars[i]);
        }
    }

    public Grammar retrieveGrammar(XMLGrammarDescription desc) {
        return this.getGrammar(desc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putGrammar(Grammar grammar) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            XMLGrammarDescription desc = grammar.getGrammarDescription();
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    entry.grammar = grammar;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
                entry = entry.next;
            }
            this.fGrammars[index] = entry = new Entry(hash, desc, grammar, this.fGrammars[index]);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grammar getGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    if (entry.isDirty()) {
                        this.removeGrammar(entry.desc);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return null;
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return entry.grammar;
                }
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Grammar removeGrammar(XMLGrammarDescription desc) {
        Entry[] entryArray = this.fGrammars;
        synchronized (this.fGrammars) {
            int hash = this.hashCode(desc);
            int index = (hash & Integer.MAX_VALUE) % this.fGrammars.length;
            Entry entry = this.fGrammars[index];
            Entry prev = null;
            while (entry != null) {
                if (entry.hash == hash && this.equals(entry.desc, desc)) {
                    if (prev != null) {
                        prev.next = entry.next;
                    } else {
                        this.fGrammars[index] = entry.next;
                    }
                    Grammar tempGrammar = entry.grammar;
                    entry.grammar = null;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return tempGrammar;
                }
                prev = entry;
                entry = entry.next;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    public void lockPool() {
    }

    public void unlockPool() {
    }

    public void clear() {
        for (int i = 0; i < this.fGrammars.length; ++i) {
            if (this.fGrammars[i] == null) continue;
            this.fGrammars[i].clear();
            this.fGrammars[i] = null;
        }
    }

    public boolean equals(XMLGrammarDescription desc1, XMLGrammarDescription desc2) {
        String systemId1 = desc1.getExpandedSystemId();
        String systemId2 = desc2.getExpandedSystemId();
        if (systemId1 != null && systemId2 != null) {
            return Objects.equal((Object)systemId1, (Object)systemId2);
        }
        return false;
    }

    public int hashCode(XMLGrammarDescription desc) {
        return desc.hashCode();
    }

    protected static final class Entry {
        public int hash;
        public XMLGrammarDescription desc;
        public Grammar grammar;
        public Entry next;
        private final FilesChangedTracker tracker;

        protected Entry(int hash, XMLGrammarDescription desc, Grammar grammar, Entry next) {
            this.hash = hash;
            this.desc = desc;
            this.grammar = grammar;
            this.next = next;
            this.tracker = Entry.create(grammar);
        }

        private static FilesChangedTracker create(Grammar grammar) {
            if (grammar instanceof SchemaGrammar) {
                return XSDUtils.createFilesChangedTracker((SchemaGrammar)grammar);
            }
            if (grammar instanceof DTDGrammar) {
                return DTDUtils.createFilesChangedTracker((DTDGrammar)grammar);
            }
            return null;
        }

        public boolean isDirty() {
            return this.tracker != null ? this.tracker.isDirty() : true;
        }

        protected void clear() {
            this.desc = null;
            this.grammar = null;
            if (this.next != null) {
                this.next.clear();
                this.next = null;
            }
        }
    }
}

