/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd.participants.diagnostics;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.xerces.impl.dtd.XMLDTDLoader;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class DTDValidator {
    public static void doDiagnostics(DOMDocument document, XMLEntityResolver entityResolver, List<Diagnostic> diagnostics, CancelChecker monitor) {
        try {
            XMLDTDLoader loader = new XMLDTDLoader();
            loader.setProperty("http://apache.org/xml/properties/internal/error-reporter", (Object)new LSPErrorReporterForXML(document, diagnostics));
            if (entityResolver != null) {
                loader.setEntityResolver(entityResolver);
            }
            String content = document.getText();
            String uri = document.getDocumentURI();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
            XMLInputSource source = new XMLInputSource(null, uri, uri, (InputStream)inputStream, null);
            loader.loadGrammar(source);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

