/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.impl.dtd.XMLDTDValidator;
import org.apache.xerces.util.SecurityManager;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentSource;
import org.eclipse.lemminx.extensions.contentmodel.participants.diagnostics.LSPErrorReporterForXML;
import org.eclipse.lemminx.extensions.contentmodel.settings.XMLValidationSettings;
import org.eclipse.lemminx.extensions.xerces.AbstractLSPErrorReporter;
import org.eclipse.lemminx.extensions.xerces.ExternalXMLDTDValidator;
import org.eclipse.lemminx.extensions.xerces.xmlmodel.XMLModelAwareParserConfiguration;

class LSPXMLParserConfiguration
extends XMLModelAwareParserConfiguration {
    private static final Logger LOGGER = Logger.getLogger(LSPXMLParserConfiguration.class.getName());
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String ENTITY_EXPANSION_LIMIT_PROPERTY_NAME = "jdk.xml.entityExpansionLimit";
    private static final String MAX_OCCUR_LIMIT_PROPERTY_NAME = "jdk.xml.maxOccur";
    private static final int ENTITY_EXPANSION_LIMIT_DEFAULT_VALUE = 64000;
    private static final int MAX_OCCUR_LIMIT_DEFAULT_VALUE = 5000;
    private final boolean disableDTDValidation;
    private ExternalXMLDTDValidator externalDTDValidator;

    public LSPXMLParserConfiguration(XMLGrammarPool grammarPool, boolean disableDTDValidation, LSPErrorReporterForXML reporterForXML, LSPErrorReporterForXML reporterForGrammar, XMLValidationSettings validationSettings) {
        super(null, grammarPool, reporterForGrammar);
        this.disableDTDValidation = disableDTDValidation;
        boolean disallowDocTypeDecl = validationSettings != null ? validationSettings.isDisallowDocTypeDecl() : false;
        super.setFeature("http://apache.org/xml/features/disallow-doctype-decl", disallowDocTypeDecl);
        boolean resolveExternalEntities = validationSettings != null ? validationSettings.isResolveExternalEntities() : false;
        super.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
        super.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
        SecurityManager securityManager = new SecurityManager();
        securityManager.setEntityExpansionLimit(LSPXMLParserConfiguration.getPropertyValue(ENTITY_EXPANSION_LIMIT_PROPERTY_NAME, 64000));
        securityManager.setMaxOccurNodeLimit(LSPXMLParserConfiguration.getPropertyValue(MAX_OCCUR_LIMIT_PROPERTY_NAME, 5000));
        super.setProperty(SECURITY_MANAGER, (Object)securityManager);
        this.fErrorReporter = reporterForXML;
    }

    protected void reset() throws XNIException {
        super.reset();
        if (this.disableDTDValidation) {
            this.disableDTDValidation();
        }
    }

    private void disableDTDValidation() {
        XMLDTDValidator validator = (XMLDTDValidator)super.getProperty("http://apache.org/xml/properties/internal/validator/dtd");
        if (validator != null) {
            XMLComponentManager disableDTDComponent = new XMLComponentManager(){

                public Object getProperty(String propertyId) throws XMLConfigurationException {
                    return LSPXMLParserConfiguration.this.getProperty(propertyId);
                }

                public boolean getFeature(String featureId) throws XMLConfigurationException {
                    if ("http://xml.org/sax/features/validation".equals(featureId)) {
                        return false;
                    }
                    return LSPXMLParserConfiguration.this.getFeature(featureId);
                }
            };
            validator.reset(disableDTDComponent);
        }
    }

    @Override
    protected void configurePipeline() {
        super.configurePipeline();
        this.configureExternalDTDPipeline();
    }

    @Override
    protected void configureXML11Pipeline() {
        super.configureXML11Pipeline();
        this.configureExternalDTDPipeline();
    }

    private void configureExternalDTDPipeline() {
        if (this.externalDTDValidator == null) {
            this.externalDTDValidator = new ExternalXMLDTDValidator();
            this.addCommonComponent((XMLComponent)this.externalDTDValidator);
            this.externalDTDValidator.reset((XMLComponentManager)this);
        }
        XMLDocumentSource prev = null;
        if (this.fFeatures.get("http://apache.org/xml/features/validation/schema") == Boolean.TRUE) {
            prev = this.fSchemaValidator.getDocumentSource();
        } else {
            prev = this.fLastComponent;
            this.fLastComponent = this.externalDTDValidator;
        }
        XMLDocumentHandler next = prev.getDocumentHandler();
        prev.setDocumentHandler((XMLDocumentHandler)this.externalDTDValidator);
        this.externalDTDValidator.setDocumentSource(prev);
        if (next != null) {
            this.externalDTDValidator.setDocumentHandler(next);
            next.setDocumentSource((XMLDocumentSource)this.externalDTDValidator);
        }
        if (this.fSchemaValidator != null) {
            AbstractLSPErrorReporter.initializeReporter(this.fSchemaValidator, this.getReporterForGrammar());
        }
    }

    private static int getPropertyValue(String propertyName, int defaultValue) {
        String value = System.getProperty(propertyName, "");
        if (!value.isEmpty()) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Error while getting system property '" + propertyName + "'.", e);
            }
        }
        return defaultValue;
    }
}

