/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.telemetry;

import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.extensions.contentmodel.model.ContentModelManager;
import org.eclipse.lemminx.telemetry.DocumentTelemetryInfo;
import org.eclipse.lemminx.telemetry.InitializationTelemetryInfo;
import org.eclipse.lemminx.telemetry.TelemetryCache;
import org.eclipse.lemminx.telemetry.TelemetryEvent;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.services.LanguageClient;

public class TelemetryManager {
    private static final String STARTUP_EVENT_NAME = "server.initialized";
    private static final String SHUTDOWN_EVENT_NAME = "server.shutdown";
    private static final String DOC_OPEN_EVENT_NAME = "server.document.open";
    private final LanguageClient languageClient;
    private final TelemetryCache telemetryCache;
    private boolean enabled;

    public TelemetryManager(LanguageClient languageClient) {
        this.languageClient = languageClient;
        this.telemetryCache = new TelemetryCache();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void onInitialized(InitializedParams params) {
        if (this.isEnabled()) {
            this.telemetryEvent(STARTUP_EVENT_NAME, InitializationTelemetryInfo.getInitializationTelemetryInfo());
        }
    }

    public void onDidOpen(DOMDocument document, ContentModelManager manager) {
        if (this.isEnabled()) {
            DocumentTelemetryInfo.collectDocumentTelemetryInfo(document, manager, this.telemetryCache);
        }
    }

    private void telemetryEvent(String eventName, Object object) {
        if (this.languageClient != null) {
            this.languageClient.telemetryEvent((Object)new TelemetryEvent(eventName, object));
        }
    }

    public void shutdown() {
        if (this.isEnabled()) {
            this.telemetryEvent(SHUTDOWN_EVENT_NAME, this.telemetryCache.getProperties());
        }
    }
}

