/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.dtd;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lsp4j.LocationLink;
import org.junit.jupiter.api.Test;

public class DTDDefinitionExtensionTest
extends AbstractCacheBasedTest {
    @Test
    public void noDefinition() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!EL|EMENT note (to,from,heading,body)>\r\n\t<!ELEMENT to (#PCDATA)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ELEMENT heading (#PCDATA)>\r\n\t<!ELEMENT body (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>\r\n<note version=\"0.9.0\">";
        XMLAssert.testDefinitionFor(xml, "test.xml", new LocationLink[0]);
    }

    @Test
    public void noDefinition2() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body)|>\r\n\t<!ELEMENT to (#PCDATA)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ELEMENT heading (#PCDATA)>\r\n\t<!ELEMENT body (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>\r\n<note version=\"0.9.0\">";
        XMLAssert.testDefinitionFor(xml, "test.xml", new LocationLink[0]);
    }

    @Test
    public void fromElementParameterToElementInsideDOCTYPE() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,hea|ding,body)>\r\n\t<!ELEMENT to (#PCDATA)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ELEMENT heading (#PCDATA)>\r\n\t<!ELEMENT body (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>\r\n<note version=\"0.9.0\">";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(2, 25, 2, 32), XMLAssert.r(5, 11, 5, 18)));
    }

    @Test
    public void specialCharacter() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,fo|nt-face,body)>\r\n\t<!ELEMENT to (#PCDATA)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ELEMENT font-face (#PCDATA)>\r\n\t<!ELEMENT body (#PCDATA)>\r\n\t<!ATTLIST note version CDATA #REQUIRED>\r\n]>\r\n<note version=\"0.9.0\">";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(2, 25, 2, 34), XMLAssert.r(5, 11, 5, 20)));
    }

    @Test
    public void fromAttrToElementInsideDOCTYPE() throws BadLocationException {
        String xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\r\n<!DOCTYPE note [\r\n\t<!ELEMENT note (to,from,heading,body)>\r\n\t<!ELEMENT to (#PCDATA)>\r\n\t<!ELEMENT from (#PCDATA)>\r\n\t<!ELEMENT heading (#PCDATA)>\r\n\t<!ELEMENT body (#PCDATA)>\r\n\t<!ATTLIST n|ote version CDATA #REQUIRED>\r\n]>\r\n<note version=\"0.9.0\">";
        XMLAssert.testDefinitionFor(xml, "test.xml", XMLAssert.ll("test.xml", XMLAssert.r(7, 11, 7, 15), XMLAssert.r(2, 11, 2, 15)));
    }

    @Test
    public void fromElementParameterToElementInsideDTD() throws BadLocationException {
        String xml = "<!ELEMENT note (to,from,hea|ding,body)>\r\n<!ELEMENT to (#PCDATA)>\r\n<!ELEMENT from (#PCDATA)>\r\n<!ELEMENT heading (#PCDATA)>\r\n<!ELEMENT body (#PCDATA)>\r\n<!ATTLIST note version CDATA #REQUIRED>";
        XMLAssert.testDefinitionFor(xml, "test.dtd", XMLAssert.ll("test.dtd", XMLAssert.r(0, 24, 0, 31), XMLAssert.r(3, 10, 3, 17)));
    }

    @Test
    public void fromAttrToElementInsideDTD() throws BadLocationException {
        String xml = "<!ELEMENT note (to,from,heading,body)>\r\n<!ELEMENT to (#PCDATA)>\r\n<!ELEMENT from (#PCDATA)>\r\n<!ELEMENT heading (#PCDATA)>\r\n<!ELEMENT body (#PCDATA)>\r\n<!ATTLIST n|ote version CDATA #REQUIRED>";
        XMLAssert.testDefinitionFor(xml, "test.dtd", XMLAssert.ll("test.dtd", XMLAssert.r(5, 10, 5, 14), XMLAssert.r(0, 10, 0, 14)));
    }
}

