/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.services.format;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.settings.SharedSettings;
import org.eclipse.lsp4j.TextEdit;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class XMLFormatterTest
extends AbstractCacheBasedTest {
    @Test
    public void emptyXML() throws BadLocationException {
        String content;
        String expected = content = "";
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void bracket() throws BadLocationException {
        String content;
        String expected = content = "<";
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void closeStartTagMissing() throws BadLocationException {
        String content;
        String expected = content = "<a";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void closeTagMissing() throws BadLocationException {
        String content;
        String expected = content = "<a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void autoCloseTag() throws BadLocationException {
        String content = "<a/>";
        String expected = "<a />";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 2, 0, 2, " "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void selfClosingTag() throws BadLocationException {
        String content;
        String expected = content = "<a></a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void singleEndTag() throws BadLocationException {
        String content;
        String expected = content = "</a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidEndTag() throws BadLocationException {
        String content = "</";
        Object expected = content;
        XMLFormatterTest.assertFormat(content, (String)expected, new TextEdit[0]);
        content = "</a";
        expected = content;
        XMLFormatterTest.assertFormat(content, (String)expected, new TextEdit[0]);
        content = "<a></";
        expected = "<a>" + System.lineSeparator() + "</";
        XMLFormatterTest.assertFormat(content, (String)expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator()));
        XMLFormatterTest.assertFormat((String)expected, (String)expected, new TextEdit[0]);
    }

    @Test
    public void invalidEndTagInsideRoot() throws BadLocationException {
        String content;
        String expected = content = "<a>\r\n  <b>\r\n    </\r\n  </b>\r\n</a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void endTagMissing() throws BadLocationException {
        String content = "<foo>\r\n  <bar>\r\n    <toto></toto>\r\n</foo>";
        String expected = "<foo>\r\n  <bar>\r\n  <toto></toto>\r\n</foo>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(1, 7, 2, 4, "\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testUnclosedEndTagBracketTrailingElement() throws BadLocationException {
        String content = "<root>\r\n         <a> content </a\r\n      <b></b>\r\n</root>";
        String expected = "<root>\r\n  <a> content </a\r\n  <b></b>\r\n</root>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 6, 1, 9, "\r\n  "), XMLAssert.te(1, 24, 2, 6, "\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void endTagWithSpace() throws BadLocationException {
        String content = "<a></a        >";
        String expected = "<a></a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 6, 0, 14, ""));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void endTagWithLineBreak() throws BadLocationException {
        String content = "<a></a  \n      >";
        String expected = "<a></a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 6, 1, 6, ""));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void invalidAttribute() throws BadLocationException {
        String content;
        String expected = content = "<a bb=\"asd\" \"aaa\"> </a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidQuoteInTag() throws BadLocationException {
        String content;
        String expected = content = "<a'> </a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidEqualsInTag() throws BadLocationException {
        String content;
        String expected = content = "<a=";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidProcessingInstruction() throws BadLocationException {
        String content;
        String expected = content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?\r\n\t\t\t<a />";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void invalidTagName() throws BadLocationException {
        String content = "<message>\r\n\t  <table>\r\n\t    <tbody>\r\n\t      <%= for el <- @elements do %>\r\n\t        <tr>\r\n\t            <td><%= el.id %></td>\r\n\t        </tr>\r\n\t      <% end %>\r\n\t    </tbody>\r\n\t  </table>\r\n\t</message>";
        String expected = "<message>\r\n  <table>\r\n    <tbody>\r\n      <%= for el\r\n      <- @elements do %>\r\n      <tr>\r\n        <td>\r\n          <%= el.id %>\r\n        </td>\r\n      </tr>\r\n      <% end %>\r\n    </tbody>\r\n  </table>\r\n</message>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 9, 1, 3, "\r\n  "), XMLAssert.te(1, 10, 2, 5, "\r\n    "), XMLAssert.te(2, 12, 3, 7, "\r\n      "), XMLAssert.te(3, 17, 3, 18, "\r\n      "), XMLAssert.te(3, 36, 4, 9, "\r\n      "), XMLAssert.te(4, 13, 5, 13, "\r\n        "), XMLAssert.te(5, 17, 5, 17, "\r\n          "), XMLAssert.te(5, 29, 5, 29, "\r\n        "), XMLAssert.te(5, 34, 6, 9, "\r\n      "), XMLAssert.te(6, 14, 7, 7, "\r\n      "), XMLAssert.te(7, 16, 8, 5, "\r\n    "), XMLAssert.te(8, 13, 9, 3, "\r\n  "), XMLAssert.te(9, 11, 10, 1, "\r\n"));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void attrWithEqualsSpace() throws BadLocationException {
        String content = "<div  class = \"foo\">\n<br/>\n </div>";
        String expected = "<div class=\"foo\">\n  <br />\n</div>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "), XMLAssert.te(0, 11, 0, 12, ""), XMLAssert.te(0, 13, 0, 14, ""), XMLAssert.te(0, 20, 1, 0, "\n  "), XMLAssert.te(1, 3, 1, 3, " "), XMLAssert.te(1, 5, 2, 1, "\n"));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void attrValueWithLineBreakSpace() throws BadLocationException {
        String content = "<div  class = \n\"foo\">\n<br/>\n </div>";
        String expected = "<div class=\"foo\">\n  <br />\n</div>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 4, 0, 6, " "), XMLAssert.te(0, 11, 0, 12, ""), XMLAssert.te(0, 13, 1, 0, ""), XMLAssert.te(1, 6, 2, 0, "\n  "), XMLAssert.te(2, 3, 2, 3, " "), XMLAssert.te(2, 5, 3, 1, "\n"));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testInvalidAttr() throws BadLocationException {
        String content = "<asdf \"\"`=asdf />";
        String expected = "<asdf \"\" `= asdf />";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 8, 0, 8, " "), XMLAssert.te(0, 10, 0, 10, " "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueTwoLines() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n   |a             =         \"aa\"|>\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n    a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 3, "\r\n    "), XMLAssert.te(2, 4, 2, 17, ""), XMLAssert.te(2, 18, 2, 27, ""));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueTwoLinesWithoutPreserveAttrLineBreak() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        String content = "<xml>\r\n  <a \r\n   |a             =         \"aa\"|>\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 2, 3, " "), XMLAssert.te(2, 4, 2, 17, ""), XMLAssert.te(2, 18, 2, 27, ""));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLines() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >|\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n    a=\"aa\"\r\n  >\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 2, "\r\n    "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, "\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithoutPreserveAttrLineBreak() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >|\r\n    <b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 2, 2, " "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, ""));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChild() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n   |a          =        \r\n   \r\n   \"aa\">|<b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n    a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 3, "\r\n    "), XMLAssert.te(2, 4, 2, 14, ""), XMLAssert.te(2, 15, 4, 3, ""), XMLAssert.te(4, 8, 4, 8, "\r\n    "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChildWithoutPreserveAttrLineBreak() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        String content = "<xml>\r\n  <a \r\n   |a          =        \r\n   \r\n   \"aa\">|<b></b>\r\n  </a>\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b></b>\r\n  </a>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 2, 3, " "), XMLAssert.te(2, 4, 2, 14, ""), XMLAssert.te(2, 15, 4, 3, ""), XMLAssert.te(4, 8, 4, 8, "\r\n    "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChildrenSiblings() throws BadLocationException {
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >\r\n        <b>\r\n          <c></c>\r\n    </b>\r\n  </a>\r\n        <d></d>|\r\n</xml>";
        String expected = "<xml>\r\n  <a\r\n    a=\"aa\"\r\n  >\r\n    <b>\r\n      <c></c>\r\n    </b>\r\n  </a>\r\n  <d></d>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(1, 4, 2, 2, "\r\n    "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, "\r\n  "), XMLAssert.te(6, 3, 7, 8, "\r\n    "), XMLAssert.te(7, 11, 8, 10, "\r\n      "), XMLAssert.te(10, 6, 11, 8, "\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testAttributeNameValueMultipleLinesWithChildrenSiblingsWithoutPreserveAttrLineBreak() throws BadLocationException {
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setPreserveAttributeLineBreaks(false);
        String content = "<xml>\r\n  <a \r\n  |a\r\n  =\r\n  \"aa\"\r\n  \r\n  >\r\n        <b>\r\n          <c></c>\r\n    </b>\r\n  </a>\r\n        <d></d>|\r\n</xml>";
        String expected = "<xml>\r\n  <a a=\"aa\">\r\n    <b>\r\n      <c></c>\r\n    </b>\r\n  </a>\r\n  <d></d>\r\n</xml>";
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(1, 4, 2, 2, " "), XMLAssert.te(2, 3, 3, 2, ""), XMLAssert.te(3, 3, 4, 2, ""), XMLAssert.te(4, 6, 6, 2, ""), XMLAssert.te(6, 3, 7, 8, "\r\n    "), XMLAssert.te(7, 11, 8, 10, "\r\n      "), XMLAssert.te(10, 6, 11, 8, "\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testProlog() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?>\r\n";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 1, 0, ""));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog2() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?><a>bb</a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<a>bb</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 0, 49, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog3() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  ?><a><b>c</b></a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + "<a>" + System.lineSeparator() + "  <b>c</b>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, ""), XMLAssert.te(0, 49, 0, 49, System.lineSeparator()), XMLAssert.te(0, 52, 0, 52, System.lineSeparator() + "  "), XMLAssert.te(0, 60, 0, 60, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testProlog4WithUnknownVariable() throws BadLocationException {
        String content = "<?xml version=   \"1.0\"       encoding=\"UTF-8\"  unknown=\"unknownValue\" ?><a><b>c</b></a>";
        String expected = "<?xml version=\"1.0\" encoding=\"UTF-8\" unknown=\"unknownValue\"?>" + System.lineSeparator() + "<a>" + System.lineSeparator() + "  <b>c</b>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 14, 0, 17, ""), XMLAssert.te(0, 22, 0, 29, " "), XMLAssert.te(0, 45, 0, 47, " "), XMLAssert.te(0, 69, 0, 70, ""), XMLAssert.te(0, 72, 0, 72, System.lineSeparator()), XMLAssert.te(0, 75, 0, 75, System.lineSeparator() + "  "), XMLAssert.te(0, 83, 0, 83, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testPI() throws BadLocationException {
        String content = "<a><?m2e asd as das das ?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?m2e asd as das das?>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 23, 0, 24, ""), XMLAssert.te(0, 26, 0, 26, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testPINoContent() throws BadLocationException {
        String content = "<a><?m2e?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?m2e?>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 10, 0, 10, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDefinedPIWithVariables() throws BadLocationException {
        String content = "<a><?xml-stylesheet   href=\"my-style.css\"     type=   \"text/css\"?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-stylesheet href=\"my-style.css\" type=\"text/css\"?>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 19, 0, 22, " "), XMLAssert.te(0, 41, 0, 46, " "), XMLAssert.te(0, 51, 0, 54, ""), XMLAssert.te(0, 66, 0, 66, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testDefinedPIWithJustAttributeNames() throws BadLocationException {
        String content = "<a><?xml-stylesheet    href     type  =       attName?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-stylesheet href type= attName?>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 0, 3, System.lineSeparator() + "  "), XMLAssert.te(0, 19, 0, 23, " "), XMLAssert.te(0, 27, 0, 32, " "), XMLAssert.te(0, 36, 0, 38, ""), XMLAssert.te(0, 39, 0, 46, " "), XMLAssert.te(0, 55, 0, 55, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Disabled
    @Test
    public void testPIWithVariables() throws BadLocationException {
        String content = "<a><?xml-styleZZ   href=\"my-style.css\"     type=   \"text/css\"?></a>";
        String expected = "<a>" + System.lineSeparator() + "  <?xml-styleZZ href=\"my-style.css\" type=\"text/css\"?>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testComment() throws BadLocationException {
        String content = "<!-- CommentText --><a>Val</a>";
        String expected = "<!-- CommentText -->" + System.lineSeparator() + "<a>Val</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 20, 0, 20, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testComment2() throws BadLocationException {
        String content = "<!-- CommentText --><!-- Comment2 --><a>Val</a>";
        String expected = "<!-- CommentText --><!-- Comment2 -->" + System.lineSeparator() + "<a>Val</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 37, 0, 37, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentNested() throws BadLocationException {
        String content = "<a><!-- CommentText --></a>";
        String expected = "<a><!-- CommentText -->" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 23, 0, 23, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentNested2() throws BadLocationException {
        String content = "<a><!-- CommentText --><b><!-- Comment2 --></b></a>";
        String expected = "<a><!-- CommentText -->" + System.lineSeparator() + "  <b><!-- Comment2 -->" + System.lineSeparator() + "  </b>" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 23, 0, 23, System.lineSeparator() + "  "), XMLAssert.te(0, 43, 0, 43, System.lineSeparator() + "  "), XMLAssert.te(0, 47, 0, 47, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentMultiLineContent() throws BadLocationException {
        String content = "<a><!-- CommentText" + System.lineSeparator() + "2222" + System.lineSeparator() + "  3333 --></a>";
        String expected = "<a><!-- CommentText" + System.lineSeparator() + "2222" + System.lineSeparator() + "  3333 -->" + System.lineSeparator() + "</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(2, 10, 2, 10, System.lineSeparator()));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentLongWrap() throws BadLocationException {
        String content = "<a>\n  Content <!-- comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment --></a>";
        String expected = "<a> Content <!-- comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment --></a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 2, " "), XMLAssert.te(1, 78, 1, 79, "\n  "), XMLAssert.te(1, 150, 1, 151, "\n  "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentLongWrapJoinContentLines() throws BadLocationException {
        String content = "<a>\n  Content <!-- comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment --></a>";
        String expected = "<a> Content <!-- comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment --></a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setJoinContentLines(true);
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 2, " "), XMLAssert.te(1, 78, 1, 79, "\n  "), XMLAssert.te(1, 150, 1, 151, "\n  "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentLongTextContentWrap() throws BadLocationException {
        String content = "<a> content content content content content content content content content content content content content content content content content content <!-- comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment -->\n</a>";
        String expected = "<a> content content content content content content content content content\n  content content content content content content content content content <!--\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment -->\n</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(0, 75, 0, 76, "\n  "), XMLAssert.te(0, 152, 0, 153, "\n  "), XMLAssert.te(0, 224, 0, 225, "\n  "), XMLAssert.te(0, 296, 0, 297, "\n  "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentLongTextContentWrapNewLine() throws BadLocationException {
        String content = "<a>\n  content content content content content content content content content content content content content content content content content content <!-- comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment comment -->\n</a>";
        String expected = "<a> content content content content content content content content content\n  content content content content content content content content content <!--\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment comment comment\n  comment comment comment comment comment comment comment -->\n</a>";
        SharedSettings settings = new SharedSettings();
        settings.getFormattingSettings().setMaxLineWidth(80);
        XMLFormatterTest.assertFormat(content, expected, settings, XMLAssert.te(0, 3, 1, 2, " "), XMLAssert.te(1, 73, 1, 74, "\n  "), XMLAssert.te(1, 150, 1, 151, "\n  "), XMLAssert.te(1, 222, 1, 223, "\n  "), XMLAssert.te(1, 294, 1, 295, "\n  "));
        XMLFormatterTest.assertFormat(expected, expected, settings, new TextEdit[0]);
    }

    @Test
    public void testCommentNotClosed() throws BadLocationException {
        String content;
        String expected = content = "<foo>\r\n  <!-- \r\n</foo>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testCommentWithRange() throws BadLocationException {
        String content = "<foo>\r\n  <!-- |<bar>|\r\n  </bar>\r\n\t-->\r\n</foo>";
        String expected = "<foo>\r\n  <!-- <bar>\r\n  </bar>\r\n\t-->\r\n</foo>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testElementContentNotNormalized() throws BadLocationException {
        String content = "<a>\r Content\r     Content2\r      Content3\r Content4\r  Content5\r</a>";
        String expected = "<a>\r  Content\r  Content2\r  Content3\r  Content4\r  Content5\r</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 1, "\r  "), XMLAssert.te(1, 8, 2, 5, "\r  "), XMLAssert.te(2, 13, 3, 6, "\r  "), XMLAssert.te(3, 14, 4, 1, "\r  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testContentFormatting2() throws BadLocationException {
        String content = "<a>\r Content\r <b>\r   Content2\r    Content3\r </b>\r</a>";
        String expected = "<a> Content <b>\r    Content2\r    Content3\r  </b>\r</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 1, " "), XMLAssert.te(1, 8, 2, 1, " "), XMLAssert.te(2, 4, 3, 3, "\r    "), XMLAssert.te(4, 12, 5, 1, "\r  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testContentFormattingDontMoveEndTag() throws BadLocationException {
        String content = "<a>\r Content\r <b>\r   Content2\r    Content3     </b>\r</a>";
        String expected = "<a> Content <b>\r    Content2\r    Content3 </b>\r</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 1, 1, " "), XMLAssert.te(1, 8, 2, 1, " "), XMLAssert.te(2, 4, 3, 3, "\r    "), XMLAssert.te(4, 12, 4, 17, " "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    @Test
    public void testContentFormatting3() throws BadLocationException {
        String content = "<a> content </a>";
        String expected = "<a> content </a>";
        XMLFormatterTest.assertFormat(content, expected, new TextEdit[0]);
    }

    @Test
    public void testContentFormatting6() throws BadLocationException {
        String content = "<a>\r\r Content\r</a>";
        String expected = "<a>\r\r  Content\r</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 2, 1, "\r\r  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
        content = "<a>\r\n\r\n Content\r\n</a>";
        expected = "<a>\r\n\r\n  Content\r\n</a>";
        XMLFormatterTest.assertFormat(content, expected, XMLAssert.te(0, 3, 2, 1, "\r\n\r\n  "));
        XMLFormatterTest.assertFormat(expected, expected, new TextEdit[0]);
    }

    private static void assertFormat(String unformatted, String actual, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterTest.assertFormat(unformatted, actual, new SharedSettings(), expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterTest.assertFormat(unformatted, expected, sharedSettings, "test://test.html", expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, TextEdit ... expectedEdits) throws BadLocationException {
        XMLFormatterTest.assertFormat(unformatted, expected, sharedSettings, uri, true, expectedEdits);
    }

    private static void assertFormat(String unformatted, String expected, SharedSettings sharedSettings, String uri, Boolean considerRangeFormat, TextEdit ... expectedEdits) throws BadLocationException {
        XMLAssert.assertFormat(null, unformatted, expected, sharedSettings, uri, considerRangeFormat, expectedEdits);
    }
}

