/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.relaxng.xml.typedefinition;

import org.eclipse.lemminx.AbstractCacheBasedTest;
import org.eclipse.lemminx.XMLAssert;
import org.eclipse.lemminx.commons.BadLocationException;
import org.eclipse.lemminx.services.XMLLanguageService;
import org.junit.jupiter.api.Test;

public class RelaxNGTypeDefinitionTest
extends AbstractCacheBasedTest {
    @Test
    public void toElementDeclaration() throws BadLocationException {
        String xmlFile = "src/test/resources/relaxng/tei.xml";
        String xsdFile = "tei_all.rng";
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<T|EI>\r\n\r\n</TEI>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 1, 1, 4), XMLAssert.r(7956, 15, 7956, 25)));
    }

    @Test
    public void toAttributeDeclaration() throws BadLocationException {
        String xmlFile = "src/test/resources/relaxng/tei.xml";
        String xsdFile = "tei_all.rng";
        String xml = "<?xml-model href=\"tei_all.rng\" ?>\r\n<TEI ce|rt=\"\">\r\n\r\n</TEI>";
        XMLLanguageService xmlLanguageService = new XMLLanguageService();
        String targetSchemaURI = xmlLanguageService.getResolverExtensionManager().resolve(xmlFile, null, xsdFile);
        XMLAssert.testTypeDefinitionFor(xmlLanguageService, xml, xmlFile, XMLAssert.ll(targetSchemaURI, XMLAssert.r(1, 5, 1, 12), XMLAssert.r(853, 20, 853, 31)));
    }
}

